/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.action;

import java.io.File;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;

public class AddSelectedLibToCurrentReportDesignAction
extends Action {
    private StructuredViewer viewer;
    private static final String ACTION_TEXT = Messages.getString((String)"UseLibraryAction.Text");

    public AddSelectedLibToCurrentReportDesignAction(StructuredViewer viewer) {
        super(ACTION_TEXT);
        this.viewer = viewer;
    }

    public boolean isEnabled() {
        LibraryHandle library = this.getSelectedLibrary();
        ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (library != null && moduleHandle != null) {
            return !moduleHandle.isInclude(library);
        }
        return false;
    }

    public void run() {
        if (this.isEnabled()) {
            try {
                UIUtil.includeLibrary((LibraryHandle)this.getSelectedLibrary());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    private LibraryHandle getSelectedLibrary() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection != null && selection.getFirstElement() instanceof File) {
            File file = (File)selection.getFirstElement();
            try {
                return SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(file.getAbsolutePath());
            }
            catch (DesignFileException e) {
                return null;
            }
        }
        return null;
    }
}

