/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.core.model.views.outline.ReportElementModel;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.gef.commands.Command;

public class FlowMoveChildCommand
extends Command {
    private static final String TRANS_LABEL_MOVE_ELEMENT = Messages.getString("FlowMoveChildCommand.transLabel.moveElement");
    private Object child = null;
    private Object after = null;
    private Object container = null;

    public FlowMoveChildCommand(Object child, Object after, Object container) {
        this.child = child;
        this.after = after;
        this.container = container;
    }

    public void execute() {
        if (DesignerConstants.TRACING_COMMANDS) {
            System.out.println("FlowMoveChildCommand >> Starts ... ");
        }
        try {
            DesignElementHandle containerHandle = null;
            int slotID = -1;
            int pos = -1;
            if (this.container instanceof ListBandProxy) {
                containerHandle = ((ListBandProxy)this.container).getSlotHandle().getElementHandle();
                slotID = ((ListBandProxy)this.container).getSlotHandle().getSlotID();
                pos = DEUtil.findInsertPosition(containerHandle, (DesignElementHandle)this.after, slotID);
            } else if (this.container instanceof DesignElementHandle) {
                containerHandle = (DesignElementHandle)this.container;
                slotID = DEUtil.getSlotID(containerHandle, this.after);
                pos = DEUtil.findInsertPosition(containerHandle, (DesignElementHandle)this.after);
            } else if (this.container instanceof ReportElementModel) {
                containerHandle = ((ReportElementModel)this.container).getElementHandle();
                slotID = ((ReportElementModel)this.container).getSlotId();
                pos = DEUtil.findInsertPosition(containerHandle, (DesignElementHandle)this.after, slotID);
            }
            DesignElementHandle handle = (DesignElementHandle)this.child;
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans(TRANS_LABEL_MOVE_ELEMENT);
            handle.moveTo(containerHandle, slotID);
            containerHandle.getSlot(slotID).shift(handle, pos);
            stack.commit();
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("FlowMoveChildCommand >> Finished. Moved " + DEUtil.getDisplayLabel(handle) + " to the slot " + slotID + " of " + DEUtil.getDisplayLabel(containerHandle) + ",Position: " + pos);
            }
        }
        catch (ContentException e) {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("FlowMoveChildCommand >> Failed");
            }
            e.printStackTrace();
        }
    }
}

