/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.gef.commands.Command;

public class SetPropertyCommand
extends Command {
    private Object model;
    private Map extendsData;

    public SetPropertyCommand(Object model, Map extendsData) {
        this.model = model;
        this.extendsData = extendsData;
    }

    public void execute() {
        if (DesignerConstants.TRACING_COMMANDS) {
            System.out.println("SetPropertyCommand >> Starts ...");
        }
        try {
            DesignElementHandle handle = (DesignElementHandle)this.model;
            List elementProperties = handle.getDefn().getProperties();
            Iterator it = elementProperties.iterator();
            while (it.hasNext()) {
                String key = ((IElementPropertyDefn)it.next()).getName();
                Object value = null;
                Object v = this.extendsData.get(DEUtil.getGUIPropertyKey(key));
                value = v;
                if (v == null) continue;
                if (DesignerConstants.TRACING_COMMANDS) {
                    System.out.println("SetPropertyCommand >>  Target: " + DEUtil.getDisplayLabel(handle) + ",Property: " + key + ",Value: " + value);
                }
                handle.setProperty(key, value);
            }
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("SetPropertyCommand >> Finished");
            }
        }
        catch (SemanticException e) {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("SetPropertyCommand >> Failed");
            }
            e.printStackTrace();
        }
    }
}

