/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model;

import com.ibm.icu.util.ULocale;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.birt.report.designer.core.util.mediator.ReportMediator;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.DisposeEvent;
import org.eclipse.birt.report.model.api.core.IDisposeListener;
import org.eclipse.birt.report.model.api.metadata.IMetaDataDictionary;

public class SessionHandleAdapter {
    public static final int UNKNOWFILE = -1;
    public static int DESIGNEFILE = 0;
    public static int LIBRARYFILE = 1;
    public static int TEMPLATEFILE = 2;
    private int type = DESIGNEFILE;
    IDisposeListener disposeLitener = new IDisposeListener(){

        public void moduleDisposed(ModuleHandle targetElement, DisposeEvent ev) {
            ReportMediator media = (ReportMediator)SessionHandleAdapter.this.mediatorMap.get(targetElement);
            if (media != null) {
                media.dispose();
            }
            SessionHandleAdapter.this.mediatorMap.remove(targetElement);
            targetElement.removeDisposeListener((IDisposeListener)this);
        }
    };
    private Map mediatorMap = new WeakHashMap();
    private static SessionHandleAdapter sessionAdapter;
    private SessionHandle sessionHandle;
    private ModuleHandle model;

    private SessionHandleAdapter() {
    }

    public int getFileType() {
        return this.type;
    }

    public static SessionHandleAdapter getInstance() {
        if (sessionAdapter == null) {
            sessionAdapter = new SessionHandleAdapter();
        }
        return sessionAdapter;
    }

    public SessionHandle getSessionHandle() {
        if (this.sessionHandle == null) {
            this.sessionHandle = DesignEngine.newSession((ULocale)ULocale.getDefault());
            IMetaDataDictionary metadata = DesignEngine.getMetaDataDictionary();
            metadata.enableElementID();
        }
        this.sessionHandle.activate();
        return this.sessionHandle;
    }

    public ModuleHandle init(String fileName, InputStream input, Map properties) throws DesignFileException {
        ModuleHandle handle = this.init(fileName, input);
        this.postInit(handle, properties);
        this.setReportDesignHandle(handle);
        return handle;
    }

    public ModuleHandle init(String fileName, InputStream input) throws DesignFileException {
        ModuleHandle handle = null;
        handle = this.getSessionHandle().openModule(fileName, input);
        this.postInit(handle, null);
        this.setReportDesignHandle(handle);
        return handle;
    }

    private void postInit(ModuleHandle handle, Map properties) {
        String createInfo;
        if (!(properties == null || properties.isEmpty() || (createInfo = this.model.getCreatedBy()) != null && createInfo.length() != 0)) {
            try {
                handle.initializeModule(properties);
            }
            catch (SemanticException e) {
                // empty catch block
            }
        }
        SimpleMasterPageHandle masterPage = null;
        if (handle.getMasterPages().getCount() == 0) {
            masterPage = handle.getElementFactory().newSimpleMasterPage(null);
            try {
                handle.getMasterPages().add((DesignElementHandle)masterPage);
            }
            catch (ContentException e) {
                new DesignFileException(handle.getFileName(), (Exception)((Object)e));
            }
            catch (NameException e) {
                new DesignFileException(handle.getFileName(), (Exception)((Object)e));
            }
        }
    }

    public ModuleHandle creatReportDesign() {
        return this.getSessionHandle().createDesign();
    }

    public ModuleHandle getReportDesignHandle() {
        return this.model;
    }

    public void setReportDesignHandle(ModuleHandle handle) {
        this.model = handle;
    }

    public CommandStack getCommandStack() {
        if (this.getReportDesignHandle() != null) {
            return this.getReportDesignHandle().getCommandStack();
        }
        return null;
    }

    public MasterPageHandle getMasterPageHandle() {
        return this.getMasterPageHandle(this.getReportDesignHandle());
    }

    public MasterPageHandle getMasterPageHandle(ModuleHandle handle) {
        SlotHandle slotHandle = handle.getMasterPages();
        Iterator iter = slotHandle.iterator();
        return (MasterPageHandle)iter.next();
    }

    public ReportMediator getMediator(ModuleHandle handle) {
        ReportMediator mediator;
        if (handle != null) {
            handle.addDisposeListener(this.disposeLitener);
        }
        if ((mediator = (ReportMediator)this.mediatorMap.get(handle)) == null) {
            mediator = new ReportMediator();
            this.mediatorMap.put(handle, mediator);
        }
        return mediator;
    }

    public ReportMediator getMediator() {
        return this.getMediator(this.getReportDesignHandle());
    }

    public void resetReportDesign(Object oldObj, Object newObj) {
        ReportMediator mediator = (ReportMediator)this.mediatorMap.get(oldObj);
        if (mediator == null) {
            return;
        }
        this.mediatorMap.remove(oldObj);
        this.mediatorMap.put(newObj, mediator);
    }

    public void clear(ModuleHandle handle) {
        this.mediatorMap.remove(handle);
        if (handle == this.getReportDesignHandle()) {
            this.setReportDesignHandle(null);
        }
    }
}

