/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model.schematic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.core.model.ITableAdapterHelper;
import org.eclipse.birt.report.designer.core.model.ReportItemtHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.CellHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ColumnHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.RowHandleAdapter;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.util.Assert;

public class TableHandleAdapter
extends ReportItemtHandleAdapter {
    private static final String TRANS_LABEL_INSERT_ROW;
    private static final String NAME_NULL = "";
    private static final String NAME_DETAIL;
    private static final String NAME_FOOTER;
    private static final String NAME_HEADRER;
    private static final String TRANS_LABEL_NOT_INCLUDE;
    private static final String TRANS_LABEL_INCLUDE;
    private static final String TRANS_LABEL_INSERT_GROUP;
    private static final String TRANS_LABEL_SPLIT_CELLS;
    private static final String TRANS_LABEL_DELETE_ROW;
    private static final String TRANS_LABEL_DELETE_ROWS;
    private static final String TRANS_LABEL_DELETE_COLUMN;
    private static final String TRANS_LABEL_DELETE_COLUMNS;
    private static final String TRANS_LABEL_INSERT_COLUMN;
    private static final String TRANS_LABEL_DELETE_GROUP;
    public static final int HEADER = 0;
    public static final int DETAIL = 2;
    public static final int FOOTER = 3;
    public static final String TABLE_HEADER = "H";
    public static final String TABLE_FOOTER = "F";
    public static final String TABLE_DETAIL = "D";
    public static final String TABLE_GROUP_HEADER = "gh";
    public static final String TABLE_GROUP_FOOTER = "gf";
    public static final String DEFAULT_WIDTH = "100.0%";
    private HashMap rowInfo = new HashMap();
    private List rows = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public TableHandleAdapter(ReportItemHandle table, IModelAdapterHelper mark) {
        super(table, mark);
    }

    public List getChildren() {
        ArrayList children = new ArrayList();
        SlotHandle header = this.getTableHandle().getHeader();
        Iterator headerIter = header.iterator();
        while (headerIter.hasNext()) {
            children.addAll(((RowHandle)headerIter.next()).getCells().getContents());
        }
        SlotHandle group = this.getTableHandle().getGroups();
        Iterator groupIter = group.iterator();
        while (groupIter.hasNext()) {
            TableGroupHandle tableGroups = (TableGroupHandle)groupIter.next();
            SlotHandle groupHeaders = tableGroups.getHeader();
            Iterator groupHeaderIter = groupHeaders.iterator();
            while (groupHeaderIter.hasNext()) {
                children.addAll(((RowHandle)groupHeaderIter.next()).getCells().getContents());
            }
        }
        SlotHandle detail = this.getTableHandle().getDetail();
        Iterator detailIter = detail.iterator();
        while (detailIter.hasNext()) {
            children.addAll(((RowHandle)detailIter.next()).getCells().getContents());
        }
        ListIterator groupIter2 = group.getContents().listIterator(group.getCount());
        while (groupIter2.hasPrevious()) {
            TableGroupHandle tableGroups = (TableGroupHandle)groupIter2.previous();
            SlotHandle groupFooters = tableGroups.getFooter();
            Iterator groupFooterIter = groupFooters.iterator();
            while (groupFooterIter.hasNext()) {
                children.addAll(((RowHandle)groupFooterIter.next()).getCells().getContents());
            }
        }
        SlotHandle footer = this.getTableHandle().getFooter();
        Iterator footerIter = footer.iterator();
        while (footerIter.hasNext()) {
            children.addAll(((RowHandle)footerIter.next()).getCells().getContents());
        }
        this.removePhantomCells(children);
        return children;
    }

    protected void removePhantomCells(List children) {
        ArrayList phantomCells = new ArrayList();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            Object cell = iter.next();
            CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(cell);
            if (cellAdapt.getRowNumber() != 0 && cellAdapt.getColumnNumber() != 0) continue;
            phantomCells.add(cell);
        }
        iter = phantomCells.iterator();
        while (iter.hasNext()) {
            children.remove(iter.next());
        }
    }

    protected void insertRowInfo(SlotHandle slotHandle, String displayName, String type) {
        Iterator it = slotHandle.iterator();
        while (it.hasNext()) {
            RowHandle handle = (RowHandle)it.next();
            this.rows.add(handle);
            RowUIInfomation info = new RowUIInfomation(this.getColumnCount());
            info.setType(type);
            info.setRowDisplayName(displayName);
            info.addChildren(handle.getCells().getContents());
            this.rowInfo.put(handle, info);
        }
    }

    public List getRows() {
        if (this.checkDirty() || this.rowInfo.isEmpty()) {
            this.reload();
        }
        return this.rows;
    }

    protected void clearBuffer() {
        this.rowInfo.clear();
        this.rows.clear();
    }

    public void initRowsInfo() {
        this.clearBuffer();
        this.buildRowInfo();
        this.caleRowInfo(this.rows);
    }

    protected void buildRowInfo() {
        TableGroupHandle tableGroup;
        this.insertRowInfo(this.getTableHandle().getHeader(), TABLE_HEADER, TABLE_HEADER);
        SlotHandle groups = this.getTableHandle().getGroups();
        int number = 0;
        ListIterator itor = groups.iterator();
        while (itor.hasNext()) {
            tableGroup = (TableGroupHandle)itor.next();
            this.insertRowInfo(tableGroup.getHeader(), Integer.toString(++number), TABLE_GROUP_HEADER);
        }
        this.insertRowInfo(this.getTableHandle().getDetail(), TABLE_DETAIL, TABLE_DETAIL);
        number = groups.getCount();
        itor = groups.getContents().listIterator(number);
        while (itor.hasPrevious()) {
            tableGroup = (TableGroupHandle)itor.previous();
            this.insertRowInfo(tableGroup.getFooter(), Integer.toString(number), TABLE_GROUP_FOOTER);
            --number;
        }
        this.insertRowInfo(this.getTableHandle().getFooter(), TABLE_FOOTER, TABLE_FOOTER);
    }

    protected void caleRowInfo(List children) {
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            RowHandleAdapter adapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(children.get(i));
            List cellChildren = adapt.getChildren();
            int len = cellChildren.size();
            RowUIInfomation info = (RowUIInfomation)this.rowInfo.get(children.get(i));
            for (int j = 0; j < len; ++j) {
                CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(cellChildren.get(j));
                int cellIndex = info.getAllChildren().indexOf(cellChildren.get(j));
                if (cellAdapt.getColumnSpan() != 1 && cellIndex + 2 <= info.getAllChildren().size() && cellIndex >= 0) {
                    this.fillRowInfoChildrenList(children.get(i), cellIndex + 2, cellAdapt.getColumnSpan() - 1, cellChildren.get(j));
                }
                if (cellAdapt.getRowSpan() == 1) continue;
                for (int k = i + 1; k < i + cellAdapt.getRowSpan(); ++k) {
                    if (cellIndex < 0 || cellIndex + cellAdapt.getColumnSpan() > info.getAllChildren().size()) continue;
                    this.fillRowInfoChildrenList(children.get(k), cellIndex + 1, cellAdapt.getColumnSpan(), cellChildren.get(j));
                }
            }
        }
    }

    private void fillRowInfoChildrenList(Object row, int columnNumber, int colSpan, Object cell) {
        RowUIInfomation info = (RowUIInfomation)this.rowInfo.get(row);
        if (info == null) {
            return;
        }
        for (int i = 0; i < colSpan; ++i) {
            info.addChildren(cell, columnNumber + i - 1);
        }
    }

    public RowUIInfomation getRowInfo(Object row) {
        if (this.checkDirty()) {
            this.reload();
        }
        return (RowUIInfomation)this.rowInfo.get(row);
    }

    public void reload() {
        super.reload();
        this.initRowsInfo();
        if (this.getModelAdaptHelper() != null) {
            this.getModelAdaptHelper().markDirty(false);
        }
    }

    public List getColumns() {
        return this.getTableHandle().getColumns().getContents();
    }

    public Object getRow(int i) {
        List list = this.getRows();
        if (i >= 1 && i <= list.size()) {
            return list.get(i - 1);
        }
        return null;
    }

    public Object getColumn(int i) {
        List list = this.getColumns();
        if (i >= 1 && i <= list.size()) {
            return list.get(i - 1);
        }
        return null;
    }

    public Object getCell(int rowNumber, int columnNumber, boolean bool) {
        Object obj = this.getRow(rowNumber);
        RowUIInfomation info = this.getRowInfo(obj);
        Object retValue = null;
        if (info != null && columnNumber >= 1 && info.getAllChildren().size() >= columnNumber) {
            retValue = info.getAllChildren().get(columnNumber - 1);
        }
        if (bool) {
            return retValue;
        }
        if (HandleAdapterFactory.getInstance().getCellHandleAdapter(retValue).getRowNumber() != rowNumber || HandleAdapterFactory.getInstance().getCellHandleAdapter(retValue).getColumnNumber() != columnNumber) {
            retValue = null;
        }
        return retValue;
    }

    public Object getCell(int i, int j) {
        return this.getCell(i, j, true);
    }

    public Dimension calculateSize() {
        if (!(this.getModelAdaptHelper() instanceof ITableAdapterHelper)) {
            return new Dimension();
        }
        ITableAdapterHelper tableHelper = (ITableAdapterHelper)this.getModelAdaptHelper();
        int columnCount = this.getColumnCount();
        int samColumnWidth = 0;
        for (int i = 0; i < columnCount; ++i) {
            samColumnWidth += tableHelper.caleVisualWidth(i + 1);
        }
        int rowCount = this.getRowCount();
        int samRowHeight = 0;
        for (int i = 0; i < rowCount; ++i) {
            samRowHeight += tableHelper.caleVisualHeight(i + 1);
        }
        return new Dimension(samColumnWidth, samRowHeight).expand(tableHelper.getInsets().getWidth(), tableHelper.getInsets().getHeight());
    }

    public void ajustSize(Dimension size) throws SemanticException {
        if (!(this.getModelAdaptHelper() instanceof ITableAdapterHelper)) {
            return;
        }
        ITableAdapterHelper tableHelper = (ITableAdapterHelper)this.getModelAdaptHelper();
        size = size.shrink(tableHelper.getInsets().getWidth(), tableHelper.getInsets().getHeight());
        int columnCount = this.getColumnCount();
        int samColumnWidth = 0;
        for (int i = 0; i < columnCount; ++i) {
            if (i == columnCount - 1) continue;
            samColumnWidth += tableHelper.caleVisualWidth(i + 1);
        }
        int lastColumnWidth = size.width - samColumnWidth;
        if (lastColumnWidth < tableHelper.getMinWidth(columnCount)) {
            lastColumnWidth = tableHelper.getMinWidth(columnCount);
            HandleAdapterFactory.getInstance().getColumnHandleAdapter(this.getColumn(columnCount)).setWidth(lastColumnWidth);
        } else if (lastColumnWidth != tableHelper.caleVisualWidth(columnCount)) {
            HandleAdapterFactory.getInstance().getColumnHandleAdapter(this.getColumn(columnCount)).setWidth(lastColumnWidth);
        }
        int rowCount = this.getRowCount();
        int samRowHeight = 0;
        for (int i = 0; i < rowCount; ++i) {
            if (i == rowCount - 1) continue;
            samRowHeight += tableHelper.caleVisualHeight(i + 1);
        }
        int lastRowHeight = size.height - samRowHeight;
        if (lastRowHeight < tableHelper.getMinHeight(rowCount)) {
            lastRowHeight = tableHelper.getMinHeight(rowCount);
            HandleAdapterFactory.getInstance().getRowHandleAdapter(this.getRow(rowCount)).setHeight(lastRowHeight);
        } else if (lastRowHeight != tableHelper.caleVisualHeight(rowCount)) {
            HandleAdapterFactory.getInstance().getRowHandleAdapter(this.getRow(rowCount)).setHeight(lastRowHeight);
        }
        HandleAdapterFactory.getInstance().getRowHandleAdapter(this.getRow(rowCount)).setHeight(lastRowHeight);
        this.setSize(new Dimension(samColumnWidth + lastColumnWidth, samRowHeight + lastRowHeight).expand(tableHelper.getInsets().getWidth(), tableHelper.getInsets().getHeight()));
    }

    public int getMinHeight(int rowNumber) {
        return 23;
    }

    public int getMinWidth(int columnNumber) {
        return 20;
    }

    public Dimension getClientAreaSize() {
        if (this.getModelAdaptHelper() instanceof ITableAdapterHelper) {
            return ((ITableAdapterHelper)this.getModelAdaptHelper()).getClientAreaSize();
        }
        return new Dimension();
    }

    private TableHandle getTableHandle() {
        return (TableHandle)this.getHandle();
    }

    public String getDefinedWidth() {
        DimensionHandle handle = ((ReportItemHandle)this.getHandle()).getWidth();
        if (handle.getUnits() == null || handle.getUnits().length() == 0) {
            return DEFAULT_WIDTH;
        }
        if ("%".equals(handle.getUnits())) {
            return handle.getMeasure() + "%";
        }
        int px = (int)DEUtil.convertoToPixel(handle);
        if (px <= 0) {
            return null;
        }
        return String.valueOf(px);
    }

    public int getDefaultWidth(int colNumber) {
        Dimension size = this.getDefaultSize();
        Object obj = this.getRow(1);
        if (obj == null) {
            return size.width;
        }
        int allNumbers = this.getColumnCount();
        if (allNumbers <= 0) {
            return size.width;
        }
        if (colNumber <= 0) {
            return size.width;
        }
        int width = size.width;
        int columnNumber = allNumbers;
        for (int i = 1; i < columnNumber + 1; ++i) {
            Object column = this.getColumn(i);
            ColumnHandleAdapter adapt = HandleAdapterFactory.getInstance().getColumnHandleAdapter(column);
            if (!adapt.isCustomWidth()) continue;
            --allNumbers;
            width -= adapt.getWidth();
        }
        if (colNumber == allNumbers) {
            return width / allNumbers + width % allNumbers;
        }
        return width / allNumbers;
    }

    public int getRowCount() {
        return this.getRows().size();
    }

    public int getColumnCount() {
        return this.getColumns().size();
    }

    public Object getDataSet() {
        return this.getTableHandle().getDataSet();
    }

    public void insertRow(int rowNumber, int parentRowNumber) throws SemanticException {
        this.transStar(TRANS_LABEL_INSERT_ROW);
        Assert.isLegal((rowNumber != 0 ? 1 : 0) != 0);
        int realRowNumber = rowNumber > 0 ? parentRowNumber + rowNumber : parentRowNumber + rowNumber + 1;
        int shiftPos = rowNumber > 0 ? rowNumber : rowNumber + 1;
        RowHandle row = (RowHandle)this.getRow(parentRowNumber);
        RowHandleAdapter adapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(row);
        RowHandle copy = (RowHandle)adapt.copy();
        RowUIInfomation rowInfo = this.getRowInfo(row);
        List rowList = rowInfo.getAllChildren();
        int rowSize = rowList.size();
        for (int i = 0; i < rowSize; ++i) {
            CellHandle parentCell = (CellHandle)rowList.get(i);
            CellHandle cell = this.getCellHandleCopy(parentCell);
            copy.getSlot(0).add((DesignElementHandle)cell);
        }
        SlotHandle parentHandle = row.getContainerSlotHandle();
        parentHandle.add((DesignElementHandle)copy);
        int pos = parentHandle.findPosn((DesignElementHandle)row);
        parentHandle.shift((DesignElementHandle)copy, pos + shiftPos);
        RowHandleAdapter copyAdapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(copy);
        List copyChildren = copyAdapt.getChildren();
        RowUIInfomation info = this.getRowInfo(copy);
        List list = info.getAllChildren();
        ArrayList<Integer> temp = new ArrayList<Integer>();
        int size = list.size();
        ArrayList hasAdjust = new ArrayList();
        for (int i = 0; i < size; ++i) {
            Object fillCell = list.get(i);
            CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(fillCell);
            if (cellAdapt.getRowNumber() == realRowNumber) continue;
            if (!hasAdjust.contains(fillCell)) {
                cellAdapt.setRowSpan(cellAdapt.getRowSpan() + 1);
                hasAdjust.add(fillCell);
            }
            temp.add(new Integer(i));
        }
        int copyRowSize = copyChildren.size();
        for (int i = 0; i < copyRowSize; ++i) {
            if (!temp.contains(new Integer(i))) continue;
            ((CellHandle)copyChildren.get(i)).drop();
        }
        this.transEnd();
    }

    public void insertRows(int rowCount, int baseRowNumber) throws SemanticException {
        this.transStar(TRANS_LABEL_INSERT_ROW);
        int absoluteCount = Math.abs(rowCount);
        int sign = rowCount / absoluteCount;
        for (int i = 0; i < absoluteCount; ++i) {
            this.insertRow(sign, baseRowNumber);
        }
        this.transEnd();
    }

    public void insertColumn(int columnNumber, int parentColumnNumber) throws SemanticException {
        int i;
        this.transStar(TRANS_LABEL_INSERT_COLUMN);
        if (!$assertionsDisabled && columnNumber == 0) {
            throw new AssertionError();
        }
        int realColumnNumber = columnNumber > 0 ? parentColumnNumber + columnNumber : parentColumnNumber + columnNumber + 1;
        int shiftPos = columnNumber > 0 ? columnNumber : columnNumber + 1;
        ColumnHandle column = (ColumnHandle)this.getColumn(parentColumnNumber);
        ColumnHandleAdapter adapt = HandleAdapterFactory.getInstance().getColumnHandleAdapter(column);
        ColumnHandle copy = (ColumnHandle)adapt.copy();
        int rowNumber = this.getRowCount();
        ArrayList<CellHandle> copyChildren = new ArrayList<CellHandle>();
        for (int i2 = 0; i2 < rowNumber; ++i2) {
            RowUIInfomation rowInfo = this.getRowInfo(this.getRow(i2 + 1));
            List rowList = rowInfo.getAllChildren();
            CellHandle parentCell = (CellHandle)rowList.get(parentColumnNumber - 1);
            CellHandle cell = this.getCellHandleCopy(parentCell);
            copyChildren.add(cell);
        }
        int copyRowSize = copyChildren.size();
        for (int i3 = 0; i3 < copyRowSize; ++i3) {
            RowHandle row = (RowHandle)this.getRow(i3 + 1);
            int number = this.getReallyRowNumber(row, realColumnNumber);
            row.getSlot(0).add((DesignElementHandle)((CellHandle)copyChildren.get(i3)), number - 1);
        }
        SlotHandle parentHandle = column.getContainerSlotHandle();
        parentHandle.add((DesignElementHandle)copy);
        int pos = parentHandle.findPosn((DesignElementHandle)column);
        parentHandle.shift((DesignElementHandle)copy, pos + shiftPos);
        ArrayList<Integer> temp = new ArrayList<Integer>();
        ArrayList hasAdjust = new ArrayList();
        for (i = 0; i < rowNumber; ++i) {
            RowUIInfomation rowInfo = this.getRowInfo(this.getRow(i + 1));
            List rowList = rowInfo.getAllChildren();
            Object fillCell = rowList.get(realColumnNumber - 1);
            CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(fillCell);
            if (cellAdapt.getColumnNumber() == realColumnNumber) continue;
            if (!hasAdjust.contains(fillCell)) {
                cellAdapt.setColumnSpan(cellAdapt.getColumnSpan() + 1);
                hasAdjust.add(fillCell);
            }
            temp.add(new Integer(i));
        }
        for (i = 0; i < copyRowSize; ++i) {
            if (!temp.contains(new Integer(i))) continue;
            ((CellHandle)copyChildren.get(i)).drop();
        }
        this.transEnd();
    }

    private int getReallyRowNumber(RowHandle rowHandle, int number) {
        RowUIInfomation rowInfo = this.getRowInfo(rowHandle);
        int rowNumber = HandleAdapterFactory.getInstance().getRowHandleAdapter(rowHandle).getRowNumber();
        List rowList = rowInfo.getAllChildren();
        int retValue = number;
        ArrayList hasAdjust = new ArrayList();
        for (int i = 0; i < number - 1; ++i) {
            Object fillCell = rowList.get(i);
            CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(fillCell);
            if (hasAdjust.contains(fillCell)) {
                --retValue;
                continue;
            }
            if (cellAdapt.getRowNumber() != rowNumber) {
                --retValue;
            }
            hasAdjust.add(fillCell);
        }
        return retValue;
    }

    public void insertColumns(int columnCount, int baseColumnNumber) throws SemanticException {
        this.transStar(TRANS_LABEL_INSERT_COLUMN);
        int absoluteCount = Math.abs(columnCount);
        int sign = columnCount / absoluteCount;
        for (int i = 0; i < absoluteCount; ++i) {
            this.insertColumn(sign, baseColumnNumber);
        }
        this.transEnd();
    }

    public void removeChild(Object model) throws SemanticException {
        if (!$assertionsDisabled && !(model instanceof DesignElementHandle)) {
            throw new AssertionError();
        }
        DesignElementHandle ele = (DesignElementHandle)model;
        ele.drop();
    }

    public void deleteColumn(int[] columns) throws SemanticException {
        int i;
        if (columns == null) {
            return;
        }
        this.transStar(TRANS_LABEL_DELETE_COLUMNS);
        if (this.getColumnCount() == columns.length) {
            this.getHandle().drop();
            this.transEnd();
            return;
        }
        Arrays.sort(columns);
        ArrayList<Object> temp = new ArrayList<Object>();
        int len = columns.length;
        for (i = 0; i < len; ++i) {
            temp.add(this.getColumn(columns[i]));
        }
        for (i = 0; i < len; ++i) {
            this.deleteColumn(HandleAdapterFactory.getInstance().getColumnHandleAdapter(temp.get(i)).getColumnNumber());
        }
        this.transEnd();
    }

    public void deleteColumn(int columnNumber) throws SemanticException {
        Object cell;
        int i;
        this.transStar(TRANS_LABEL_DELETE_COLUMN);
        int rowCount = this.getRowCount();
        ColumnHandle column = (ColumnHandle)this.getColumn(columnNumber);
        ArrayList deleteCells = new ArrayList();
        for (int i2 = 0; i2 < rowCount; ++i2) {
            Object row = this.getRow(i2 + 1);
            RowUIInfomation info = this.getRowInfo(row);
            deleteCells.add(info.getAllChildren().get(columnNumber - 1));
        }
        ArrayList trueDeleteCells = new ArrayList();
        int size = deleteCells.size();
        for (int i3 = 0; i3 < size; ++i3) {
            Object cell2 = deleteCells.get(i3);
            CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(cell2);
            if (cellAdapt.getColumnNumber() != columnNumber || cellAdapt.getColumnSpan() != 1 || trueDeleteCells.contains(cell2)) continue;
            trueDeleteCells.add(cell2);
        }
        ArrayList temp = new ArrayList();
        for (i = 0; i < size; ++i) {
            cell = deleteCells.get(i);
            if (trueDeleteCells.contains(cell) || temp.contains(cell)) continue;
            CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(cell);
            cellAdapt.setColumnSpan(cellAdapt.getColumnSpan() - 1);
            temp.add(cell);
        }
        size = trueDeleteCells.size();
        for (i = 0; i < size; ++i) {
            cell = (CellHandle)trueDeleteCells.get(i);
            cell.drop();
        }
        column.drop();
        this.transEnd();
        this.reload();
    }

    public void deleteRow(int[] rows) throws SemanticException {
        int i;
        if (rows == null) {
            return;
        }
        this.transStar(TRANS_LABEL_DELETE_ROWS);
        if (this.getRowCount() == rows.length) {
            this.getHandle().drop();
            this.transEnd();
            return;
        }
        Arrays.sort(rows);
        ArrayList<Object> temp = new ArrayList<Object>();
        int len = rows.length;
        for (i = 0; i < len; ++i) {
            temp.add(this.getRow(rows[i]));
        }
        for (i = len - 1; i >= 0; --i) {
            this.deleteRow(HandleAdapterFactory.getInstance().getRowHandleAdapter(temp.get(i)).getRowNumber());
        }
        this.transEnd();
    }

    public void deleteRow(int rowsNumber) throws SemanticException {
        this.transStar(TRANS_LABEL_DELETE_ROW);
        int rowCount = this.getRowCount();
        RowHandle row = (RowHandle)this.getRow(rowsNumber);
        RowHandleAdapter rowAdapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(row);
        ArrayList temp = new ArrayList();
        RowHandle nextRow = null;
        ArrayList<ShiftNexRowInfo> shiftCellInfo = new ArrayList<ShiftNexRowInfo>();
        if (rowsNumber + 1 <= rowCount) {
            List trueChildren = rowAdapt.getChildren();
            int cellSize = trueChildren.size();
            nextRow = (RowHandle)this.getRow(rowsNumber + 1);
            RowUIInfomation nextRowInfo = this.getRowInfo(nextRow);
            List nextRowChildren = nextRowInfo.getAllChildren();
            for (int i = 0; i < cellSize; ++i) {
                Object cellHandle = trueChildren.get(i);
                CellHandleAdapter adapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(cellHandle);
                if (adapt.getRowSpan() == 1) continue;
                int numberInfo = 0;
                int index = nextRowChildren.indexOf(cellHandle);
                for (int j = 0; j < index; ++j) {
                    Object nextRowCell = nextRowChildren.get(j);
                    CellHandleAdapter nextRowCellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(nextRowCell);
                    if (nextRowCellAdapt.getRowNumber() == rowsNumber + 1 && !temp.contains(nextRowCell)) {
                        ++numberInfo;
                    }
                    temp.add(nextRowCell);
                }
                shiftCellInfo.add(new ShiftNexRowInfo(numberInfo += shiftCellInfo.size(), cellHandle));
            }
        }
        RowUIInfomation info = this.getRowInfo(row);
        List cells = info.getAllChildren();
        temp.clear();
        int cellSize = cells.size();
        for (int j = 0; j < cellSize; ++j) {
            Object cellHandle = cells.get(j);
            CellHandleAdapter adapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(cellHandle);
            if (adapt.getRowNumber() == rowsNumber || temp.contains(cellHandle)) continue;
            adapt.setRowSpan(adapt.getRowSpan() - 1);
            temp.add(cellHandle);
        }
        for (int i = 0; i < shiftCellInfo.size(); ++i) {
            ShiftNexRowInfo shiftInfo = (ShiftNexRowInfo)shiftCellInfo.get(i);
            CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(shiftInfo.cell);
            cellAdapt.setRowSpan(cellAdapt.getRowSpan() - 1);
            SlotHandle slotHandle = row.getCells();
            slotHandle.move((DesignElementHandle)shiftInfo.cell, (DesignElementHandle)nextRow, 0, shiftInfo.index);
        }
        row.drop();
        this.transEnd();
        this.reload();
    }

    public boolean canMerge(List list) {
        if (!this.getModuleHandle().canEdit()) {
            return false;
        }
        if (!$assertionsDisabled && list == null) {
            throw new AssertionError();
        }
        int size = list.size();
        if (size <= 1) {
            return false;
        }
        RowUIInfomation rowInfo = this.getRowInfo(((CellHandle)list.get(0)).getContainer());
        if (rowInfo == null) {
            return false;
        }
        String first = rowInfo.getRowDisplayName();
        for (int i = 1; i < size; ++i) {
            CellHandle cell = (CellHandle)list.get(i);
            if (!cell.canDrop()) {
                return false;
            }
            RowUIInfomation info = this.getRowInfo(cell.getContainer());
            if (info == null) {
                return false;
            }
            String str = info.getRowDisplayName();
            if (first.equals(str)) continue;
            return false;
        }
        return true;
    }

    public void splitCell(Object model) throws ContentException, NameException, SemanticException {
        RowHandle rowHandle;
        this.transStar(TRANS_LABEL_SPLIT_CELLS);
        if (!$assertionsDisabled && !(model instanceof CellHandle)) {
            throw new AssertionError();
        }
        CellHandle cellHandle = (CellHandle)model;
        CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(cellHandle);
        int rowNumber = cellAdapt.getRowNumber();
        int rowSpan = cellAdapt.getRowSpan();
        int colSpan = cellAdapt.getColumnSpan();
        if (colSpan != 1) {
            int index = this.getIndexofParent(cellHandle);
            rowHandle = (RowHandle)cellHandle.getContainer();
            for (int i = 1; i < colSpan; ++i) {
                rowHandle.addElement((DesignElementHandle)this.getCellHandleCopy(cellHandle), 0, i + index);
            }
        }
        if (rowSpan != 1) {
            for (int i = rowNumber + 1; i < rowNumber + rowSpan; ++i) {
                rowHandle = (RowHandle)this.getRow(i);
                int index = this.getIndexofParent(cellHandle);
                for (int j = 0; j < colSpan; ++j) {
                    rowHandle.addElement((DesignElementHandle)this.getCellHandleCopy(cellHandle), 0, j + index);
                }
            }
        }
        cellAdapt.setRowSpan(1);
        cellAdapt.setColumnSpan(1);
        this.transEnd();
    }

    private int getIndexofParent(CellHandle cellHandle) {
        CellHandleAdapter cellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(cellHandle);
        RowUIInfomation info = this.getRowInfo(cellHandle.getContainer());
        List list = info.getAllChildren();
        int index = list.indexOf(cellHandle);
        ArrayList temp = new ArrayList();
        int number = 0;
        for (int j = 0; j < index; ++j) {
            CellHandleAdapter childCellAdapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(list.get(j));
            if (childCellAdapt.getRowNumber() == cellAdapt.getRowNumber() && !temp.contains(list.get(j))) {
                ++number;
            }
            temp.add(list.get(j));
        }
        return number;
    }

    public CellHandle getCellHandleCopy(CellHandle cellHandle) throws SemanticException {
        if (cellHandle == null) {
            return null;
        }
        CellHandle cell = cellHandle.getElementFactory().newCell();
        Iterator iter = cellHandle.getPropertyIterator();
        while (iter.hasNext()) {
            PropertyHandle handle = (PropertyHandle)iter.next();
            String key = handle.getDefn().getName();
            if (!handle.isLocal() || "colSpan".equals(key) || "rowSpan".equals(key)) continue;
            cellHandle.copyPropertyTo(key, (DesignElementHandle)cell);
        }
        return cell;
    }

    public TableGroupHandle insertGroup() throws ContentException, NameException {
        if (DEUtil.getDataSetList((DesignElementHandle)this.getTableHandle()).isEmpty()) {
            return null;
        }
        this.transStar(TRANS_LABEL_INSERT_GROUP);
        RowHandle header = this.getTableHandle().getElementFactory().newTableRow();
        RowHandle footer = this.getTableHandle().getElementFactory().newTableRow();
        this.addCell(header);
        this.addCell(footer);
        TableGroupHandle groupHandle = this.getTableHandle().getElementFactory().newTableGroup();
        groupHandle.getSlot(0).add((DesignElementHandle)header);
        groupHandle.getSlot(1).add((DesignElementHandle)footer);
        SlotHandle handle = this.getTableHandle().getGroups();
        handle.add((DesignElementHandle)groupHandle);
        this.transEnd();
        return groupHandle;
    }

    public void removeGroup(Object group) throws SemanticException {
        this.transStar(TRANS_LABEL_DELETE_GROUP);
        ((RowHandle)group).getContainer().drop();
        if (this.getRows().size() == 0) {
            this.getHandle().drop();
        }
        this.transEnd();
    }

    protected void addCell(RowHandle handle) throws ContentException, NameException {
        int count = this.getColumnCount();
        for (int i = 0; i < count; ++i) {
            CellHandle cell = handle.getElementFactory().newCell();
            handle.addElement((DesignElementHandle)cell, 0);
        }
    }

    public void insertRowInSlotHandle(int id) throws ContentException, NameException {
        this.transStar(TRANS_LABEL_INCLUDE + TableHandleAdapter.getOperationName(id));
        RowHandle rowHandle = this.getTableHandle().getElementFactory().newTableRow();
        this.addCell(rowHandle);
        this.getTableHandle().getSlot(id).add((DesignElementHandle)rowHandle);
        this.transEnd();
    }

    public void deleteRowInSlotHandle(int id) throws SemanticException {
        this.transStar(TRANS_LABEL_NOT_INCLUDE + TableHandleAdapter.getOperationName(id));
        int[] rows = new int[]{};
        Iterator itor = this.getTableHandle().getSlot(id).iterator();
        while (itor.hasNext()) {
            Object obj = itor.next();
            RowHandleAdapter adapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(obj);
            int lenegth = rows.length;
            int[] temp = new int[lenegth + 1];
            System.arraycopy(rows, 0, temp, 0, lenegth);
            temp[lenegth] = adapt.getRowNumber();
            rows = temp;
        }
        this.deleteRow(rows);
        this.transEnd();
    }

    protected static String getOperationName(int id) {
        switch (id) {
            case 0: {
                return NAME_HEADRER;
            }
            case 3: {
                return NAME_FOOTER;
            }
            case 2: {
                return NAME_DETAIL;
            }
        }
        return NAME_NULL;
    }

    public boolean hasSlotHandleRow(int id) {
        Iterator itor = this.getTableHandle().getSlot(id).iterator();
        return itor.hasNext();
    }

    static {
        $assertionsDisabled = !TableHandleAdapter.class.desiredAssertionStatus();
        TRANS_LABEL_INSERT_ROW = Messages.getString("TableHandleAdapter.transLabel.insertRow");
        NAME_DETAIL = Messages.getString("TableHandleAdapter.name.detail");
        NAME_FOOTER = Messages.getString("TableHandleAdapter.name.footer");
        NAME_HEADRER = Messages.getString("TableHandleAdapter.name.header");
        TRANS_LABEL_NOT_INCLUDE = Messages.getString("TableHandleAdapter.transLabel.notInclude");
        TRANS_LABEL_INCLUDE = Messages.getString("TableHandleAdapter.transLabel.include");
        TRANS_LABEL_INSERT_GROUP = Messages.getString("TableHandleAdapter.transLabel.insertGroup");
        TRANS_LABEL_SPLIT_CELLS = Messages.getString("TableHandleAdapter.transLabel.splitCells");
        TRANS_LABEL_DELETE_ROW = Messages.getString("TableHandleAdapter.transLabel.deleteRow");
        TRANS_LABEL_DELETE_ROWS = Messages.getString("TableHandleAdapter.transLabel.deleteRows");
        TRANS_LABEL_DELETE_COLUMN = Messages.getString("TableHandleAdapter.transLabel.deleteColumn");
        TRANS_LABEL_DELETE_COLUMNS = Messages.getString("TableHandleAdapter.transLabel.deleteColumns");
        TRANS_LABEL_INSERT_COLUMN = Messages.getString("TableHandleAdapter.transLabel.insertColumn");
        TRANS_LABEL_DELETE_GROUP = Messages.getString("TableHandleAdapter.transLable.deleteGroup");
    }

    static class RowUIInfomation {
        protected static final String GRID_ROW = "";
        private String type = "";
        private String rowDisplayName = "";
        Object[] cells = null;
        int[] infactAdd = new int[0];

        private RowUIInfomation(int columnMunber) {
            this.cells = new Object[columnMunber];
        }

        public String getRowDisplayName() {
            return this.rowDisplayName;
        }

        public void setRowDisplayName(String rowDisplayName) {
            this.rowDisplayName = rowDisplayName;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void addChildren(Object obj, int index) {
            int cellSize = this.cells.length;
            if (index >= cellSize) {
                return;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            if (this.cells[index] != null) {
                Object[] newArray = new Object[cellSize];
                for (int i = 0; i < cellSize; ++i) {
                    if (this.containIndex(i)) {
                        newArray[i] = this.cells[i];
                        continue;
                    }
                    if (this.cells[i] == null) continue;
                    list.add(this.cells[i]);
                }
                newArray[index] = obj;
                int listSize = list.size();
                block1: for (int i = 0; i < listSize; ++i) {
                    for (int j = 0; j < cellSize; ++j) {
                        if (newArray[j] != null) continue;
                        newArray[j] = list.get(i);
                        continue block1;
                    }
                }
                this.cells = newArray;
            } else {
                this.cells[index] = obj;
            }
            int lenegth = this.infactAdd.length;
            int[] temp = new int[lenegth + 1];
            System.arraycopy(this.infactAdd, 0, temp, 0, lenegth);
            temp[lenegth] = index;
            this.infactAdd = temp;
        }

        private boolean containIndex(int index) {
            int length = this.infactAdd.length;
            for (int i = 0; i < length; ++i) {
                if (this.infactAdd[i] != index) continue;
                return true;
            }
            return false;
        }

        public void addChildren(Collection c) {
            Iterator itor = c.iterator();
            int cellSize = this.cells.length;
            block0: while (itor.hasNext()) {
                Object obj = itor.next();
                for (int i = 0; i < cellSize; ++i) {
                    if (this.cells[i] != null) continue;
                    this.cells[i] = obj;
                    continue block0;
                }
            }
        }

        public List getAllChildren() {
            ArrayList<Object> retValue = new ArrayList<Object>();
            int cellSize = this.cells.length;
            for (int i = 0; i < cellSize; ++i) {
                retValue.add(this.cells[i]);
            }
            return retValue;
        }
    }

    class ShiftNexRowInfo {
        protected int index;
        protected Object cell;

        public ShiftNexRowInfo(int index, Object cell) {
            this.index = index;
            this.cell = cell;
        }
    }
}

