/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FormatNumberPattern;

public class FormatFixedNumPattern
extends FormatNumberPattern {
    private int decPlaces = 0;
    private boolean useSep = false;
    private boolean useBracket = false;

    public FormatFixedNumPattern(String category) {
        super(category);
        this.setType('F');
    }

    public String getPattern() {
        String pattern;
        String numStr = "###0";
        String decStr = "";
        String positivePatt = numStr;
        String negativePatt = null;
        if (this.useSep) {
            positivePatt = "#,##0";
        }
        if ((decStr = DEUtil.getDecmalStr(this.decPlaces)) != "") {
            positivePatt = positivePatt + "." + decStr;
        }
        if (this.useBracket) {
            negativePatt = "(" + positivePatt + ")";
        }
        if ((pattern = negativePatt != null ? positivePatt + ";" + negativePatt : positivePatt).equals(this.DEFAULT_FIXED_PATTERN)) {
            return this.getCategory();
        }
        return pattern;
    }

    public void setPattern(String patternStr) {
        String patt = this.valPattern(patternStr);
        this.useSep = patt.indexOf(",") != -1;
        boolean bl = this.useBracket = patt.indexOf("(") != -1 && patt.indexOf(")") != -1;
        if (patt.indexOf(".") != -1) {
            this.decPlaces = patt.lastIndexOf("0") - patt.lastIndexOf(".");
        }
    }

    protected String getDefaultPatt() {
        return this.DEFAULT_FIXED_PATTERN;
    }

    public int getDecPlaces() {
        return this.decPlaces;
    }

    public void setDecPlaces(int decPlaces) {
        this.decPlaces = decPlaces;
    }

    public boolean getUseSep() {
        return this.useSep;
    }

    public void setUseSep(boolean useSep) {
        this.useSep = useSep;
    }

    public boolean getUseBracket() {
        return this.useBracket;
    }

    public void setUseBracket(boolean useBracket) {
        this.useBracket = useBracket;
    }
}

