/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.impl.QueryExecutionHelper;
import org.eclipse.birt.report.data.adapter.impl.ResultMetaData;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;

public class DataSetMetaDataHelper {
    private DataEngine dataEngine;
    private IModelAdapter modelAdaptor;
    private ModuleHandle moduleHandle;
    private static final char RENAME_SEPARATOR = '_';
    private static String UNNAME_PREFIX;
    static final /* synthetic */ boolean $assertionsDisabled;

    DataSetMetaDataHelper(DataEngine dataEngine, IModelAdapter modelAdaptor, ModuleHandle moduleHandle) {
        this.dataEngine = dataEngine;
        this.modelAdaptor = modelAdaptor;
        this.moduleHandle = moduleHandle;
    }

    IResultMetaData getDataSetMetaData(DataSetHandle dataSetHandle, boolean useCache) throws BirtException {
        if (dataSetHandle == null) {
            throw new AdapterException("datasethandle.null.error");
        }
        if (useCache) {
            return this.getCachedMetaData(dataSetHandle.getCachedMetaDataHandle());
        }
        return this.getRealMetaData(dataSetHandle);
    }

    private IResultMetaData getCachedMetaData(CachedMetaDataHandle cmdHandle) throws BirtException {
        if (cmdHandle == null) {
            return null;
        }
        Iterator it = cmdHandle.getResultSet().iterator();
        ArrayList<ColumnDefinition> columnMeta = new ArrayList<ColumnDefinition>();
        while (it.hasNext()) {
            ResultSetColumnHandle rsColumn = (ResultSetColumnHandle)it.next();
            ColumnDefinition cd = this.modelAdaptor.ColumnAdaptor(rsColumn);
            columnMeta.add(cd);
        }
        return new ResultMetaData(columnMeta);
    }

    private IResultMetaData getRealMetaData(DataSetHandle dataSetHandle) throws BirtException {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(dataSetHandle.getQualifiedName());
        query.setMaxRows(1);
        IResultMetaData metaData = new QueryExecutionHelper(this.dataEngine, this.modelAdaptor, this.moduleHandle, false).executeQuery(query).getResultMetaData();
        if (this.needsUseResultHint(dataSetHandle, metaData)) {
            metaData = new QueryExecutionHelper(this.dataEngine, this.modelAdaptor, this.moduleHandle, true).executeQuery(query).getResultMetaData();
        }
        return metaData;
    }

    IResultMetaData refreshMetaData(DataSetHandle dataSetHandle) throws BirtException {
        IResultMetaData rsMeta = null;
        BirtException e = null;
        try {
            rsMeta = this.getDataSetMetaData(dataSetHandle, false);
        }
        catch (BirtException e1) {
            e = e1;
        }
        if (this.needsSetCachedMetaData(dataSetHandle, rsMeta)) {
            dataSetHandle.setCachedMetaData(StructureFactory.createCachedMetaData());
            if (rsMeta != null && rsMeta.getColumnCount() != 0) {
                for (int i = 1; i <= rsMeta.getColumnCount(); ++i) {
                    ResultSetColumn rsc = StructureFactory.createResultSetColumn();
                    rsc.setColumnName(this.getColumnName(rsMeta, i));
                    rsc.setDataType(DataSetMetaDataHelper.toModelDataType(rsMeta.getColumnType(i)));
                    rsc.setPosition(new Integer(i));
                    dataSetHandle.getCachedMetaDataHandle().getResultSet().addItem((IStructure)rsc);
                }
            }
        }
        if (e != null) {
            throw e;
        }
        return rsMeta;
    }

    private boolean needsSetCachedMetaData(DataSetHandle dataSetHandle, IResultMetaData rsMeta) throws BirtException {
        if (dataSetHandle.getCachedMetaDataHandle() == null || rsMeta == null || rsMeta.getColumnCount() == 0) {
            return true;
        }
        ArrayList list = new ArrayList();
        Iterator iter = dataSetHandle.getCachedMetaDataHandle().getResultSet().iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        if (list.size() != rsMeta.getColumnCount()) {
            return true;
        }
        for (int i = 1; i <= rsMeta.getColumnCount(); ++i) {
            ResultSetColumnHandle handle = (ResultSetColumnHandle)list.get(i - 1);
            if (handle.getColumnName() != null && handle.getColumnName().equals(this.getColumnName(rsMeta, i)) && handle.getDataType().equals(DataSetMetaDataHelper.toModelDataType(rsMeta.getColumnType(i)))) continue;
            return true;
        }
        return false;
    }

    private boolean needsUseResultHint(DataSetHandle dataSetHandle, IResultMetaData metaData) throws BirtException {
        int columnCount = 0;
        boolean hasResultSetHint = false;
        boolean hasColumnHint = dataSetHandle.getPropertyHandle("columnHints").iterator().hasNext();
        HashSet orgColumnNameSet = new HashSet();
        HashSet<String> uniqueColumnNameSet = new HashSet<String>();
        if (metaData != null) {
            columnCount = metaData.getColumnCount();
        }
        for (int i = 0; i < columnCount; ++i) {
            String columnName = metaData.getColumnName(i + 1);
            String uniqueColumnName = this.getUniqueName(orgColumnNameSet, uniqueColumnNameSet, columnName, i);
            uniqueColumnNameSet.add(uniqueColumnName);
            if (uniqueColumnName.equals(columnName)) continue;
            this.updateModelColumn(dataSetHandle, uniqueColumnName, i + 1);
            if (hasResultSetHint) continue;
            hasResultSetHint = true;
        }
        if (!hasResultSetHint) {
            hasResultSetHint = this.checkHandleType(dataSetHandle);
        }
        return hasResultSetHint || hasColumnHint;
    }

    private boolean checkHandleType(DataSetHandle dataSetHandle) {
        if (dataSetHandle instanceof ScriptDataSetHandle) {
            return true;
        }
        if (dataSetHandle instanceof JointDataSetHandle) {
            List dataSets = ((JointDataSetHandle)dataSetHandle).getDataSetNames();
            for (int i = 0; i < dataSets.size(); ++i) {
                DataSetHandle dsHandle = ((JointDataSetHandle)dataSetHandle).getModuleHandle().findDataSet(dataSets.get(i).toString());
                if (dsHandle != null && dsHandle instanceof ScriptDataSetHandle) {
                    return true;
                }
                if (!(dsHandle instanceof JointDataSetHandle) || !this.checkHandleType(dsHandle)) continue;
                return true;
            }
        }
        return false;
    }

    private String getUniqueName(HashSet orgColumnNameSet, HashSet newColumnNameSet, String columnName, int index) {
        String newColumnName;
        if (columnName == null || columnName.trim().length() == 0 || newColumnNameSet.contains(columnName)) {
            newColumnName = columnName == null || columnName.trim().length() == 0 ? UNNAME_PREFIX + '_' + String.valueOf(index + 1) : columnName + '_' + String.valueOf(index + 1);
            int i = 1;
            while (orgColumnNameSet.contains(newColumnName) || newColumnNameSet.contains(newColumnName)) {
                newColumnName = newColumnName + String.valueOf('_') + i;
                ++i;
            }
        } else {
            newColumnName = columnName;
        }
        return newColumnName;
    }

    private void updateModelColumn(DataSetHandle ds, String uniqueColumnName, int index) throws BirtException {
        PropertyHandle resultSetColumns = ds.getPropertyHandle("resultSetHints");
        if (resultSetColumns == null) {
            return;
        }
        Iterator iterator = resultSetColumns.iterator();
        boolean found = false;
        while (iterator.hasNext()) {
            ResultSetColumnHandle rsColumnHandle = (ResultSetColumnHandle)iterator.next();
            if (!$assertionsDisabled && rsColumnHandle.getPosition() == null) {
                throw new AssertionError();
            }
            if (rsColumnHandle.getPosition() != index) continue;
            if (rsColumnHandle.getColumnName() != null && !rsColumnHandle.getColumnName().equals(uniqueColumnName)) {
                rsColumnHandle.setColumnName(uniqueColumnName);
            }
            found = true;
            break;
        }
        if (!found) {
            this.addResultSetColumn(resultSetColumns, uniqueColumnName, index);
        }
    }

    private void addResultSetColumn(PropertyHandle resultSetColumnHandle, String uniqueColumnName, int index) throws BirtException {
        ResultSetColumn rsColumn = new ResultSetColumn();
        rsColumn.setColumnName(uniqueColumnName);
        rsColumn.setPosition(new Integer(index));
        resultSetColumnHandle.addItem((IStructure)rsColumn);
    }

    private String getColumnName(IResultMetaData rsMeta, int index) throws BirtException {
        return rsMeta.getColumnAlias(index) == null || rsMeta.getColumnAlias(index).trim().length() == 0 ? rsMeta.getColumnName(index) : rsMeta.getColumnAlias(index);
    }

    private static String toModelDataType(int modelDataType) {
        if (modelDataType == 2) {
            return "integer";
        }
        if (modelDataType == 5) {
            return "string";
        }
        if (modelDataType == 6) {
            return "date-time";
        }
        if (modelDataType == 4) {
            return "decimal";
        }
        if (modelDataType == 3) {
            return "float";
        }
        return "any";
    }

    static {
        $assertionsDisabled = !DataSetMetaDataHelper.class.desiredAssertionStatus();
        UNNAME_PREFIX = "UNNAMED";
    }
}

