/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;

class QueryExecutionHelper {
    private DataEngine dataEngine;
    private IModelAdapter modelAdaptor;
    private ModuleHandle moduleHandle;
    private boolean useResultHints;

    QueryExecutionHelper(DataEngine dataEngine, IModelAdapter modelAdaptor, ModuleHandle moduleHandle) {
        this(dataEngine, modelAdaptor, moduleHandle, true);
    }

    QueryExecutionHelper(DataEngine dataEngine, IModelAdapter modelAdaptor, ModuleHandle moduleHandle, boolean useResultHints) {
        this.dataEngine = dataEngine;
        this.modelAdaptor = modelAdaptor;
        this.moduleHandle = moduleHandle;
        this.useResultHints = useResultHints;
    }

    IQueryResults executeQuery(QueryDefinition queryDefn) throws BirtException {
        return this.executeQuery(queryDefn, null, null, null);
    }

    IQueryResults executeQuery(QueryDefinition queryDefn, Iterator paramBindingIt, Iterator filterIt, Iterator bindingIt) throws BirtException {
        this.defineDataSourceDataSet(queryDefn);
        this.populateQueryDefn(queryDefn, paramBindingIt, filterIt, bindingIt);
        return this.dataEngine.prepare((IQueryDefinition)queryDefn).execute(null);
    }

    private void defineDataSourceDataSet(QueryDefinition queryDefn) throws AdapterException, BirtException {
        String dataSetName = queryDefn.getDataSetName();
        List l = this.moduleHandle.getAllDataSets();
        DataSetHandle handle = null;
        for (int i = 0; i < l.size(); ++i) {
            if (((DataSetHandle)l.get(i)).getQualifiedName() == null || !((DataSetHandle)l.get(i)).getQualifiedName().equals(dataSetName)) continue;
            handle = (DataSetHandle)l.get(i);
        }
        this.defineDataSet(handle);
    }

    private void populateQueryDefn(QueryDefinition queryDefn, Iterator paramBindingIt, Iterator filterIt, Iterator bindingIt) {
        List filters;
        while (bindingIt != null && bindingIt.hasNext()) {
            ComputedColumn column = this.modelAdaptor.adaptComputedColumn((ComputedColumnHandle)bindingIt.next());
            ScriptExpression sxp = (ScriptExpression)column.getExpression();
            sxp.setDataType(column.getDataType());
            queryDefn.addResultSetExpression(column.getName(), (IBaseExpression)sxp);
        }
        List parameterBindings = this.convertParamterBindings(paramBindingIt);
        if (parameterBindings != null) {
            queryDefn.getInputParamBindings().addAll(parameterBindings);
        }
        if ((filters = this.convertFilters(filterIt)) != null) {
            queryDefn.getFilters().addAll(filters);
        }
    }

    private List convertFilters(Iterator filterIt) {
        if (filterIt == null) {
            return null;
        }
        ArrayList<FilterDefinition> filters = new ArrayList<FilterDefinition>();
        while (filterIt.hasNext()) {
            while (filterIt.hasNext()) {
                FilterDefinition filter = this.modelAdaptor.adaptFilter((FilterConditionHandle)filterIt.next());
                filters.add(filter);
            }
        }
        return filters;
    }

    private List convertParamterBindings(Iterator paramBindingIt) {
        if (paramBindingIt == null) {
            return null;
        }
        ArrayList<InputParameterBinding> parameterBindings = new ArrayList<InputParameterBinding>();
        while (paramBindingIt.hasNext()) {
            ParamBindingHandle paramBinding = (ParamBindingHandle)paramBindingIt.next();
            if (paramBinding.getExpression() == null) continue;
            ScriptExpression paramValueExpr = new ScriptExpression(paramBinding.getExpression());
            InputParameterBinding inputParamBinding = new InputParameterBinding(paramBinding.getParamName(), (IBaseExpression)paramValueExpr);
            parameterBindings.add(inputParamBinding);
        }
        return parameterBindings;
    }

    private void defineDataSet(DataSetHandle handle) throws AdapterException, BirtException {
        if (handle == null) {
            throw new AdapterException("datasethandle.null.error");
        }
        DataSourceHandle dataSourceHandle = handle.getDataSource();
        if (dataSourceHandle != null) {
            BaseDataSourceDesign dsourceDesign = this.modelAdaptor.adaptDataSource(dataSourceHandle);
            this.dataEngine.defineDataSource((IBaseDataSourceDesign)dsourceDesign);
        }
        if (handle instanceof JointDataSetHandle) {
            this.defineSourceDataSets((JointDataSetHandle)handle);
        }
        BaseDataSetDesign baseDS = this.modelAdaptor.adaptDataSet(handle);
        if (!this.useResultHints) {
            baseDS.getResultSetHints().clear();
        }
        this.dataEngine.defineDataSet((IBaseDataSetDesign)baseDS);
    }

    private void defineSourceDataSets(JointDataSetHandle jointDataSetHandle) throws BirtException {
        List dataSets = jointDataSetHandle.getDataSetNames();
        for (int i = 0; i < dataSets.size(); ++i) {
            DataSetHandle dsHandle = jointDataSetHandle.getModuleHandle().findDataSet(dataSets.get(i).toString());
            if (dsHandle == null) continue;
            this.defineDataSet(dsHandle);
        }
    }
}

