/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.activity;

import java.util.Stack;
import org.eclipse.birt.report.model.activity.ActivityRecord;
import org.eclipse.birt.report.model.activity.CompoundRecord;
import org.eclipse.birt.report.model.activity.FilterEventsCompoundRecord;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ElementDeletedEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferencableStructure;

public class NotificationRecordTask
extends RecordTask {
    private Module root = null;
    private NotificationEvent event = null;
    private boolean filtered = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NotificationRecordTask(DesignElement target, NotificationEvent event) {
        super(target);
        this.event = event;
        this.root = target.getRoot();
    }

    public NotificationRecordTask(DesignElement target, NotificationEvent event, Module rootElement) {
        super(target);
        this.event = event;
        this.root = rootElement;
    }

    public NotificationRecordTask(ReferencableStructure target, NotificationEvent event) {
        super(target);
        this.event = event;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public NotificationEvent getEvent() {
        return this.event;
    }

    protected final boolean holdNotification(Stack transStack) {
        CompoundRecord cr;
        return transStack != null && !transStack.isEmpty() && (cr = (CompoundRecord)transStack.peek()) instanceof FilterEventsCompoundRecord;
    }

    public void doTask(ActivityRecord record, Stack transStack) {
        if (this.holdNotification(transStack)) {
            return;
        }
        if (this.getTarget() instanceof DesignElement) {
            Module theRoot;
            DesignElement elementTarget = (DesignElement)this.getTarget();
            Module module = theRoot = this.root == null ? elementTarget.getRoot() : this.root;
            if (this.getTarget() instanceof Module || theRoot != null) {
                elementTarget.broadcast(this.event, theRoot);
            }
            if (this.event instanceof ElementDeletedEvent) {
                elementTarget.clearListeners();
            }
        } else if (this.getTarget() instanceof ReferencableStructure) {
            ((ReferencableStructure)this.getTarget()).broadcast(this.event);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    static {
        $assertionsDisabled = !NotificationRecordTask.class.desiredAssertionStatus();
    }
}

