/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.birt.report.model.core.DesignSession;

public class DefaultResourceLocator
implements IResourceLocator {
    public URL findResource(ModuleHandle moduleHandle, String fileName, int type) {
        if (fileName == null) {
            return null;
        }
        try {
            File f = new File(fileName);
            if (f.isAbsolute()) {
                return f.exists() && f.isFile() ? f.getCanonicalFile().toURL() : null;
            }
            try {
                URL objURI = new URL(fileName);
                String protocol = objURI.getProtocol();
                if ("file".equalsIgnoreCase(protocol)) {
                    f = new File(objURI.getPath());
                    if (f.isAbsolute()) {
                        return f.exists() && f.isFile() ? f.getCanonicalFile().toURL() : null;
                    }
                } else if ("jar".equalsIgnoreCase(protocol)) {
                    URLConnection jarConnection = objURI.openConnection();
                    try {
                        jarConnection.connect();
                        return objURI;
                    }
                    catch (IOException e1) {
                        return null;
                    }
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            moduleHandle.getModule().getSession();
            String resourcePath = DesignSession.getBirtResourcePath();
            if (resourcePath != null && (f = new File(resourcePath, fileName)).exists() && f.isFile()) {
                return f.getCanonicalFile().toURL();
            }
            if (moduleHandle == null) {
                return null;
            }
            URL systemId = moduleHandle.getModule().getSystemId();
            if (systemId == null) {
                return null;
            }
            if ("file".equalsIgnoreCase(systemId.getProtocol())) {
                return this.tryFileSearch(systemId, fileName);
            }
            if ("jar".equalsIgnoreCase(systemId.getProtocol())) {
                return this.tryJarSearch(systemId, fileName);
            }
            return new URL(systemId, URIUtil.convertFileNameToURLString(fileName));
        }
        catch (IOException e) {
            return null;
        }
    }

    private URL tryFileSearch(URL systemId, String fileName) throws MalformedURLException, IOException {
        File f = new File(systemId.getPath());
        f = f.isDirectory() ? new File(f.getPath(), fileName) : new File(f.getParent(), fileName);
        if (f.isFile() && f.exists()) {
            return f.getCanonicalFile().toURL();
        }
        return null;
    }

    private URL tryJarSearch(URL base, String fileName) {
        URL url = null;
        try {
            url = new URL(base, fileName);
            url.openConnection().connect();
        }
        catch (MalformedURLException e) {
        }
        catch (IOException e1) {
            return null;
        }
        return url;
    }
}

