/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.elements.CascadingParameterGroup;
import org.eclipse.birt.report.model.elements.ImageItem;
import org.eclipse.birt.report.model.elements.JointDataSet;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.elements.SimpleDataSet;
import org.eclipse.birt.report.model.elements.TextItem;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.StructureRefUtil;

public class DocumentUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void serialize(ReportDesignHandle designHandle, OutputStream out) throws IOException {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        if (designHandle == null) {
            return;
        }
        ReportDesign target = null;
        ReportDesign source = (ReportDesign)designHandle.getModule();
        target = DocumentUtil.localizeDesign(source);
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        target.setProperty("libraries", null);
        target.handle().serialize(out);
    }

    static ReportDesign localizeDesign(ReportDesign source) {
        if (source == null) {
            return null;
        }
        ReportDesign target = null;
        target = (ReportDesign)ModelUtil.getCopy(source);
        IElementDefn defn = target.getDefn();
        block4: for (int i = 0; i < defn.getSlotCount(); ++i) {
            switch (i) {
                case 0: 
                case 2: {
                    continue block4;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    DocumentUtil.resolveSlot(target, source, i);
                }
            }
        }
        return target;
    }

    static void resolveSlot(ReportDesign targetDesign, ReportDesign sourceDesign, int slot) {
        if (targetDesign == null || sourceDesign == null) {
            return;
        }
        ContentIterator iter = new ContentIterator(targetDesign, slot);
        while (iter.hasNext()) {
            DesignElement target = (DesignElement)iter.next();
            DesignElement source = sourceDesign.getElementByID(target.getID());
            if (source == null) continue;
            DocumentUtil.resolveElementReference(targetDesign, sourceDesign, target, source);
        }
    }

    static void resolveElementReference(ReportDesign targetDesign, ReportDesign sourceDesign, DesignElement target, DesignElement source) {
        if (targetDesign == null || target == null || source == null) {
            return;
        }
        if (!$assertionsDisabled && target.getDefn() != source.getDefn()) {
            throw new AssertionError();
        }
        if (source instanceof CascadingParameterGroup || source instanceof ScalarParameter) {
            DocumentUtil.resolveDataSet(targetDesign, sourceDesign, target, source);
        } else if (source instanceof SimpleDataSet) {
            DocumentUtil.resolveDataSource(targetDesign, sourceDesign, target, source);
        } else if (source instanceof JointDataSet) {
            DocumentUtil.resolveDataSet(targetDesign, sourceDesign, target, source);
        } else if (source instanceof MasterPage) {
            DocumentUtil.resolveStyle(targetDesign, target, source);
        } else if (source instanceof ReportItem) {
            if (source instanceof Label || source instanceof TextItem) {
                DocumentUtil.localizeExternalStringProperty(sourceDesign, target, source);
            }
            if (source instanceof ImageItem) {
                DocumentUtil.resolveImageItem(targetDesign, sourceDesign, target, source);
            }
            DocumentUtil.resolveDataSet(targetDesign, sourceDesign, target, source);
            DocumentUtil.resolveStyle(targetDesign, target, source);
        } else if (source instanceof StyledElement) {
            DocumentUtil.resolveStyle(targetDesign, target, source);
        }
    }

    static void localizeExternalStringProperty(ReportDesign sourceDesign, DesignElement target, DesignElement source) {
        if (!($assertionsDisabled || sourceDesign != null && target != null && source != null)) {
            throw new AssertionError();
        }
        if (sourceDesign.getProperty(sourceDesign.getRoot(), "includeResource") == null) {
            return;
        }
        if (source instanceof Label) {
            String resourcekey = source.getStringProperty(sourceDesign, "textID");
            if (resourcekey == null) {
                return;
            }
            String displayValue = sourceDesign.getMessage(resourcekey);
            target.setProperty("text", (Object)displayValue);
            target.setProperty("textID", null);
        } else if (source instanceof TextItem) {
            String resourcekey = source.getStringProperty(sourceDesign, "contentID");
            if (resourcekey == null) {
                return;
            }
            String displayValue = sourceDesign.getMessage(resourcekey);
            target.setProperty("content", (Object)displayValue);
            target.setProperty("contentID", null);
        }
    }

    static void resolveImageItem(ReportDesign targetDesign, ReportDesign sourceDesign, DesignElement target, DesignElement source) {
        if (!($assertionsDisabled || targetDesign != null && target != null && source != null)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(source instanceof ImageItem)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(target instanceof ImageItem)) {
            throw new AssertionError();
        }
        StructRefValue embeddedImage = (StructRefValue)source.getProperty((Module)sourceDesign, "imageName");
        if (embeddedImage == null || !embeddedImage.isResolved()) {
            return;
        }
        if (!DocumentUtil.isLocalImage(embeddedImage.getName(), sourceDesign)) {
            EmbeddedImage targetEmbeddedImage = (EmbeddedImage)embeddedImage.getTargetStructure().copy();
            targetDesign.rename(targetEmbeddedImage);
            ArrayList<EmbeddedImage> images = targetDesign.getListProperty(targetDesign.getRoot(), "images");
            if (images == null) {
                images = new ArrayList<EmbeddedImage>();
                targetDesign.setProperty("images", images);
            }
            images.add(targetEmbeddedImage);
            StructRefValue structRef = new StructRefValue(null, targetEmbeddedImage.getName());
            target.setProperty("imageName", (Object)structRef);
        }
    }

    private static boolean isLocalImage(String imageName, ReportDesign sourceDesign) {
        StructureDefn defn = (StructureDefn)MetaDataDictionary.getInstance().getStructure("EmbeddedImage");
        return StructureRefUtil.findNativeStructure(sourceDesign, defn, imageName) != null;
    }

    static void resolveDataSource(ReportDesign targetDesign, ReportDesign sourceDesign, DesignElement target, DesignElement source) {
        if (!($assertionsDisabled || targetDesign != null && target != null && source != null)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(target instanceof SimpleDataSet)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(source instanceof SimpleDataSet)) {
            throw new AssertionError();
        }
        Module sourceModule = source.getRoot();
        if (!$assertionsDisabled && sourceModule == null) {
            throw new AssertionError();
        }
        DesignElement dataSource = source.getReferenceProperty(sourceModule, "dataSource");
        if (dataSource != null && sourceDesign != dataSource.getRoot()) {
            DesignElement copied = ModelUtil.getCopy(dataSource);
            DocumentUtil.addElement(targetDesign, copied, 2);
            target.setProperty("dataSource", (Object)new ElementRefValue(null, copied));
            DocumentUtil.resolveElementReference(targetDesign, sourceDesign, copied, dataSource);
        }
    }

    static void resolveDataSet(ReportDesign targetDesign, ReportDesign sourceDesign, DesignElement target, DesignElement source) {
        if (!($assertionsDisabled || targetDesign != null && target != null && source != null)) {
            throw new AssertionError();
        }
        if (source instanceof JointDataSet) {
            Module sourceModule = source.getRoot();
            if (!$assertionsDisabled && sourceModule == null) {
                throw new AssertionError();
            }
            List dataSets = source.getListProperty(sourceModule, "dataSets");
            if (dataSets != null) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (int i = 0; i < dataSets.size(); ++i) {
                    ElementRefValue value = (ElementRefValue)dataSets.get(i);
                    if (value.isResolved() && value.getElement().getRoot() != sourceDesign) {
                        DesignElement copied = ModelUtil.getCopy(value.getElement());
                        DocumentUtil.addElement(targetDesign, copied, 3);
                        DocumentUtil.resolveElementReference(targetDesign, sourceDesign, copied, value.getElement());
                        values.add(new ElementRefValue(null, copied));
                        ((ReferenceableElement)copied).addClient(target, "dataSets");
                        continue;
                    }
                    values.add(value.copy());
                }
                target.setProperty("dataSets", values);
            }
        } else {
            String propName = null;
            if (source instanceof CascadingParameterGroup) {
                propName = "dataSet";
            } else if (source instanceof ScalarParameter) {
                propName = "dataSetName";
            } else if (source instanceof ReportItem) {
                propName = "dataSet";
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            Module sourceModule = source.getRoot();
            if (!$assertionsDisabled && sourceModule == null) {
                throw new AssertionError();
            }
            DesignElement dataSet = source.getReferenceProperty(sourceModule, propName);
            if (dataSet != null && dataSet.getRoot() != sourceDesign) {
                DesignElement copied = ModelUtil.getCopy(dataSet);
                DocumentUtil.addElement(targetDesign, copied, 3);
                target.setProperty(propName, (Object)new ElementRefValue(null, copied));
                DocumentUtil.resolveElementReference(targetDesign, sourceDesign, copied, dataSet);
            }
        }
    }

    static void resolveStyle(ReportDesign targetDesign, DesignElement target, DesignElement source) {
        String selector;
        if (!($assertionsDisabled || targetDesign != null && target != null && source != null)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(target instanceof StyledElement)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(source instanceof StyledElement)) {
            throw new AssertionError();
        }
        Module sourceModule = source.getRoot();
        if (!$assertionsDisabled && sourceModule == null) {
            throw new AssertionError();
        }
        DesignElement style = ((StyledElement)source).getStyle(sourceModule);
        if (style != null && style.getRoot() != sourceModule) {
            ((StyledElement)target).setStyle(null);
            DocumentUtil.localizeStyleProperties(target, style, targetDesign);
        }
        if ((selector = ((ElementDefn)target.getDefn()).getSelector()) != null && (style = sourceModule.resolveElement(selector, 0, null)) != null && style.getRoot() != sourceModule) {
            DocumentUtil.localizeStyleProperties(target, style, targetDesign);
        }
    }

    private static void localizeStyleProperties(DesignElement target, DesignElement style, Module targetDesign) {
        Module root = style.getRoot();
        if (!$assertionsDisabled && root == null) {
            throw new AssertionError();
        }
        IElementDefn defn = style.getDefn();
        Iterator iter = defn.getPropertyIterator();
        while (iter.hasNext()) {
            PropertyDefn prop = (PropertyDefn)iter.next();
            Object value = style.getLocalProperty(root, prop.getName());
            if (value == null || target.getPropertyDefn(prop.getName()) == null || target.getLocalProperty(targetDesign, (ElementPropertyDefn)prop) != null) continue;
            target.setProperty(prop.getName(), value);
        }
    }

    private static void addElement(ReportDesign root, DesignElement element, int slot) {
        if (!$assertionsDisabled && root == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError();
        }
        root.getSlot(slot).add(element);
        element.setContainer(root, slot);
        root.manageId(element, true);
        root.makeUniqueName(element);
        if (!$assertionsDisabled && StringUtil.isBlank(element.getName())) {
            throw new AssertionError();
        }
        int ns = ((ElementDefn)element.getDefn()).getNameSpaceID();
        root.getNameSpace(ns).insert(element);
    }

    static {
        $assertionsDisabled = !DocumentUtil.class.desiredAssertionStatus();
    }
}

