/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.validators.AbstractPropertyValidator;

public class StructureListValidator
extends AbstractPropertyValidator {
    public static final String NAME = "StructureListValidator";
    private static StructureListValidator instance;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static StructureListValidator getInstance() {
        return instance;
    }

    public List validateForAdding(DesignElementHandle element, IPropertyDefn propDefn, List list, IStructure toAdd) {
        return this.doCheckStructureList(element.getModule(), element.getElement(), propDefn, list, toAdd);
    }

    public List validate(Module module, DesignElement element, String propName) {
        ElementPropertyDefn propDefn = element.getPropertyDefn(propName);
        if (!($assertionsDisabled || propDefn.getTypeCode() == 16 && propDefn.isList())) {
            throw new AssertionError();
        }
        List list = (List)element.getLocalProperty(module, propDefn);
        return this.doCheckStructureList(module, element, propDefn, list, null);
    }

    private List doCheckStructureList(Module module, DesignElement element, IPropertyDefn propDefn, List list, IStructure toAdd) {
        boolean checkList = toAdd == null;
        ArrayList<PropertyValueException> errorList = new ArrayList<PropertyValueException>();
        if (list == null || list.size() == 0) {
            return errorList;
        }
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && propDefn.getTypeCode() != 16) {
            throw new AssertionError();
        }
        boolean checkID = propDefn.getStructDefn().getName().equals("PropertyBinding");
        if (!checkID) {
            String value;
            PropertyDefn uniqueMember = null;
            Iterator iter = propDefn.getStructDefn().propertiesIterator();
            while (iter.hasNext()) {
                PropertyDefn memberDefn = (PropertyDefn)iter.next();
                if (memberDefn.getTypeCode() != 13) continue;
                uniqueMember = memberDefn;
                break;
            }
            HashSet<String> values = new HashSet<String>();
            for (int i = 0; i < list.size(); ++i) {
                Structure struct = (Structure)list.get(i);
                if (checkList) {
                    errorList.addAll(struct.validate(module, element));
                }
                if (uniqueMember == null) continue;
                String value2 = (String)struct.getProperty(module, uniqueMember);
                if (values.contains(value2)) {
                    if (!checkList) continue;
                    errorList.add(new PropertyValueException(element, propDefn, (Object)value2, "Error.PropertyValueException.VALUE_EXISTS"));
                    continue;
                }
                values.add(value2);
            }
            if (uniqueMember != null && toAdd != null && values.contains(value = (String)toAdd.getProperty(module, uniqueMember))) {
                errorList.add(new PropertyValueException(element, propDefn.getName(), (Object)value, "Error.PropertyValueException.VALUE_EXISTS"));
            }
        } else {
            HashMap values = new HashMap();
            for (int i = 0; i < list.size(); ++i) {
                PropertyBinding struct = (PropertyBinding)list.get(i);
                if (checkList) {
                    errorList.addAll(struct.validate(module, element));
                }
                String name = struct.getName();
                BigDecimal id = struct.getID();
                ArrayList<String> names = (ArrayList<String>)values.get(id);
                if (names != null) {
                    if (names.contains(name)) {
                        if (!checkList) continue;
                        errorList.add(new PropertyValueException(element, propDefn, (Object)name, "Error.PropertyValueException.VALUE_EXISTS"));
                        continue;
                    }
                    names.add(name);
                    continue;
                }
                names = new ArrayList<String>();
                names.add(name);
                values.put(id, names);
            }
            if (toAdd != null) {
                if (!$assertionsDisabled && !(toAdd instanceof PropertyBinding)) {
                    throw new AssertionError();
                }
                String name = ((PropertyBinding)toAdd).getName();
                BigDecimal id = ((PropertyBinding)toAdd).getID();
                List names = (List)values.get(id);
                if (names != null && names.contains(name)) {
                    errorList.add(new PropertyValueException(element, propDefn, (Object)name, "Error.PropertyValueException.VALUE_EXISTS"));
                }
            }
        }
        return errorList;
    }

    public List validateForRenaming(DesignElementHandle element, IPropertyDefn propDefn, List list, IStructure toRenamed, IPropertyDefn memberDefn, String newName) {
        ArrayList<PropertyValueException> errorList = new ArrayList<PropertyValueException>();
        if (list == null || list.size() == 0) {
            return errorList;
        }
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && propDefn.getTypeCode() != 16) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && memberDefn == null) {
            throw new AssertionError();
        }
        Module module = element.getModule();
        for (int i = 0; i < list.size(); ++i) {
            Structure struct = (Structure)list.get(i);
            String value = (String)struct.getProperty(module, (PropertyDefn)memberDefn);
            if (!value.equals(newName) || struct == toRenamed) continue;
            errorList.add(new PropertyValueException(element.getElement(), propDefn, (Object)value, "Error.PropertyValueException.VALUE_EXISTS"));
            break;
        }
        return errorList;
    }

    static {
        $assertionsDisabled = !StructureListValidator.class.desiredAssertionStatus();
        instance = new StructureListValidator();
    }
}

