/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.report.model.api.extension.IResourceBundleProvider;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.extension.DefaultMessages;
import org.eclipse.birt.report.model.metadata.AddOnExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.Choice;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.ExtensionChoice;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionException;
import org.eclipse.birt.report.model.metadata.ExtensionLoader;
import org.eclipse.birt.report.model.metadata.ExtensionPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class AddOnExtensionLoader
extends ExtensionLoader {
    public static final String EXTENSION_POINT = "org.eclipse.birt.report.model.odaDriverModel";
    private static final String ODA_DATA_SOURCE_TAG = "odaDataSource";
    private static final String ODA_DATA_SET_TAG = "odaDataSet";
    static /* synthetic */ Class class$org$eclipse$birt$report$model$metadata$AddOnExtensionLoader;

    public AddOnExtensionLoader() {
        super(EXTENSION_POINT);
    }

    void loadExtension(IExtension extension) throws ExtensionException, MetaDataException {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        AddOnExtensionElementLoader dataSourceLoader = new AddOnExtensionElementLoader(extension, "OdaDataSource");
        AddOnExtensionElementLoader dataSetLoader = new AddOnExtensionElementLoader(extension, "OdaDataSet");
        for (int i = 0; i < configElements.length; ++i) {
            IConfigurationElement currentTag = configElements[i];
            if (ODA_DATA_SOURCE_TAG.equals(currentTag.getName())) {
                dataSourceLoader.loadElement(currentTag);
                continue;
            }
            if (!ODA_DATA_SET_TAG.equals(currentTag.getName())) continue;
            dataSetLoader.loadElement(currentTag);
        }
    }

    class AddOnExtensionElementLoader
    extends ExtensionLoader.ExtensionElementLoader {
        static final String RESOURCE_BUNDLE_PROVIDER_ATTRIB = "resourceBundleProvider";
        String baseElementName;
        DefaultMessages messages;
        static final /* synthetic */ boolean $assertionsDisabled;

        AddOnExtensionElementLoader(IExtension extension, String baseElementName) {
            super(AddOnExtensionLoader.this, extension);
            this.messages = null;
            this.baseElementName = baseElementName;
        }

        void loadElement(IConfigurationElement elementTag) throws MetaDataException, ExtensionException {
            String extensionName = elementTag.getAttribute("extensionName");
            String className = elementTag.getAttribute(RESOURCE_BUNDLE_PROVIDER_ATTRIB);
            this.checkRequiredAttribute("extensionName", extensionName);
            IElementDefn baseElementDefn = MetaDataDictionary.getInstance().getElement(this.baseElementName);
            if (!$assertionsDisabled && baseElementDefn == null) {
                throw new AssertionError();
            }
            if (!StringUtil.isBlank(className)) {
                try {
                    IResourceBundleProvider provider = (IResourceBundleProvider)elementTag.createExecutableExtension(RESOURCE_BUNDLE_PROVIDER_ATTRIB);
                    this.messages = new DefaultMessages(provider);
                }
                catch (FrameworkException e) {
                    throw new ExtensionException(new String[]{className}, "FAILED_TO_CREATE_INSTANCE");
                }
            }
            AddOnExtensionElementDefn elementDefn = new AddOnExtensionElementDefn(extensionName, baseElementDefn);
            ArrayList propList = new ArrayList();
            IConfigurationElement[] elements = elementTag.getChildren();
            for (int i = 0; i < elements.length; ++i) {
                if ("property".equalsIgnoreCase(elements[i].getName())) {
                    ExtensionPropertyDefn extPropDefn = this.loadProperty(elementTag, elements[i], elementDefn);
                    elementDefn.addProperty(extPropDefn);
                    continue;
                }
                if ("propertyVisibility".equalsIgnoreCase(elements[i].getName())) {
                    this.loadPropertyVisibility(elements[i], elementDefn);
                    continue;
                }
                if (!"propertyGroup".equalsIgnoreCase(elements[i].getName())) continue;
                this.loadPropertyGroup(elementTag, elements[i], elementDefn, propList);
            }
            elementDefn.extensionPoint = AddOnExtensionLoader.EXTENSION_POINT;
            MetaDataDictionary.getInstance().addExtension(elementDefn);
        }

        ExtensionPropertyDefn loadProperty(IConfigurationElement elementTag, IConfigurationElement propTag, ExtensionElementDefn elementDefn) throws ExtensionException {
            String name = propTag.getAttribute("name");
            String displayNameID = propTag.getAttribute("displayNameID");
            String type = propTag.getAttribute("type");
            String canInherit = propTag.getAttribute("canInherit");
            String defaultValue = propTag.getAttribute("defaultValue");
            String isEncrypted = propTag.getAttribute("isEncryptable");
            String defaultDisplayName = propTag.getAttribute("defaultDisplayName");
            this.checkRequiredAttribute("name", name);
            this.checkRequiredAttribute("type", type);
            PropertyType propType = MetaDataDictionary.getInstance().getPropertyType(type);
            if (propType == null) {
                throw new ExtensionException(new String[]{type}, "INVALID_PROPERTY_TYPE");
            }
            if (propType.getTypeCode() != 0 && propType.getTypeCode() != 5) {
                throw new ExtensionException(new String[]{type}, "INVALID_PROPERTY_TYPE");
            }
            ExtensionPropertyDefn extPropDefn = null;
            extPropDefn = new ExtensionPropertyDefn(this.messages);
            extPropDefn.setName(name);
            extPropDefn.setDisplayNameID(displayNameID);
            extPropDefn.setType(propType);
            try {
                Object value = extPropDefn.validateXml(null, defaultValue);
                extPropDefn.setDefault(value);
            }
            catch (PropertyValueException e) {
                throw new ExtensionException(new String[]{defaultValue}, "INVALID_DEFAULT_VALUE");
            }
            extPropDefn.setIntrinsic(false);
            extPropDefn.setStyleProperty(false);
            extPropDefn.setDefaultDisplayName(defaultDisplayName);
            if (!StringUtil.isBlank(canInherit)) {
                extPropDefn.setCanInherit(Boolean.valueOf(canInherit));
            }
            if (!StringUtil.isBlank(isEncrypted)) {
                extPropDefn.setIsEncryptable(Boolean.valueOf(isEncrypted));
            }
            ArrayList<ExtensionChoice> choiceList = new ArrayList<ExtensionChoice>();
            IConfigurationElement[] elements = propTag.getChildren();
            for (int k = 0; k < elements.length; ++k) {
                if (!"choice".equalsIgnoreCase(elements[k].getName())) continue;
                ExtensionChoice choiceDefn = new ExtensionChoice(null);
                this.loadChoice(elements[k], choiceDefn, extPropDefn);
                choiceList.add(choiceDefn);
            }
            if (choiceList.size() > 0) {
                IChoice[] choices = new Choice[choiceList.size()];
                choiceList.toArray(choices);
                ChoiceSet choiceSet = new ChoiceSet();
                choiceSet.setChoices(choices);
                extPropDefn.setDetails(choiceSet);
            }
            return extPropDefn;
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$report$model$metadata$AddOnExtensionLoader == null ? (class$org$eclipse$birt$report$model$metadata$AddOnExtensionLoader = AddOnExtensionLoader.class$("org.eclipse.birt.report.model.metadata.AddOnExtensionLoader")) : class$org$eclipse$birt$report$model$metadata$AddOnExtensionLoader).desiredAssertionStatus();
        }
    }
}

