/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.namespace.IModuleNameSpace;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;

public class ElementRefPropertyType
extends PropertyType {
    private static Logger logger;
    private static final String DISPLAY_NAME_KEY = "Property.element";
    static final /* synthetic */ boolean $assertionsDisabled;

    public ElementRefPropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    public int getTypeCode() {
        return 15;
    }

    public String getName() {
        return "element";
    }

    public Object validateValue(Module module, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        ElementDefn targetDefn = (ElementDefn)defn.getTargetElementType();
        if (value instanceof String) {
            logger.log(Level.FINE, "Validate the value of the element reference property as a string: " + value);
            return this.validateStringValue(module, targetDefn, defn, (String)value);
        }
        if (value instanceof DesignElement) {
            logger.log(Level.FINE, "Validate the value of the element reference property as a DesignElement " + ((DesignElement)value).getName());
            DesignElement target = (DesignElement)value;
            return this.validateElementValue(module, targetDefn, defn, target);
        }
        logger.log(Level.SEVERE, "Invalid value type: " + value);
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 15);
    }

    private ElementRefValue validateStringValue(Module module, ElementDefn targetDefn, PropertyDefn propDefn, String name) throws PropertyValueException {
        if ((name = StringUtil.trimString(name)) == null) {
            return null;
        }
        IModuleNameSpace elementResolver = module.getModuleNameSpace(targetDefn.getNameSpaceID());
        ElementRefValue refValue = null;
        refValue = elementResolver.resolve(name, propDefn);
        if (!$assertionsDisabled && refValue == null) {
            throw new AssertionError();
        }
        if (!refValue.isResolved()) {
            return refValue;
        }
        DesignElement target = refValue.getElement();
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        if (!targetDefn.isKindOf(target.getDefn())) {
            throw new PropertyValueException((Object)target.getName(), "Error.PropertyValueException.WRONG_ELEMENT_TYPE", 15);
        }
        return refValue;
    }

    private ElementRefValue validateElementValue(Module module, ElementDefn targetDefn, PropertyDefn propDefn, DesignElement target) throws PropertyValueException {
        IModuleNameSpace elementResolver = module.getModuleNameSpace(targetDefn.getNameSpaceID());
        ElementRefValue refValue = elementResolver.resolve(target, propDefn);
        if (!targetDefn.isKindOf(target.getDefn())) {
            throw new PropertyValueException((Object)target.getName(), "Error.PropertyValueException.WRONG_ELEMENT_TYPE", 15);
        }
        return refValue;
    }

    public String toString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        ElementRefValue refValue = (ElementRefValue)value;
        if (!"style".equals(defn.getName())) {
            return ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)value, module);
        }
        return refValue.getName();
    }

    public void resolve(Module module, PropertyDefn defn, ElementRefValue ref) {
        if (ref.isResolved()) {
            return;
        }
        ElementDefn targetDefn = (ElementDefn)defn.getTargetElementType();
        IModuleNameSpace elementResolver = module.getModuleNameSpace(targetDefn.getNameSpaceID());
        String name = ReferenceValueUtil.needTheNamespacePrefix(ref, module);
        DesignElement target = null;
        target = elementResolver.resolve(name, defn).getElement();
        if (target != null) {
            ref.resolve(target);
        }
    }

    static {
        $assertionsDisabled = !ElementRefPropertyType.class.desiredAssertionStatus();
        logger = Logger.getLogger(ElementRefPropertyType.class.getName());
    }
}

