/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.metadata.ExtensionChoice;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionException;
import org.eclipse.birt.report.model.metadata.ExtensionPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;
import org.eclipse.birt.report.model.metadata.MetaLogManager;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public abstract class ExtensionLoader {
    private static Logger logger = Logger.getLogger(ExtensionLoader.class.getName());
    private String extensionPointer = null;

    ExtensionLoader(String extensionPointer) {
        this.extensionPointer = extensionPointer;
    }

    abstract void loadExtension(IExtension var1) throws ExtensionException, MetaDataException;

    public void load() throws MetaDataParserException {
        try {
            this.doLoad();
        }
        catch (ExtensionException e) {
            this.logExtenstionException(e);
            throw new MetaDataParserException((Exception)((Object)e), "EXTENSION_ERROR");
        }
        catch (MetaDataException e) {
            logger.log(Level.SEVERE, e.getMessage());
            MetaLogManager.log("Extension loading error", (Throwable)((Object)e));
            throw new MetaDataParserException((Exception)((Object)e), "EXTENSION_ERROR");
        }
    }

    protected void logExtenstionException(ExtensionException e) {
        logger.log(Level.SEVERE, e.getMessage());
        MetaLogManager.log("Extension loading error", (Throwable)((Object)e));
    }

    void doLoad() throws ExtensionException, MetaDataException {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        if (pluginRegistry == null) {
            throw new ExtensionException(new String[]{this.extensionPointer}, "EXTENSION_POINT_NOT_FOUND");
        }
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(this.extensionPointer);
        if (extensionPoint == null) {
            throw new ExtensionException(new String[]{this.extensionPointer}, "EXTENSION_POINT_NOT_FOUND");
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions != null) {
            for (int i = 0; i < extensions.length; ++i) {
                this.loadExtension(extensions[i]);
            }
        }
    }

    abstract class ExtensionElementLoader {
        static final String PROPERTY_TAG = "property";
        static final String CHOICE_TAG = "choice";
        static final String PROPERTY_GROUP_TAG = "propertyGroup";
        static final String PROPERTY_VISIBILITY_TAG = "propertyVisibility";
        static final String EXTENSION_NAME_ATTRIB = "extensionName";
        static final String NAME_ATTRIB = "name";
        static final String DISPLAY_NAME_ID_ATTRIB = "displayNameID";
        static final String TYPE_ATTRIB = "type";
        static final String CAN_INHERIT_ATTRIB = "canInherit";
        static final String DETAIL_TYPE_ATTRIB = "detailType";
        static final String DEFAULT_VALUE_ATTRIB = "defaultValue";
        static final String VALUE_ATTRIB = "value";
        static final String VISIBILITY_ATTRIB = "visibility";
        static final String DEFAULT_DISPLAY_NAME_ATTRIB = "defaultDisplayName";
        static final String IS_ENCRYPTABLE_ATTRIB = "isEncryptable";
        IExtension extension;

        ExtensionElementLoader(IExtension extension) {
            this.extension = extension;
        }

        abstract void loadElement(IConfigurationElement var1) throws MetaDataException, ExtensionException;

        abstract ExtensionPropertyDefn loadProperty(IConfigurationElement var1, IConfigurationElement var2, ExtensionElementDefn var3) throws ExtensionException;

        void checkRequiredAttribute(String name, String value) throws ExtensionException {
            if (StringUtil.isBlank(value)) {
                throw new ExtensionException(new String[]{name}, "VALUE_REQUIRED");
            }
        }

        void loadChoice(IConfigurationElement choiceTag, ExtensionChoice choice, PropertyDefn propDefn) throws ExtensionException {
            String name = choiceTag.getAttribute(NAME_ATTRIB);
            String value = choiceTag.getAttribute(VALUE_ATTRIB);
            String displayNameID = choiceTag.getAttribute(DISPLAY_NAME_ID_ATTRIB);
            String defaultDisplayName = choiceTag.getAttribute(DEFAULT_DISPLAY_NAME_ATTRIB);
            this.checkRequiredAttribute(NAME_ATTRIB, name);
            choice.setName(name);
            if (propDefn.getTypeCode() != 5) {
                try {
                    Object validateValue = propDefn.validateXml(null, value);
                    choice.setValue(validateValue);
                }
                catch (PropertyValueException e) {
                    throw new ExtensionException(new String[]{value, propDefn.getName()}, "INVALID_CHOICE_VALUE");
                }
            } else {
                choice.setValue(value);
            }
            choice.setDisplayNameKey(displayNameID);
            choice.setDefaultDisplayName(defaultDisplayName);
        }

        void loadPropertyVisibility(IConfigurationElement propTag, ExtensionElementDefn elementDefn) throws ExtensionException {
            String name = propTag.getAttribute(NAME_ATTRIB);
            String visible = propTag.getAttribute(VISIBILITY_ATTRIB);
            this.checkRequiredAttribute(NAME_ATTRIB, name);
            elementDefn.addPropertyVisibility(name, visible);
        }

        void loadPropertyGroup(IConfigurationElement elementTag, IConfigurationElement propGroupTag, ExtensionElementDefn elementDefn, List propList) throws MetaDataException {
            String displayNameID = propGroupTag.getAttribute(DISPLAY_NAME_ID_ATTRIB);
            String groupName = propGroupTag.getAttribute(NAME_ATTRIB);
            String defaultDisplayName = propGroupTag.getAttribute(DEFAULT_DISPLAY_NAME_ATTRIB);
            this.checkRequiredAttribute(NAME_ATTRIB, groupName);
            IConfigurationElement[] elements = propGroupTag.getChildren();
            for (int i = 0; i < elements.length; ++i) {
                if (!PROPERTY_TAG.equalsIgnoreCase(elements[i].getName())) continue;
                ExtensionPropertyDefn extPropDefn = this.loadProperty(elementTag, elements[i], elementDefn);
                extPropDefn.setGroupName(groupName);
                extPropDefn.setGroupNameKey(displayNameID);
                extPropDefn.setGroupDefauleDisplayName(defaultDisplayName);
                elementDefn.addProperty(extPropDefn);
            }
        }
    }
}

