/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import org.eclipse.birt.report.model.api.metadata.IMetaLogger;
import org.eclipse.birt.report.model.metadata.FileMetaLogger;

public final class MetaLogManager {
    private static ArrayList loggers = new ArrayList();

    public static void registerLogger(IMetaLogger logger) {
        if (logger == null) {
            return;
        }
        loggers.add(logger);
    }

    public static boolean removeLogger(IMetaLogger logger) {
        boolean exist = loggers.remove(logger);
        if (exist && logger != null) {
            logger.close();
        }
        return exist;
    }

    public static void log(String message, Throwable t) {
        for (int i = 0; i < loggers.size(); ++i) {
            ((IMetaLogger)loggers.get(i)).log(message, t);
        }
    }

    static void log(String message) {
        for (int i = 0; i < loggers.size(); ++i) {
            ((IMetaLogger)loggers.get(i)).log(message);
        }
    }

    public static void shutDown() {
        for (int i = 0; i < loggers.size(); ++i) {
            ((IMetaLogger)loggers.get(i)).close();
        }
        loggers.clear();
    }

    static {
        MetaLogManager.registerLogger(new FileMetaLogger());
    }
}

