/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.ISlotDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefnSet;
import org.eclipse.birt.report.model.validators.ISemanticTriggerDefnSetProvider;

public class SlotDefn
implements ISlotDefn,
ISemanticTriggerDefnSetProvider {
    private int slotID = 0;
    private boolean multipleCardinality = true;
    private String name = null;
    private String displayNameID = null;
    private ArrayList contentElements = new ArrayList();
    private ArrayList contentTypes = new ArrayList();
    private String selector = null;
    private SemanticTriggerDefnSet triggers = null;
    private String since;
    private String xmlName;
    private boolean isManagedByNameSpace = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean isMultipleCardinality() {
        return this.multipleCardinality;
    }

    void setMultipleCardinality(boolean flag) {
        this.multipleCardinality = flag;
    }

    public String getDisplayName() {
        if (!$assertionsDisabled && this.displayNameID == null) {
            throw new AssertionError();
        }
        return ModelMessages.getMessage(this.displayNameID);
    }

    public String getDisplayNameID() {
        return this.displayNameID;
    }

    void setDisplayNameID(String msgID) {
        this.displayNameID = msgID;
    }

    public int getSlotID() {
        return this.slotID;
    }

    void setSlotID(int id) {
        this.slotID = id;
    }

    public List getContentElements() {
        return new ArrayList(this.contentElements);
    }

    public List getContentExtendedElements() {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        IElementDefn extendItem = dd.getElement("ExtendedItem");
        ArrayList<ExtensionElementDefn> contentsWithExtensions = new ArrayList<ExtensionElementDefn>();
        contentsWithExtensions.addAll(this.contentElements);
        if (this.contentElements.contains(extendItem)) {
            contentsWithExtensions.remove(extendItem);
            for (int i = 0; i < dd.getExtensions().size(); ++i) {
                ExtensionElementDefn extension = (ExtensionElementDefn)dd.getExtensions().get(i);
                if (!"org.eclipse.birt.report.model.reportItemModel".equals(extension.extensionPoint)) continue;
                contentsWithExtensions.add(extension);
            }
        }
        return contentsWithExtensions;
    }

    protected void build() throws MetaDataException {
        if (this.contentTypes.isEmpty()) {
            throw new MetaDataException(new String[]{this.name}, "MISSING_SLOT_TYPE");
        }
        if (this.displayNameID == null) {
            throw new MetaDataException(new String[]{this.name}, "MISSING_SLOT_NAME");
        }
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        this.contentElements.clear();
        Iterator iter = this.contentTypes.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            ElementDefn type = (ElementDefn)dd.getElement(name);
            if (type == null) {
                throw new MetaDataException(new String[]{this.name, name}, "INVALID_SLOT_TYPE");
            }
            this.contentElements.add(type);
        }
        this.getTriggerDefnSet().build();
    }

    public boolean canContain(IElementDefn type) {
        Iterator iter = this.contentElements.iterator();
        while (iter.hasNext()) {
            ElementDefn element = (ElementDefn)iter.next();
            if (!element.isKindOf(type)) continue;
            return true;
        }
        return false;
    }

    public boolean canContain(DesignElement content) {
        return this.canContain(content.getDefn());
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    void addType(String type) {
        this.contentTypes.add(type);
    }

    public String getDefaultStyle() {
        return null;
    }

    void setSelector(String value) {
        this.selector = value;
    }

    public String getSelector() {
        return this.selector;
    }

    public SemanticTriggerDefnSet getTriggerDefnSet() {
        if (this.triggers == null) {
            this.triggers = new SemanticTriggerDefnSet();
        }
        return this.triggers;
    }

    public void setSince(String value) {
        this.since = value;
    }

    public String getSince() {
        return this.since;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public void setXmlName(String value) {
        this.xmlName = value;
    }

    public String toString() {
        if (!StringUtil.isBlank(this.getName())) {
            return this.getName();
        }
        return super.toString();
    }

    public boolean isManagedByNameSpace() {
        return this.isManagedByNameSpace;
    }

    public void setManagedByNameSpace(boolean isManagedByNameSpace) {
        this.isManagedByNameSpace = isManagedByNameSpace;
    }

    static {
        $assertionsDisabled = !SlotDefn.class.desiredAssertionStatus();
    }
}

