/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.parser.AbstractPropertyState;
import org.eclipse.birt.report.model.parser.CompatibleBoundColumnState;
import org.eclipse.birt.report.model.parser.CompatibleGroupBoundColumnsState;
import org.eclipse.birt.report.model.parser.CompatibleOdaDriverPropertyStructureListState;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.EmbeddedImagePropertyListState;
import org.eclipse.birt.report.model.parser.ExtendedPropertyState;
import org.eclipse.birt.report.model.parser.IncludedLibrariesStructureListState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.RecoverableError;
import org.eclipse.birt.report.model.parser.SimpleStructureListState;
import org.eclipse.birt.report.model.parser.StructureState;
import org.eclipse.birt.report.model.parser.UserPropertyListState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.AnyElementState;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ListPropertyState
extends AbstractPropertyState {
    ArrayList list = new ArrayList();
    PropertyDefn propDefn = null;

    ListPropertyState(ModuleParserHandler theHandler, DesignElement element) {
        super(theHandler, element);
    }

    ListPropertyState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn, IStructure struct) {
        super(theHandler, element);
        this.propDefn = propDefn;
        this.struct = struct;
    }

    protected void setName(String name) {
        super.setName(name);
        this.propDefn = this.struct != null ? (PropertyDefn)this.struct.getDefn().getMember(name) : this.element.getPropertyDefn(name);
    }

    public void parseAttrs(Attributes attrs) throws XMLParserException {
        super.parseAttrs(attrs);
        if (StringUtil.isBlank(this.name)) {
            return;
        }
        if (this.struct instanceof Action) {
            if ("drillThroughParamBindings".equals(this.name)) {
                this.name = "paramBindings";
            } else if ("drillThroughSearch".equals(this.name)) {
                this.name = "search";
            }
        }
        this.propDefn = this.struct != null ? (PropertyDefn)this.struct.getDefn().getMember(this.name) : this.element.getPropertyDefn(this.name);
        if (!"userProperties".equals(this.name)) {
            if (this.propDefn == null) {
                if ("publicDriverProperties".equals(this.name)) {
                    return;
                }
                if (this.element instanceof Module && "includeLibraries".equalsIgnoreCase(this.name)) {
                    return;
                }
                DesignParserException e = new DesignParserException(new String[]{this.name}, "Error.DesignParserException.UNDEFINED_PROPERTY");
                RecoverableError.dealUndefinedProperty(this.handler, e);
                this.valid = false;
            } else if (16 != this.propDefn.getTypeCode()) {
                DesignParserException e = new DesignParserException("Error.DesignParserException.WRONG_STRUCTURE_LIST_TYPE");
                this.handler.getErrorHandler().semanticError((Exception)((Object)e));
                this.valid = false;
            }
        }
    }

    public AbstractParseState startElement(String tagName) {
        if (tagName.equalsIgnoreCase("structure")) {
            return new StructureState(this.handler, this.element, this.propDefn, this.list);
        }
        if (tagName.equalsIgnoreCase("ex-property")) {
            return new ExtendedPropertyState(this.handler, this.element, this.propDefn, this.list);
        }
        return super.startElement(tagName);
    }

    public void end() throws SAXException {
        if (this.struct != null) {
            PropertyDefn memberDefn = (PropertyDefn)this.struct.getDefn().getMember(this.name);
            this.struct.setProperty(memberDefn, this.list);
        } else {
            this.element.setProperty(this.name, (Object)this.list);
        }
    }

    public AbstractParseState jumpTo() {
        if (StringUtil.compareVersion(this.handler.getVersion(), "3") > 0 && StringUtil.compareVersion(this.handler.getVersion(), "3.2.1") <= 0 && "boundDataColumns".equals(this.name) && this.element instanceof GroupElement) {
            CompatibleGroupBoundColumnsState state = new CompatibleGroupBoundColumnsState(this.handler, this.element.getContainer(), (GroupElement)this.element);
            state.setName(this.name);
            return state;
        }
        if (!this.valid) {
            return new AnyElementState(this.getHandler());
        }
        if ("userProperties".equalsIgnoreCase(this.name)) {
            UserPropertyListState state = new UserPropertyListState(this.handler, this.element);
            ((AbstractPropertyState)state).setName(this.name);
            return state;
        }
        if (this.element instanceof Module) {
            if ("images".equalsIgnoreCase(this.name)) {
                EmbeddedImagePropertyListState state = new EmbeddedImagePropertyListState(this.handler, this.element);
                ((AbstractPropertyState)state).setName(this.name);
                return state;
            }
            if ("includeScripts".equalsIgnoreCase(this.name)) {
                SimpleStructureListState state = new SimpleStructureListState(this.handler, this.element);
                state.setName(this.name);
                state.setMemberName("fileName");
                return state;
            }
            if ("libraries".equalsIgnoreCase(this.name) || "includeLibraries".equals(this.name)) {
                IncludedLibrariesStructureListState state = new IncludedLibrariesStructureListState(this.handler, this.element);
                ((AbstractPropertyState)state).setName("libraries");
                return state;
            }
        }
        if (this.element instanceof OdaDataSource && ("privateDriverProperties".equalsIgnoreCase(this.name) || "publicDriverProperties".equalsIgnoreCase(this.name)) && this.handler.isVersion("0")) {
            CompatibleOdaDriverPropertyStructureListState state = new CompatibleOdaDriverPropertyStructureListState(this.handler, this.element);
            state.setName(this.name);
            return state;
        }
        if (StringUtil.compareVersion(this.handler.getVersion(), "3.2.0") < 0 && ("boundDataColumns".equalsIgnoreCase(this.name) || "boundDataColumns".equalsIgnoreCase(this.name) || "boundDataColumns".equalsIgnoreCase(this.name))) {
            CompatibleBoundColumnState state = new CompatibleBoundColumnState(this.handler, this.element);
            state.setName(this.name);
            return state;
        }
        return super.jumpTo();
    }
}

