/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;

public class LevelContentIterator
implements Iterator {
    protected static final int MAX_LEVEL = Integer.MAX_VALUE;
    List elementContents = null;
    protected int posn = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LevelContentIterator(DesignElement element, int level) {
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError();
        }
        this.elementContents = new ArrayList();
        this.buildContentsList(element, level);
    }

    public LevelContentIterator(DesignElement element, int slotId, int level) {
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError();
        }
        this.elementContents = new ArrayList();
        this.buildContentsList(element, slotId, level);
    }

    private void buildContentsList(DesignElement element, int level) {
        if (level < 0) {
            return;
        }
        for (int i = 0; i < element.getDefn().getSlotCount(); ++i) {
            this.buildContentsList(element, i, level);
        }
    }

    private void buildContentsList(DesignElement element, int slotId, int level) {
        if (level <= 0) {
            return;
        }
        ContainerSlot slot = element.getSlot(slotId);
        if (!$assertionsDisabled && slot == null) {
            throw new AssertionError();
        }
        Iterator iter = slot.getContents().iterator();
        while (iter.hasNext()) {
            DesignElement e = (DesignElement)iter.next();
            this.elementContents.add(e);
            this.buildContentsList(e, level - 1);
        }
    }

    public void remove() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public boolean hasNext() {
        return this.posn < this.elementContents.size();
    }

    public Object next() {
        return this.elementContents.get(this.posn++);
    }

    static {
        $assertionsDisabled = !LevelContentIterator.class.desiredAssertionStatus();
    }
}

