/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.report.model.activity.LayoutRecordTask;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.LibraryException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.util.ElementExportUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.UnicodeUtil;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.interfaces.IExtendedItemModel;
import org.eclipse.birt.report.model.elements.interfaces.IOdaExtendableElementModel;
import org.eclipse.birt.report.model.extension.IExtendableElement;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.EventFilter;
import org.eclipse.birt.report.model.util.VersionInfo;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.SAXException;

public class ModelUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Map getIdMap(DesignElement element) {
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError();
        }
        DesignElement parent = element.getExtendsElement();
        if (parent == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Long, DesignElement> idMap = new HashMap<Long, DesignElement>();
        ContentIterator parentIter = new ContentIterator(parent);
        ContentIterator childIter = new ContentIterator(element);
        while (childIter.hasNext()) {
            DesignElement virtualParent = (DesignElement)parentIter.next();
            DesignElement virtualChild = (DesignElement)childIter.next();
            if (!$assertionsDisabled && virtualChild.getDefn().getName() != virtualChild.getDefn().getName()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && virtualParent.getID() <= 0L) {
                throw new AssertionError();
            }
            idMap.put(new Long(virtualParent.getID()), virtualChild);
        }
        return idMap;
    }

    public static void localizeElement(DesignElement element) {
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError();
        }
        DesignElement parent = element.getExtendsElement();
        if (parent == null) {
            return;
        }
        ModelUtil.duplicateProperties(parent, element);
        ContentIterator iter1 = new ContentIterator(parent);
        ContentIterator iter2 = new ContentIterator(element);
        while (iter1.hasNext()) {
            DesignElement virtualParent = (DesignElement)iter1.next();
            DesignElement virtualChild = (DesignElement)iter2.next();
            ModelUtil.duplicateProperties(virtualParent, virtualChild);
        }
    }

    private static void duplicateProperties(DesignElement from, DesignElement to) {
        Iterator iter;
        if (from.getDefn().allowsUserProperties()) {
            iter = from.getUserProperties().iterator();
            while (iter.hasNext()) {
                UserPropertyDefn userPropDefn = (UserPropertyDefn)iter.next();
                to.addUserPropertyDefn(userPropDefn);
            }
        }
        iter = from.getDefn().getProperties().iterator();
        while (iter.hasNext()) {
            ElementPropertyDefn propDefn = (ElementPropertyDefn)iter.next();
            String propName = propDefn.getName();
            if ("style".equals(propName) || "extends".equals(propName) || "userProperties".equals(propName) || "refTemplateParameter".equals(propName)) continue;
            Object localValue = to.getLocalProperty(from.getRoot(), propDefn);
            Object parentValue = from.getStrategy().getPropertyFromElement(from.getRoot(), from, propDefn);
            if (localValue != null || parentValue == null) continue;
            Object valueToSet = ModelUtil.copyValue(propDefn, parentValue);
            to.setProperty(propDefn, valueToSet);
        }
    }

    public static void duplicateProperties(DesignElementHandle source, DesignElementHandle destination, boolean onlyFactoryProperty) {
        if (!$assertionsDisabled && source == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && destination == null) {
            throw new AssertionError();
        }
        if (!(source instanceof ReportDesignHandle && destination instanceof LibraryHandle || $assertionsDisabled || destination.getDefn().getName().equalsIgnoreCase(source.getDefn().getName()))) {
            throw new AssertionError();
        }
        if (source.getDefn().allowsUserProperties()) {
            PropertyHandle propHandle = source.getPropertyHandle("userProperties");
            List value = source.getElement().getUserProperties();
            Object valueToSet = null;
            if (propHandle != null) {
                valueToSet = ModelUtil.copyValue(propHandle.getDefn(), value);
            }
            if (valueToSet != null) {
                Iterator iter = ((List)valueToSet).iterator();
                while (iter.hasNext()) {
                    UserPropertyDefn userPropDefn = (UserPropertyDefn)iter.next();
                    destination.getElement().addUserPropertyDefn(userPropDefn);
                }
            }
        }
        if (source.getElement() instanceof IExtendableElement) {
            ModelUtil.duplicateExtensionIdentifier(source, destination);
        }
        Iterator iter = source.getPropertyIterator();
        while (iter.hasNext()) {
            ElementPropertyDefn propDefn;
            PropertyHandle propHandle = (PropertyHandle)iter.next();
            String propName = propHandle.getDefn().getName();
            if ("style".equals(propName) || "extends".equals(propName) || "userProperties".equals(propName) || "extensionID".equals(propName) || "extensionName".equals(propName) || "refTemplateParameter".equals(propName) || "viewAction".equals(propName) || (propDefn = destination.getElement().getPropertyDefn(propName)) == null) continue;
            Object value = null;
            if (propHandle.getElement() instanceof GroupElement && ("toc".equals(propName) || "pageBreakAfter".equals(propName) || "pageBreakBefore".equals(propName))) {
                value = propHandle.getElement().getLocalProperty(propHandle.getModule(), propDefn);
            } else if (onlyFactoryProperty) {
                value = propHandle.getElement().getFactoryProperty(propHandle.getModule(), propDefn);
            } else {
                if ("images".equals(propName)) {
                    Iterator images = source.getPropertyHandle("images").iterator();
                    while (images.hasNext()) {
                        StructureHandle image = (StructureHandle)images.next();
                        try {
                            ElementExportUtil.exportStructure(image, (LibraryHandle)destination, false);
                        }
                        catch (SemanticException e) {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                        }
                    }
                    continue;
                }
                value = propHandle.getElement().getStrategy().getPropertyExceptRomDefault(propHandle.getModule(), propHandle.getElement(), propDefn);
            }
            Object valueToSet = ModelUtil.copyValue(propHandle.getDefn(), value);
            destination.getElement().setProperty(propName, valueToSet);
        }
    }

    private static void duplicateExtensionIdentifier(DesignElementHandle source, DesignElementHandle destination) {
        if (source.getElement() instanceof IOdaExtendableElementModel) {
            String extensionId = (String)source.getProperty("extensionID");
            destination.getElement().setProperty("extensionID", (Object)extensionId);
        } else if (source.getElement() instanceof IExtendedItemModel) {
            String extensionId = (String)source.getProperty("extensionName");
            destination.getElement().setProperty("extensionName", (Object)extensionId);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    private static ArrayList cloneStructList(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<IStructure> returnList = new ArrayList<IStructure>();
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            if (item instanceof IStructure) {
                returnList.add(((IStructure)item).copy());
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        return returnList;
    }

    public static Object copyValue(IPropertyDefn propDefn, Object value) {
        if (value == null || propDefn == null) {
            return null;
        }
        switch (propDefn.getTypeCode()) {
            case 16: {
                if (propDefn.isList()) {
                    return ModelUtil.cloneStructList((List)value);
                }
                return ((Structure)value).copy();
            }
            case 15: 
            case 19: {
                ReferenceValue refValue = (ReferenceValue)value;
                return refValue.copy();
            }
            case 20: {
                return ModelUtil.clonePropertyList((List)value);
            }
        }
        return value;
    }

    private static Object clonePropertyList(List value) {
        if (value == null) {
            return null;
        }
        ArrayList<Object> returnList = new ArrayList<Object>();
        for (int i = 0; i < value.size(); ++i) {
            Object item = value.get(i);
            if (item instanceof ElementRefValue) {
                returnList.add(((ElementRefValue)item).copy());
                continue;
            }
            returnList.add(item);
        }
        return returnList;
    }

    public static List filterNotificationTasks(List tasks) {
        ArrayList<RecordTask> notifications = new ArrayList<RecordTask>();
        for (int i = 0; i < tasks.size(); ++i) {
            RecordTask task = (RecordTask)tasks.get(i);
            if (!(task instanceof NotificationRecordTask)) continue;
            notifications.add(task);
        }
        return EventFilter.getInstance().filter(notifications);
    }

    public static List filterLayoutTasks(List tasks) {
        ArrayList<RecordTask> retList = new ArrayList<RecordTask>();
        LinkedHashSet<DesignElement> elements = new LinkedHashSet<DesignElement>();
        for (int i = 0; i < tasks.size(); ++i) {
            DesignElement compoundElement;
            RecordTask task = (RecordTask)tasks.get(i);
            if (!(task instanceof LayoutRecordTask) || elements.contains(compoundElement = (DesignElement)((LayoutRecordTask)task).getTarget())) continue;
            retList.add(task);
            elements.add(compoundElement);
        }
        return retList;
    }

    public static Exception getFirstFatalException(List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String errorCode;
            XMLParserException parserException;
            Exception ex = (Exception)iter.next();
            if (!(ex instanceof XMLParserException) || !((parserException = (XMLParserException)ex).getException() instanceof LibraryException) || (errorCode = ((LibraryException)((Object)parserException.getException())).getErrorCode()) != "Error.LibraryException.LIBRARY_INCLUDED_RECURSIVELY" && errorCode != "Error.LibraryException.DUPLICATE_LIBRARY_NAMESPACE") continue;
            return parserException.getException();
        }
        return null;
    }

    public static String checkUTFSignature(InputStream inputStream, String fileName) throws IOException, SAXException {
        String encoding = UnicodeUtil.checkUTFSignature(inputStream);
        if (encoding != null && !"UTF-8".equals(encoding)) {
            DesignParserException cause = new DesignParserException("Error.DesignParserException.UNSUPPORTED_ENCODING");
            DesignFileException fileException = new DesignFileException(fileName, (Exception)((Object)cause));
            throw new SAXException((Exception)((Object)fileException));
        }
        return encoding;
    }

    public static List sortPropertiesByLocalizedName(List propDefns) {
        ULocale locale = ThreadResources.getLocale();
        Collator collator = Collator.getInstance((ULocale)locale);
        if (Locale.ENGLISH.equals(locale)) {
            collator.setStrength(0);
        }
        final HashMap<PropertyDefn, CollationKey> keysMap = new HashMap<PropertyDefn, CollationKey>();
        for (int i = 0; i < propDefns.size(); ++i) {
            PropertyDefn propDefn = (PropertyDefn)propDefns.get(i);
            CollationKey key = collator.getCollationKey(propDefn.getDisplayName());
            keysMap.put(propDefn, key);
        }
        Collections.sort(propDefns, new Comparator(){

            public int compare(Object o1, Object o2) {
                PropertyDefn p1 = (PropertyDefn)o1;
                PropertyDefn p2 = (PropertyDefn)o2;
                CollationKey key1 = (CollationKey)keysMap.get(p1);
                CollationKey key2 = (CollationKey)keysMap.get(p2);
                return key1.compareTo(key2);
            }
        });
        return propDefns;
    }

    public static List sortElementsByName(List elements) {
        ArrayList temp = new ArrayList(elements);
        Collections.sort(temp, new Comparator(){

            public int compare(Object o1, Object o2) {
                DesignElementHandle handle1 = (DesignElementHandle)o1;
                DesignElementHandle handle2 = (DesignElementHandle)o2;
                String name1 = handle1.getName();
                String name2 = handle2.getName();
                if (null == name1) {
                    if (null == name2) {
                        return 0;
                    }
                    return -1;
                }
                if (null == name2) {
                    return 1;
                }
                return name1.compareTo(name2);
            }
        });
        return temp;
    }

    public static void insertCompatibleThemeToLibrary(Library library, Theme theme) {
        if (!$assertionsDisabled && library == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && theme == null) {
            throw new AssertionError();
        }
        String name = theme.getName();
        if (!($assertionsDisabled || !StringUtil.isBlank(name) && ModelMessages.getMessage("Theme.defaultThemeName").equals(name))) {
            throw new AssertionError();
        }
        NameSpace ns = library.getNameSpace(6);
        if (!$assertionsDisabled && !library.getModuleNameSpace(6).canContain(name)) {
            throw new AssertionError();
        }
        ns.insert(theme);
        library.getSlot(0).add(theme);
        theme.setContainer(library, 0);
    }

    public static void reviseNameSpace(Module module, DesignElement content, String nameSpace) {
        List propDefns = content.getPropertyDefns();
        for (int i = 0; i < propDefns.size(); ++i) {
            Object value;
            ElementPropertyDefn propDefn = (ElementPropertyDefn)propDefns.get(i);
            if (propDefn.getTypeCode() != 15 || (value = content.getLocalProperty(module, propDefn)) == null) continue;
            ReferenceValue refValue = (ReferenceValue)value;
            refValue.setLibraryNamespace(nameSpace);
        }
        IElementDefn defn = content.getDefn();
        for (int i = 0; i < defn.getSlotCount(); ++i) {
            ContainerSlot slot = content.getSlot(i);
            if (slot == null) continue;
            for (int pos = 0; pos < slot.getCount(); ++pos) {
                ModelUtil.reviseNameSpace(module, slot.getContent(pos), nameSpace);
            }
        }
    }

    public static boolean containElement(DesignElement element, IElementDefn defn) {
        if (element == null || defn == null) {
            return false;
        }
        int count = element.getDefn().getSlotCount();
        for (int i = 0; i < count; ++i) {
            Iterator iter = element.getSlot(i).iterator();
            while (iter.hasNext()) {
                DesignElement e = (DesignElement)iter.next();
                IElementDefn targetDefn = e.getDefn();
                if (defn.isKindOf(targetDefn)) {
                    return true;
                }
                if (!ModelUtil.containElement(e, defn)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containElement(DesignElement element, String elementName) {
        IElementDefn defn = MetaDataDictionary.getInstance().getElement(elementName);
        return ModelUtil.containElement(element, defn);
    }

    public static DesignElement getCopy(DesignElement element) {
        if (element == null) {
            return null;
        }
        try {
            DesignElement copy = (DesignElement)element.clone();
            if (!$assertionsDisabled && copy == null) {
                throw new AssertionError();
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    private static String searchForExternalizedValue(DesignElement element, String propIDName, ULocale locale) {
        while (element != null) {
            Module root = element.getRoot();
            String textKey = (String)element.getLocalProperty(root, propIDName);
            if (!StringUtil.isBlank(textKey)) {
                String externalizedText = root.getMessage(textKey, locale);
                return externalizedText;
            }
            element = element.getExtendsElement();
        }
        return null;
    }

    public static String getExternalizedValue(DesignElement element, String propIDName, String propName, ULocale locale) {
        if (element == null) {
            return null;
        }
        String textKey = ModelUtil.searchForExternalizedValue(element, propIDName, locale);
        if (!StringUtil.isBlank(textKey)) {
            return textKey;
        }
        return element.getStringProperty(element.getRoot(), propName);
    }

    public static boolean hasLibrary(ReportDesignHandle designToExport, LibraryHandle targetLibraryHandle) {
        String reportLocation = targetLibraryHandle.getModule().getLocation();
        List libList = designToExport.getModule().getAllLibraries();
        Iterator libIter = libList.iterator();
        while (libIter.hasNext()) {
            Library library = (Library)libIter.next();
            String libLocation = library.getRoot().getLocation();
            if (!reportLocation.equals(libLocation)) continue;
            return true;
        }
        return false;
    }

    public static List checkVersion(String version) {
        ArrayList<VersionInfo> rtnList = new ArrayList<VersionInfo>();
        if (StringUtil.compareVersion(version, "3") < 1 && StringUtil.compareVersion("3.2.2", "3") > 0) {
            rtnList.add(new VersionInfo(version, 1));
        }
        return rtnList;
    }

    static {
        $assertionsDisabled = !ModelUtil.class.desiredAssertionStatus();
    }
}

