/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.validators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefn;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefnSet;
import org.eclipse.birt.report.model.validators.ValidationNode;

public class ValidationExecutor {
    private Module module;

    public ValidationExecutor(Module module) {
        this.module = module;
    }

    public List perform(DesignElement targetElement, List nodes) {
        ArrayList exceptionList = new ArrayList();
        Iterator iter = this.reorganize(nodes).iterator();
        while (iter.hasNext()) {
            ValidationNode node = (ValidationNode)iter.next();
            List errors = node.perform(this.module, false);
            if (targetElement == node.getElement()) {
                exceptionList.addAll(errors);
            }
            if (!node.getTriggerDefn().isPreRequisite() || errors.isEmpty()) continue;
            break;
        }
        return exceptionList;
    }

    public List perform(List nodes, boolean sendEvent) {
        ArrayList allErrors = new ArrayList();
        Iterator iter = this.reorganize(nodes).iterator();
        while (iter.hasNext()) {
            ValidationNode node = (ValidationNode)iter.next();
            List errors = node.perform(this.module, sendEvent);
            allErrors.addAll(errors);
            if (!node.getTriggerDefn().isPreRequisite() || errors.isEmpty()) continue;
            break;
        }
        return allErrors;
    }

    private List reorganize(List nodes) {
        ArrayList<ValidationNode> newList = new ArrayList<ValidationNode>();
        Iterator iter = nodes.iterator();
        HashSet<String> validationIDs = new HashSet<String>();
        while (iter.hasNext()) {
            ValidationNode node = (ValidationNode)iter.next();
            String id = node.getTriggerDefn().getValidationID();
            if (validationIDs.contains(id)) continue;
            validationIDs.add(id);
            if (node.getTriggerDefn().isPreRequisite()) {
                newList.add(0, node);
                continue;
            }
            newList.add(node);
        }
        return newList;
    }

    public static List getValidationNodes(DesignElement element, SemanticTriggerDefnSet triggers, boolean onlyOnSelf) {
        ArrayList<ValidationNode> nodes = new ArrayList<ValidationNode>();
        List validatorDefns = triggers.getTriggerList();
        if (validatorDefns == null || validatorDefns.isEmpty()) {
            return nodes;
        }
        Iterator iter = validatorDefns.iterator();
        while (iter.hasNext()) {
            ElementDefn elementDefn;
            SemanticTriggerDefn triggerDefn = (SemanticTriggerDefn)iter.next();
            String targetName = triggerDefn.getTargetElement();
            if (StringUtil.isBlank(targetName)) {
                nodes.add(new ValidationNode(element, triggerDefn));
                continue;
            }
            ElementDefn targetDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement(targetName);
            if (!targetDefn.isKindOf(elementDefn = (ElementDefn)element.getDefn()) && onlyOnSelf) continue;
            nodes.add(new ValidationNode(element, triggerDefn));
        }
        return nodes;
    }
}

