/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.actions;

import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.ui.dse.DSEPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;

public class DuplicateProfileAction
implements IActionDelegate {
    private Shell mParentShell = null;
    private IConnectionProfile mConnectionProfile = null;

    public DuplicateProfileAction() {
        Display display = Display.getCurrent();
        this.mParentShell = display.getActiveShell();
    }

    public void run(IAction action) {
        try {
            String newProfile = ProfileManager.getInstance().duplicateProfile(this.mConnectionProfile);
            IConnectionProfile profile = ProfileManager.getInstance().getProfileByName(newProfile);
            if (profile.isAutoConnect()) {
                profile.connect();
            }
        }
        catch (ConnectionProfileException e) {
            ExceptionHandler.showException((Shell)this.mParentShell, (String)DSEPlugin.getDefault().getResourceString("dialog.title.error"), (String)e.getMessage(), (Throwable)e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mConnectionProfile = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            action.setEnabled(false);
            if (structuredSelection.size() == 1) {
                Object selectedResource = structuredSelection.getFirstElement();
                action.setEnabled(selectedResource instanceof IConnectionProfile);
                if (selectedResource instanceof IConnectionProfile) {
                    this.mConnectionProfile = (IConnectionProfile)selectedResource;
                }
            }
        }
    }
}

