/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.actions;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.ProfileExtensionProvider;
import org.eclipse.datatools.connectivity.ui.PingJob;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class PingAction
implements IActionDelegate,
ISelectionProvider {
    private Shell mParentShell = null;
    private IConnectionProfile mConnectionProfile = null;

    public PingAction() {
        Display display = Display.getCurrent();
        this.mParentShell = display.getActiveShell();
    }

    public void run(IAction action) {
        PropertyDialogAction propertyDialogAction = new PropertyDialogAction(this.mParentShell, (ISelectionProvider)this);
        propertyDialogAction.selectionChanged((IStructuredSelection)this.getSelection());
        if (!this.mConnectionProfile.arePropertiesComplete() && propertyDialogAction.isApplicableForSelection()) {
            PreferenceDialog dialog = propertyDialogAction.createDialog();
            String initialPage = this.getInitialPropertyPageID();
            if (initialPage != null) {
                ((IWorkbenchPreferenceContainer)dialog).openPage(initialPage, null);
            }
            if (dialog.open() == 1) {
                return;
            }
        }
        new PingJob(this.mParentShell, this.mConnectionProfile).schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object selectedResource;
        IStructuredSelection structuredSelection;
        this.mConnectionProfile = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (selectedResource = structuredSelection.getFirstElement()) instanceof IConnectionProfile) {
            this.mConnectionProfile = (IConnectionProfile)selectedResource;
            action.setEnabled(this.mConnectionProfile.getProvider().getConnectionFactories().containsKey("org.eclipse.datatools.connectivity.connectionFactory.pingFactory"));
        }
    }

    protected String getInitialPropertyPageID() {
        if (!this.mConnectionProfile.arePropertiesComplete(this.mConnectionProfile.getProviderId())) {
            return ((ConnectionProfileProvider)this.mConnectionProfile.getProvider()).getPropertiesPersistenceHook().getConnectionPropertiesPageID();
        }
        Iterator it = this.mConnectionProfile.getProfileExtensions().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String extID = (String)entry.getKey();
            if (this.mConnectionProfile.arePropertiesComplete(extID)) continue;
            return ((ProfileExtensionProvider)entry.getValue()).getPropertiesPersistenceHook().getConnectionPropertiesPageID();
        }
        return null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.mConnectionProfile);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }
}

