/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.views;

import com.ibm.icu.text.MessageFormat;
import java.util.Properties;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.Version;
import org.eclipse.datatools.connectivity.internal.ui.CCOverLayIconUtility;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.SharedImages;
import org.eclipse.datatools.connectivity.ui.ProfileImageRegistry;
import org.eclipse.datatools.connectivity.ui.dse.DSEPlugin;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class ConnectionProfileLabelProvider
extends LabelProvider
implements ICommonLabelProvider {
    public Image getImage(Object element) {
        Image image;
        if (element instanceof ICategory) {
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        } else if (element instanceof IConnectionProfile) {
            ImageRegistry registry;
            IConnectionProfile profile = (IConnectionProfile)element;
            image = ProfileImageRegistry.getInstance().getProfileImage(profile.getProvider());
            if (profile.isConnected() && (image = (registry = DSEPlugin.getDefault().getImageRegistry()).get(profile.getName().concat(SharedImages.IMAGE_RUNNING))) == null) {
                image = CCOverLayIconUtility.getDefault().addOverlayIcon(ProfileImageRegistry.getInstance().getProfileImage(profile.getProvider()), CCOverLayIconUtility.RUNNING);
                registry.put(profile.getName().concat(SharedImages.IMAGE_RUNNING), image);
            }
        } else {
            image = null;
        }
        return image;
    }

    public String getText(Object element) {
        String text = null;
        if (element instanceof ICategory) {
            text = ((ICategory)element).getName();
        } else if (element instanceof IConnectionProfile) {
            IConnectionProfile profile = (IConnectionProfile)element;
            StringBuffer sb = new StringBuffer(profile.getName());
            if (profile.isConnected()) {
                Properties props = profile.getBaseProperties();
                String serverName = props.getProperty("org.eclipse.datatools.connectivity.server.name");
                Version serverVersion = Version.valueOf((String)props.getProperty("org.eclipse.datatools.connectivity.server.version"));
                if (serverName != null && serverName.length() > 0 || serverVersion != Version.NULL_VERSION) {
                    String versionStr = MessageFormat.format((String)ConnectivityUIPlugin.getDefault().getResourceString("CommonLabelProviderBase.label.version"), (Object[])new String[]{profile.getName(), serverName, serverVersion.toString()});
                    sb = new StringBuffer(versionStr);
                }
            }
            text = sb.toString();
        } else {
            text = super.getText(element);
        }
        return text;
    }

    public void dispose() {
        super.dispose();
    }

    public void init(IExtensionStateModel aStateModel, ITreeContentProvider aContentProvider) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }
}

