/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preview.editors;

import org.eclipse.birt.report.designer.internal.ui.dialogs.InputParameterHtmlDialog;
import org.eclipse.birt.report.designer.internal.ui.editors.FileReportProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class ReportPreviewEditor
extends EditorPart {
    private Button bParameter;
    private Browser browser;
    private ProgressBar progressBar;
    protected InputParameterHtmlDialog parameterDialog;
    private Object model;
    private IReportProvider provider;

    public void doSave(IProgressMonitor monitor) {
        IReportProvider provider = this.getProvider();
        if (provider != null) {
            provider.saveReport((ModuleHandle)this.getModel(), (Object)this.getEditorInput(), monitor);
            this.firePropertyChange(257);
        }
    }

    protected IReportProvider getProvider() {
        if (this.provider == null) {
            this.provider = new FileReportProvider();
        }
        return this.provider;
    }

    public boolean isDirty() {
        return false;
    }

    public void createPartControl(Composite parent) {
        Composite mainPane = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        mainPane.setLayout((Layout)layout);
        mainPane.setLayoutData((Object)new GridData(1808));
        Composite buttonTray = new Composite(mainPane, 0);
        buttonTray.setLayoutData((Object)new GridData(256));
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 5;
        buttonTray.setLayout((Layout)rowLayout);
        this.bParameter = new Button(buttonTray, 8);
        this.bParameter.setToolTipText(Messages.getString((String)"PreviewEditor.parameter.tooltip"));
        this.bParameter.setText(Messages.getString((String)"PreviewEditor.parameter.tooltip"));
        this.progressBar = new ProgressBar(mainPane, 2);
        GridData gd = new GridData(3, 2, false, false);
        gd.heightHint = 10;
        gd.widthHint = 100;
        this.progressBar.setLayoutData((Object)gd);
        this.progressBar.setVisible(false);
        this.browser = new Browser(mainPane, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        this.browser.setLayoutData((Object)gd);
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent e) {
                ReportPreviewEditor.this.progressBar.setVisible(true);
            }
        });
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                ReportPreviewEditor.this.progressBar.setVisible(false);
            }
        });
        this.parameterDialog = new InputParameterHtmlDialog(Display.getCurrent().getActiveShell(), InputParameterHtmlDialog.TITLE, this.getFileUri(), this.browser);
        this.bParameter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPreviewEditor.this.parameterDialog.open();
                if (ReportPreviewEditor.this.parameterDialog.getReturnCode() == 1001) {
                    ReportPreviewEditor.this.display();
                }
            }
        });
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                Thread thread = new Thread(this, event){
                    private final /* synthetic */ WindowEvent val$event;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$event = val$event;
                    }

                    public void run() {
                        Display display = new Display();
                        Shell shell = new Shell(display);
                        shell.setText("New Window");
                        this.val$event.browser = new Browser((Composite)shell, 0);
                    }
                };
                thread.start();
            }
        });
        WebViewer.startup((Browser)this.browser);
    }

    public Object getModel() {
        return this.model;
    }

    protected void createActions() {
    }

    public String getFileUri() {
        IReportProvider provider;
        IEditorInput input = this.getEditorInput();
        if (input != null && (provider = this.getProvider()) != null) {
            return provider.getInputPath(input).toOSString();
        }
        return null;
    }

    public void display() {
        String uri;
        if (this.browser != null && (uri = this.getFileUri()) != null && uri.length() > 0) {
            WebViewer.display((String)uri, (String)"html", (Browser)this.browser, (String)"run");
        }
    }

    public void dispose() {
        super.dispose();
        this.bParameter = null;
        this.browser = null;
        this.model = null;
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        this.model = this.getProvider().getReportModuleHandle((Object)input);
        this.setInput(input);
        WebViewer.startup((Browser)this.browser);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(ActionRegistry.class)) {
            new ActionRegistry();
        }
        return super.getAdapter(adapter);
    }
}

