/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

class ColorSelectionCanvas
extends Canvas
implements PaintListener {
    Color[] colorMap = null;
    Color colorSelection = null;

    public ColorSelectionCanvas(Composite parent, int iStyle, Color[] colorMap) {
        super(parent, iStyle);
        this.addPaintListener(this);
        this.colorMap = colorMap;
    }

    public Color getColor() {
        return this.colorSelection;
    }

    public void setColor(Color color) {
        this.colorSelection = color;
    }

    public void paintControl(PaintEvent pe) {
        Color cBlack = new Color((Device)this.getDisplay(), 0, 0, 0);
        Color cWhite = new Color((Device)this.getDisplay(), 255, 255, 255);
        GC gc = pe.gc;
        gc.setForeground(cBlack);
        int iCellWidth = this.getSize().x / 8;
        int iCellHeight = this.getSize().y / 5;
        for (int iR = 0; iR < 5; ++iR) {
            for (int iC = 0; iC < 8; ++iC) {
                try {
                    gc.setBackground(this.colorMap[iR * 8 + iC]);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                gc.fillRectangle(iC * iCellWidth, iR * iCellHeight, iCellWidth, iCellHeight);
                if (this.colorSelection == null || !this.colorSelection.equals((Object)this.colorMap[iR * 8 + iC])) continue;
                gc.drawRectangle(iC * iCellWidth, iR * iCellHeight, iCellWidth - 2, iCellHeight - 2);
                gc.setForeground(cWhite);
                gc.drawRectangle(iC * iCellWidth + 1, iR * iCellHeight + 1, iCellWidth - 3, iCellHeight - 3);
                gc.setForeground(cBlack);
            }
        }
        cBlack.dispose();
        cWhite.dispose();
        gc.dispose();
    }

    public Color getColorAt(int x, int y) {
        int iCellWidth = this.getSize().x / 8;
        int iCellHeight = this.getSize().y / 5;
        int iHCell = x / iCellWidth;
        int iVCell = y / iCellHeight;
        int iArrayIndex = iVCell * 8 + iHCell;
        return this.colorMap[iArrayIndex];
    }
}

