/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Collection;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.AngleSelectorComposite;
import org.eclipse.birt.chart.ui.swt.composites.FillCanvas;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.IAngleChangeListener;
import org.eclipse.birt.chart.ui.swt.composites.IntegerSpinControl;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class GradientEditorDialog
implements SelectionListener,
Listener,
IAngleChangeListener {
    private transient Composite cmpContent = null;
    private transient Composite cmpGeneral = null;
    private transient Composite cmpButtons = null;
    private transient Button btnAccept = null;
    private transient Button btnCancel = null;
    private transient FillChooserComposite fccStartColor = null;
    private transient FillChooserComposite fccEndColor = null;
    private transient Button cbCyclic = null;
    private transient Group grpRotation = null;
    private transient AngleSelectorComposite ascRotation = null;
    private transient IntegerSpinControl iscRotation = null;
    private transient Gradient gCurrent = null;
    private transient Gradient gBackup = null;
    private transient boolean bWasCancelled = true;
    private transient FillCanvas cnvPreview = null;
    private transient Shell shell = null;
    private transient ChartWizardContext wizardContext;

    public GradientEditorDialog(Shell shellParent, ChartWizardContext wizardContext, Gradient gSelected, ColorDefinition selectedColor) {
        this.wizardContext = wizardContext;
        this.gCurrent = gSelected;
        if (this.gCurrent != null) {
            this.gBackup = (Gradient)EcoreUtil.copy((EObject)gSelected);
        } else {
            this.gCurrent = AttributeFactory.eINSTANCE.createGradient();
            this.setGradientColor(this.gCurrent, selectedColor);
        }
        this.shell = new Shell(shellParent, 67696);
        this.shell.setLayout((Layout)new FillLayout());
        ChartUIUtil.bindHelp((Control)this.shell, (String)"org.eclipse.birt.chart.cshelp.GradientEditor_ID");
        this.placeComponents();
        this.shell.setText(Messages.getString("GradientEditorDialog.Lbl.GradientEditor"));
        this.shell.setSize(400, 320);
        this.shell.setDefaultButton(this.btnAccept);
        UIHelper.centerOnScreen((Shell)this.shell);
        this.shell.layout();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    public GradientEditorDialog(Shell shellParent, ChartWizardContext wizardContext, Gradient gSelected) {
        this(shellParent, wizardContext, gSelected, ColorDefinitionImpl.create((int)0, (int)0, (int)254));
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.horizontalSpacing = 5;
        glContent.verticalSpacing = 5;
        this.cmpContent = new Composite((Composite)this.shell, 0);
        this.cmpContent.setLayout((Layout)glContent);
        GridLayout glGeneral = new GridLayout();
        glContent.numColumns = 2;
        glContent.horizontalSpacing = 5;
        glContent.verticalSpacing = 5;
        this.cmpGeneral = new Composite(this.cmpContent, 0);
        GridData gdCMPGeneral = new GridData(1808);
        this.cmpGeneral.setLayoutData((Object)gdCMPGeneral);
        this.cmpGeneral.setLayout((Layout)glGeneral);
        Label lblStartColor = new Label(this.cmpGeneral, 0);
        GridData gdLBLStartColor = new GridData();
        lblStartColor.setLayoutData((Object)gdLBLStartColor);
        lblStartColor.setText(Messages.getString("GradientEditorDialog.Lbl.StartColor"));
        this.fccStartColor = new FillChooserComposite(this.cmpGeneral, 0, this.wizardContext, (Fill)this.gCurrent.getStartColor(), false, false);
        GridData gdFCCStartColor = new GridData(768);
        this.fccStartColor.setLayoutData(gdFCCStartColor);
        this.fccStartColor.addListener(this);
        Label lblEndColor = new Label(this.cmpGeneral, 0);
        GridData gdLBLEndColor = new GridData();
        lblEndColor.setLayoutData((Object)gdLBLEndColor);
        lblEndColor.setText(Messages.getString("GradientEditorDialog.Lbl.EndColor"));
        this.fccEndColor = new FillChooserComposite(this.cmpGeneral, 0, this.wizardContext, (Fill)this.gCurrent.getEndColor(), false, false);
        GridData gdFCCEndColor = new GridData(768);
        this.fccEndColor.setLayoutData(gdFCCEndColor);
        this.fccEndColor.addListener(this);
        Label lblDummy = new Label(this.cmpGeneral, 0);
        GridData gdLBLDummy = new GridData(1808);
        lblDummy.setLayoutData((Object)gdLBLDummy);
        this.createRotationPanel();
        Group grpPreview = new Group(this.cmpContent, 0);
        GridData gdGRPPreview = new GridData(1808);
        gdGRPPreview.horizontalSpan = 2;
        grpPreview.setLayoutData((Object)gdGRPPreview);
        grpPreview.setLayout((Layout)new FillLayout());
        grpPreview.setText(Messages.getString("GradientEditorDialog.Lbl.Preview"));
        this.cnvPreview = new FillCanvas((Composite)grpPreview, 524288);
        this.cnvPreview.setFill((Fill)this.gCurrent);
        GridLayout glButtons = new GridLayout();
        glButtons.numColumns = 2;
        glButtons.horizontalSpacing = 5;
        glButtons.verticalSpacing = 5;
        glButtons.marginHeight = 2;
        glButtons.marginWidth = 7;
        this.cmpButtons = new Composite(this.cmpContent, 0);
        GridData gdCMPButtons = new GridData(768);
        gdCMPButtons.horizontalSpan = 4;
        this.cmpButtons.setLayoutData((Object)gdCMPButtons);
        this.cmpButtons.setLayout((Layout)glButtons);
        this.btnAccept = new Button(this.cmpButtons, 8);
        GridData gdBTNAccept = new GridData(896);
        gdBTNAccept.grabExcessHorizontalSpace = true;
        this.btnAccept.setLayoutData((Object)gdBTNAccept);
        this.btnAccept.setText(Messages.getString("Shared.Lbl.OK"));
        this.btnAccept.addSelectionListener((SelectionListener)this);
        this.btnCancel = new Button(this.cmpButtons, 8);
        GridData gdBTNCancel = new GridData(128);
        gdBTNCancel.grabExcessHorizontalSpace = false;
        this.btnCancel.setLayoutData((Object)gdBTNCancel);
        this.btnCancel.setText(Messages.getString("Shared.Lbl.Cancel"));
        this.btnCancel.addSelectionListener((SelectionListener)this);
    }

    private void createRotationPanel() {
        GridLayout glRotation = new GridLayout();
        glRotation.verticalSpacing = 2;
        glRotation.marginHeight = 2;
        glRotation.marginWidth = 2;
        glRotation.numColumns = 3;
        this.grpRotation = new Group(this.cmpContent, 0);
        GridData gdGRPRotation = new GridData(1808);
        gdGRPRotation.heightHint = 180;
        this.grpRotation.setLayoutData((Object)gdGRPRotation);
        this.grpRotation.setLayout((Layout)glRotation);
        this.grpRotation.setText(Messages.getString("GradientEditorDialog.Lbl.Rotation"));
        this.ascRotation = new AngleSelectorComposite((Composite)this.grpRotation, 2048, (int)this.gCurrent.getDirection(), Display.getCurrent().getSystemColor(1));
        GridData gdASCRotation = new GridData(1808);
        gdASCRotation.horizontalSpan = 1;
        gdASCRotation.verticalSpan = 3;
        this.ascRotation.setLayoutData(gdASCRotation);
        this.ascRotation.setAngleChangeListener(this);
        this.iscRotation = new IntegerSpinControl((Composite)this.grpRotation, 0, (int)this.gCurrent.getDirection());
        GridData gdISCRotation = new GridData(768);
        gdISCRotation.horizontalSpan = 2;
        this.iscRotation.setLayoutData(gdISCRotation);
        this.iscRotation.setMinimum(-90);
        this.iscRotation.setMaximum(90);
        this.iscRotation.setIncrement(1);
        this.iscRotation.addListener(this);
    }

    public Gradient getGradient() {
        if (this.bWasCancelled) {
            return this.gBackup;
        }
        return this.gCurrent;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.cbCyclic)) {
            this.gCurrent.setCyclic(this.cbCyclic.getSelection());
        } else if (e.getSource().equals(this.btnAccept)) {
            this.bWasCancelled = false;
            this.shell.dispose();
        } else if (e.getSource().equals(this.btnCancel)) {
            this.gCurrent = this.gBackup;
            this.shell.dispose();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.fccStartColor)) {
            this.gCurrent.setStartColor((ColorDefinition)event.data);
        } else if (event.widget.equals((Object)this.fccEndColor)) {
            this.gCurrent.setEndColor((ColorDefinition)event.data);
        } else if (event.widget.equals((Object)this.iscRotation)) {
            this.gCurrent.setDirection((double)this.iscRotation.getValue());
            this.ascRotation.setAngle(this.iscRotation.getValue());
            this.ascRotation.redraw();
        }
        this.cnvPreview.redraw();
    }

    public void angleChanged(int iNewAngle) {
        this.iscRotation.setValue(iNewAngle);
        this.gCurrent.setDirection((double)iNewAngle);
    }

    private int convertRGBToLuminance(int red, int green, int blue) {
        return (int)(0.3 * (double)red + 0.59 * (double)green + 0.11 * (double)blue);
    }

    private int getNewColor(int lumDiff, int oldColor, double coefficient) {
        int newColor = (int)((double)lumDiff * coefficient) + oldColor;
        return newColor < 255 ? newColor : 255;
    }

    private void setGradientColor(Gradient gradient, ColorDefinition selectedColor) {
        int currentLuminance = this.convertRGBToLuminance(selectedColor.getRed(), selectedColor.getGreen(), selectedColor.getBlue());
        if (currentLuminance < 200) {
            gradient.setStartColor(selectedColor);
            ColorDefinition newColor = (ColorDefinition)EcoreUtil.copy((EObject)selectedColor);
            newColor.eAdapters().addAll((Collection)selectedColor.eAdapters());
            int lumDiff = 240 - currentLuminance;
            newColor.setRed(this.getNewColor(lumDiff, newColor.getRed(), 0.3));
            newColor.setGreen(this.getNewColor(lumDiff, newColor.getGreen(), 0.59));
            newColor.setBlue(this.getNewColor(lumDiff, newColor.getBlue(), 0.11));
            gradient.setEndColor(newColor);
        } else {
            gradient.setEndColor(selectedColor);
            ColorDefinition newColor = (ColorDefinition)EcoreUtil.copy((EObject)selectedColor);
            newColor.eAdapters().addAll((Collection)selectedColor.eAdapters());
            int lumDiff = -100;
            newColor.setRed(this.getNewColor(lumDiff, newColor.getRed(), 0.3));
            newColor.setGreen(this.getNewColor(lumDiff, newColor.getGreen(), 0.59));
            newColor.setBlue(this.getNewColor(lumDiff, newColor.getBlue(), 0.11));
            gradient.setStartColor(newColor);
        }
    }
}

