/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Vector;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.FontDefinitionComposite;
import org.eclipse.birt.chart.ui.swt.composites.InsetsComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class LabelAttributesComposite
extends Composite
implements SelectionListener,
Listener {
    private transient Composite cmpGeneral = null;
    private transient Composite grpAttributes = null;
    private transient Group grpOutline = null;
    private transient Button cbVisible = null;
    private transient org.eclipse.swt.widgets.Label lblPosition = null;
    private transient org.eclipse.swt.widgets.Label lblFill = null;
    private transient org.eclipse.swt.widgets.Label lblShadow = null;
    private transient org.eclipse.swt.widgets.Label lblFont = null;
    private transient Combo cmbPosition = null;
    private transient FontDefinitionComposite fdcFont = null;
    private transient FillChooserComposite fccBackground = null;
    private transient FillChooserComposite fccShadow = null;
    private transient InsetsComposite icInsets = null;
    private transient String sGroupName = Messages.getString("LabelAttributesComposite.Lbl.Label");
    private transient Position lpCurrent = null;
    private transient Fill fBackground = null;
    private transient ColorDefinition cdShadow = null;
    private transient FontDefinition fdCurrent = null;
    private transient ColorDefinition cdFont = null;
    private transient LineAttributes laCurrent = null;
    private transient Label lblCurrent = null;
    private transient Insets insets = null;
    private transient String sUnits = null;
    private transient LineAttributesComposite liacOutline = null;
    private transient Vector vListeners = null;
    public static final int VISIBILITY_CHANGED_EVENT = 1;
    public static final int POSITION_CHANGED_EVENT = 2;
    public static final int FONT_CHANGED_EVENT = 3;
    public static final int BACKGROUND_CHANGED_EVENT = 4;
    public static final int SHADOW_CHANGED_EVENT = 5;
    public static final int OUTLINE_STYLE_CHANGED_EVENT = 6;
    public static final int OUTLINE_WIDTH_CHANGED_EVENT = 7;
    public static final int OUTLINE_COLOR_CHANGED_EVENT = 8;
    public static final int OUTLINE_VISIBILITY_CHANGED_EVENT = 9;
    public static final int INSETS_CHANGED_EVENT = 10;
    public static final int ALLOW_ALL_POSITION = 0;
    public static final int ALLOW_VERTICAL_POSITION = 1;
    public static final int ALLOW_HORIZONTAL_POSITION = 2;
    public static final int ALLOW_INOUT_POSITION = 4;
    private transient boolean bPositionEnabled = true;
    private transient boolean bVisibilityEnabled = true;
    private transient boolean bEnabled = true;
    private int positionScope = 0;
    private transient boolean bInsetsEnabled = true;
    private transient boolean bShadowEnabled = true;
    private transient boolean isAlignmentEnabled = true;
    private transient ChartWizardContext wizardContext;

    public LabelAttributesComposite(Composite parent, int style, String sGroupName, Position lpCurrent, Label lblCurrent, String sUnits, boolean bPositionEnabled, boolean bVisibilityEnabled, ChartWizardContext wizardContext, boolean isAlignmentEnabled) {
        this(parent, style, sGroupName, lpCurrent, lblCurrent, sUnits, bPositionEnabled, bVisibilityEnabled, wizardContext, 0, isAlignmentEnabled);
    }

    public LabelAttributesComposite(Composite parent, int style, String sGroupName, Position lpCurrent, Label lblCurrent, String sUnits, boolean bPositionEnabled, boolean bVisibilityEnabled, ChartWizardContext wizardContext, int positionScope, boolean isAlignmentEnabled) {
        super(parent, style);
        this.sGroupName = sGroupName;
        this.lpCurrent = lpCurrent;
        this.lblCurrent = lblCurrent;
        this.sUnits = sUnits;
        this.fdCurrent = lblCurrent.getCaption().getFont();
        this.cdFont = lblCurrent.getCaption().getColor();
        this.fBackground = lblCurrent.getBackground();
        this.cdShadow = lblCurrent.getShadowColor();
        this.laCurrent = lblCurrent.getOutline();
        this.insets = lblCurrent.getInsets();
        this.bPositionEnabled = bPositionEnabled;
        this.bVisibilityEnabled = bVisibilityEnabled;
        this.wizardContext = wizardContext;
        this.positionScope = positionScope;
        this.isAlignmentEnabled = isAlignmentEnabled;
        this.init();
        this.placeComponents();
    }

    public LabelAttributesComposite(Composite parent, int style, String sGroupName, Label lblCurrent, String sUnits, boolean bPositionEnabled, boolean bVisibilityEnabled, ChartWizardContext wizardContext, boolean bInsetsEnabled, boolean bShadowEnabled, boolean isAlignmentEnabled) {
        super(parent, style);
        this.sGroupName = sGroupName;
        this.lblCurrent = lblCurrent;
        this.sUnits = sUnits;
        this.fdCurrent = lblCurrent.getCaption().getFont();
        this.cdFont = lblCurrent.getCaption().getColor();
        this.fBackground = lblCurrent.getBackground();
        this.cdShadow = lblCurrent.getShadowColor();
        this.laCurrent = lblCurrent.getOutline();
        this.insets = lblCurrent.getInsets();
        this.bPositionEnabled = bPositionEnabled;
        this.bVisibilityEnabled = bVisibilityEnabled;
        this.wizardContext = wizardContext;
        this.bInsetsEnabled = bInsetsEnabled;
        this.bShadowEnabled = bShadowEnabled;
        this.isAlignmentEnabled = isAlignmentEnabled;
        this.init();
        this.placeComponents();
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
        this.vListeners = new Vector();
    }

    private void placeComponents() {
        FillLayout flMain = new FillLayout();
        flMain.marginHeight = 0;
        flMain.marginWidth = 0;
        GridLayout glAttributes = new GridLayout();
        glAttributes.horizontalSpacing = 5;
        glAttributes.verticalSpacing = 5;
        glAttributes.marginHeight = 7;
        glAttributes.marginWidth = 7;
        GridLayout glGeneral = new GridLayout();
        glGeneral.numColumns = 2;
        glGeneral.horizontalSpacing = 5;
        glGeneral.verticalSpacing = 5;
        FillLayout flOutline = new FillLayout();
        this.setLayout((Layout)flMain);
        if (this.sGroupName == null || this.sGroupName.length() == 0) {
            this.grpAttributes = new Composite((Composite)this, 0);
        } else {
            this.grpAttributes = new Group((Composite)this, 0);
            ((Group)this.grpAttributes).setText(this.sGroupName);
        }
        this.grpAttributes.setLayout((Layout)glAttributes);
        this.cmpGeneral = new Composite(this.grpAttributes, 0);
        GridData gdCMPGeneral = new GridData(768);
        this.cmpGeneral.setLayoutData((Object)gdCMPGeneral);
        this.cmpGeneral.setLayout((Layout)glGeneral);
        boolean bEnableUI = this.bEnabled;
        if (this.bVisibilityEnabled) {
            this.cbVisible = new Button(this.cmpGeneral, 32);
            GridData gdCBVisible = new GridData(768);
            gdCBVisible.horizontalSpan = 2;
            this.cbVisible.setLayoutData((Object)gdCBVisible);
            this.cbVisible.setSelection(this.lblCurrent.isVisible());
            this.cbVisible.setText(Messages.getString("LabelAttributesComposite.Lbl.IsVisible"));
            this.cbVisible.addSelectionListener((SelectionListener)this);
            if (this.bEnabled) {
                bEnableUI = this.cbVisible.getSelection();
            }
        }
        if (this.bPositionEnabled) {
            this.lblPosition = new org.eclipse.swt.widgets.Label(this.cmpGeneral, 0);
            GridData gdLBLPosition = new GridData();
            this.lblPosition.setLayoutData((Object)gdLBLPosition);
            this.lblPosition.setText(Messages.getString("LabelAttributesComposite.Lbl.Position"));
            this.lblPosition.setEnabled(bEnableUI);
            this.cmbPosition = new Combo(this.cmpGeneral, 12);
            GridData gdCMBPosition = new GridData(1808);
            this.cmbPosition.setLayoutData((Object)gdCMBPosition);
            this.cmbPosition.addSelectionListener((SelectionListener)this);
            this.cmbPosition.setEnabled(bEnableUI);
        }
        this.lblFont = new org.eclipse.swt.widgets.Label(this.cmpGeneral, 0);
        GridData gdLFont = new GridData();
        this.lblFont.setLayoutData((Object)gdLFont);
        this.lblFont.setText(Messages.getString("LabelAttributesComposite.Lbl.Font"));
        this.lblFont.setEnabled(bEnableUI);
        this.fdcFont = new FontDefinitionComposite(this.cmpGeneral, 0, this.wizardContext, this.fdCurrent, this.cdFont, this.isAlignmentEnabled);
        GridData gdFDCFont = new GridData(1808);
        gdFDCFont.heightHint = this.fdcFont.getPreferredSize().y;
        gdFDCFont.widthHint = 96;
        gdFDCFont.grabExcessVerticalSpace = false;
        this.fdcFont.setLayoutData(gdFDCFont);
        this.fdcFont.addListener(this);
        this.fdcFont.setEnabled(bEnableUI);
        this.lblFill = new org.eclipse.swt.widgets.Label(this.cmpGeneral, 0);
        GridData gdLFill = new GridData();
        this.lblFill.setLayoutData((Object)gdLFill);
        this.lblFill.setText(Messages.getString("LabelAttributesComposite.Lbl.Background"));
        this.lblFill.setEnabled(bEnableUI);
        this.fccBackground = new FillChooserComposite(this.cmpGeneral, 0, this.wizardContext, this.fBackground, false, false);
        GridData gdFCCBackground = new GridData(1808);
        gdFCCBackground.heightHint = this.fccBackground.getPreferredSize().y;
        this.fccBackground.setLayoutData(gdFCCBackground);
        this.fccBackground.addListener(this);
        this.fccBackground.setEnabled(bEnableUI);
        if (this.bShadowEnabled) {
            this.lblShadow = new org.eclipse.swt.widgets.Label(this.cmpGeneral, 0);
            GridData gdLBLShadow = new GridData();
            this.lblShadow.setLayoutData((Object)gdLBLShadow);
            this.lblShadow.setText(Messages.getString("LabelAttributesComposite.Lbl.Shadow"));
            this.lblShadow.setEnabled(bEnableUI);
            this.fccShadow = new FillChooserComposite(this.cmpGeneral, 0, this.wizardContext, (Fill)this.cdShadow, false, false);
            GridData gdFCCShadow = new GridData(1808);
            this.fccShadow.setLayoutData(gdFCCShadow);
            this.fccShadow.addListener(this);
            this.fccShadow.setEnabled(bEnableUI);
        }
        this.grpOutline = new Group(this.grpAttributes, 0);
        GridData gdGOutline = new GridData(768);
        gdGOutline.heightHint = 110;
        this.grpOutline.setLayoutData((Object)gdGOutline);
        this.grpOutline.setText(Messages.getString("LabelAttributesComposite.Lbl.Outline"));
        this.grpOutline.setLayout((Layout)flOutline);
        this.grpOutline.setEnabled(bEnableUI);
        this.liacOutline = new LineAttributesComposite((Composite)this.grpOutline, 0, this.wizardContext, this.laCurrent, true, true, true);
        this.liacOutline.addListener(this);
        this.liacOutline.setEnabled(bEnableUI);
        if (this.bInsetsEnabled) {
            this.icInsets = new InsetsComposite(this.grpAttributes, 0, this.insets, this.sUnits, this.wizardContext.getUIServiceProvider());
            GridData gdICInsets = new GridData(768);
            gdICInsets.heightHint = this.icInsets.getPreferredSize().y;
            gdICInsets.grabExcessVerticalSpace = false;
            this.icInsets.addListener(this);
            this.icInsets.setLayoutData(gdICInsets);
            this.icInsets.setEnabled(bEnableUI);
        }
        this.populateLists();
    }

    public void setEnabled(boolean bState) {
        boolean bEnableUI = true;
        if (this.bVisibilityEnabled) {
            bEnableUI = this.cbVisible.getSelection();
            this.cbVisible.setEnabled(bState);
        }
        this.setVisibleState(bState & bEnableUI);
        this.grpAttributes.setEnabled(bState);
        this.bEnabled = bState;
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    private void populateLists() {
        if (this.bPositionEnabled) {
            if (this.positionScope == 0) {
                this.cmbPosition.setItems(LiteralHelper.fullPositionSet.getDisplayNames());
                if (this.lpCurrent != null) {
                    this.cmbPosition.select(LiteralHelper.fullPositionSet.getSafeNameIndex(this.lpCurrent.getName()));
                }
            } else {
                int i;
                String[] ns;
                if ((this.positionScope & 1) != 0) {
                    ns = LiteralHelper.verticalPositionSet.getDisplayNames();
                    for (i = 0; i < ns.length; ++i) {
                        this.cmbPosition.add(ns[i]);
                    }
                }
                if ((this.positionScope & 2) != 0) {
                    ns = LiteralHelper.horizontalPositionSet.getDisplayNames();
                    for (i = 0; i < ns.length; ++i) {
                        this.cmbPosition.add(ns[i]);
                    }
                }
                if ((this.positionScope & 4) != 0) {
                    ns = LiteralHelper.inoutPositionSet.getDisplayNames();
                    for (i = 0; i < ns.length; ++i) {
                        this.cmbPosition.add(ns[i]);
                    }
                }
                if (this.lpCurrent != null) {
                    for (int i2 = 0; i2 < this.cmbPosition.getItemCount(); ++i2) {
                        if (!this.lpCurrent.getName().equals(LiteralHelper.fullPositionSet.getNameByDisplayName(this.cmbPosition.getItem(i2)))) continue;
                        this.cmbPosition.select(i2);
                    }
                }
            }
        }
    }

    public void setLabel(Label lbl, String sUnits) {
        this.lblCurrent = lbl;
        this.sUnits = sUnits;
        this.fdCurrent = this.lblCurrent.getCaption().getFont();
        this.cdFont = this.lblCurrent.getCaption().getColor();
        this.fBackground = this.lblCurrent.getBackground();
        this.laCurrent = this.lblCurrent.getOutline();
        if (this.bVisibilityEnabled) {
            this.cbVisible.setSelection(this.lblCurrent.isVisible());
            this.setVisibleState(this.cbVisible.getSelection() && this.cbVisible.isEnabled());
        }
        if (this.bInsetsEnabled) {
            this.insets = this.lblCurrent.getInsets();
            this.icInsets.setInsets(this.insets, this.sUnits);
        }
        if (this.bShadowEnabled) {
            this.cdShadow = this.lblCurrent.getShadowColor();
            this.fccShadow.setFill((Fill)this.cdShadow);
        }
        this.fdcFont.setFontDefinition(this.fdCurrent);
        this.fdcFont.setFontColor(this.cdFont);
        this.fccBackground.setFill(this.fBackground);
        this.liacOutline.setLineAttributes(this.laCurrent);
        this.redraw();
    }

    public void setLabelPosition(Position pos) {
        this.lpCurrent = pos;
        if (this.bPositionEnabled) {
            this.cmbPosition.setText(LiteralHelper.fullPositionSet.getDisplayNameByName(this.lpCurrent.getName()));
        }
    }

    public void addListener(Listener listener) {
        this.vListeners.add(listener);
    }

    private void fireEvent(Event e) {
        for (int iL = 0; iL < this.vListeners.size(); ++iL) {
            ((Listener)this.vListeners.get(iL)).handleEvent(e);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Event eLabel = new Event();
        eLabel.widget = this;
        if (e.getSource().equals(this.cmbPosition)) {
            eLabel.data = Position.getByName((String)LiteralHelper.fullPositionSet.getNameByDisplayName(this.cmbPosition.getText()));
            eLabel.type = 2;
        } else if (e.getSource().equals(this.cbVisible)) {
            eLabel.data = new Boolean(this.cbVisible.getSelection());
            eLabel.type = 1;
            this.setVisibleState(this.cbVisible.getSelection());
        }
        this.fireEvent(eLabel);
    }

    private void setVisibleState(boolean isVisible) {
        if (this.bPositionEnabled) {
            this.lblPosition.setEnabled(isVisible);
            this.cmbPosition.setEnabled(isVisible);
        }
        this.lblFill.setEnabled(isVisible);
        this.lblFont.setEnabled(isVisible);
        this.fdcFont.setEnabled(isVisible);
        this.fccBackground.setEnabled(isVisible);
        if (this.bShadowEnabled) {
            this.lblShadow.setEnabled(isVisible);
            this.fccShadow.setEnabled(isVisible);
        }
        if (this.bInsetsEnabled) {
            this.icInsets.setEnabled(isVisible);
        }
        this.grpOutline.setEnabled(isVisible);
        this.liacOutline.setEnabled(isVisible);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Point getPreferredSize() {
        Point ptSize = new Point(300, 130);
        if (this.bVisibilityEnabled) {
            ptSize.y += 30;
        }
        if (this.bPositionEnabled) {
            ptSize.y += 30;
        }
        return ptSize;
    }

    public void handleEvent(Event event) {
        Event eLabel = new Event();
        eLabel.widget = this;
        if (event.widget.equals((Object)this.fdcFont)) {
            eLabel.type = 3;
        } else if (event.widget.equals((Object)this.liacOutline)) {
            switch (event.type) {
                case 1: {
                    eLabel.type = 6;
                    break;
                }
                case 2: {
                    eLabel.type = 7;
                    break;
                }
                case 3: {
                    eLabel.type = 8;
                    break;
                }
                case 4: {
                    eLabel.type = 9;
                }
            }
        } else if (event.widget.equals((Object)this.fccBackground)) {
            eLabel.type = 4;
        } else if (event.widget.equals((Object)this.fccShadow)) {
            eLabel.type = 5;
        } else if (event.widget.equals((Object)this.icInsets)) {
            eLabel.type = 10;
        }
        eLabel.data = event.data;
        this.fireEvent(eLabel);
    }
}

