/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Vector;
import org.eclipse.birt.chart.ui.swt.composites.LineCanvas;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class LineWidthChooserComposite
extends Composite
implements SelectionListener,
MouseListener {
    private transient Composite cmpContentInner = null;
    private transient Composite cmpContentOuter = null;
    private transient Composite cmpDropDown = null;
    private transient LineCanvas cnvSelection = null;
    private transient Button btnDown = null;
    private final int[] iLineWidths = new int[]{1, 2, 3, 4};
    private transient int iCurrentWidth = 1;
    private transient Vector vListeners = null;
    public static final int WIDTH_CHANGED_EVENT = 1;
    private transient int iSize = 18;
    private transient boolean bEnabled = true;
    private boolean bJustFocusLost = false;

    public LineWidthChooserComposite(Composite parent, int style, int iWidth) {
        super(parent, style);
        this.iCurrentWidth = iWidth;
        this.init();
        this.placeComponents();
        this.initAccessible();
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
        this.vListeners = new Vector();
    }

    private void placeComponents() {
        FillLayout flMain = new FillLayout();
        flMain.marginHeight = 0;
        flMain.marginWidth = 0;
        this.setLayout((Layout)flMain);
        this.cmpContentOuter = new Composite((Composite)this, 0);
        GridLayout glContentOuter = new GridLayout();
        glContentOuter.verticalSpacing = 0;
        glContentOuter.horizontalSpacing = 0;
        glContentOuter.marginHeight = 0;
        glContentOuter.marginWidth = 0;
        glContentOuter.numColumns = 1;
        this.cmpContentOuter.setLayout((Layout)glContentOuter);
        this.cmpContentInner = new Composite(this.cmpContentOuter, 2048);
        GridLayout glContentInner = new GridLayout();
        glContentInner.verticalSpacing = 0;
        glContentInner.horizontalSpacing = 0;
        glContentInner.marginHeight = 0;
        glContentInner.marginWidth = 0;
        glContentInner.numColumns = 2;
        this.cmpContentInner.setLayout((Layout)glContentInner);
        GridData gdContentInner = new GridData(768);
        this.cmpContentInner.setLayoutData((Object)gdContentInner);
        this.cnvSelection = new LineCanvas(this.cmpContentInner, 0, 1, 1);
        GridData gdCNVSelection = new GridData(1808);
        gdCNVSelection.heightHint = this.iSize;
        this.cnvSelection.setLayoutData(gdCNVSelection);
        this.cnvSelection.setLineWidth(this.iCurrentWidth);
        this.cnvSelection.addMouseListener(this);
        this.btnDown = new Button(this.cmpContentInner, 1028);
        GridData gdBDown = new GridData(4);
        gdBDown.verticalAlignment = 1;
        gdBDown.widthHint = this.iSize - 2;
        gdBDown.heightHint = this.iSize;
        this.btnDown.setLayoutData((Object)gdBDown);
        this.btnDown.addSelectionListener((SelectionListener)this);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                LineWidthChooserComposite.this.handleEventCanvas(event);
            }
        };
        int[] textEvents = new int[]{1, 31, 15, 16};
        for (int i = 0; i < textEvents.length; ++i) {
            this.cnvSelection.addListener(textEvents[i], listener);
        }
    }

    public void setEnabled(boolean bState) {
        this.btnDown.setEnabled(bState);
        this.cnvSelection.setEnabled(bState);
        this.bEnabled = bState;
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    private void createDropDownComponent(int iXLoc, int iYLoc) {
        if (!this.bEnabled) {
            return;
        }
        int shellWidth = this.getSize().x;
        Shell shell = new Shell(this.getShell(), 0);
        shell.setLayout((Layout)new FillLayout());
        shell.setSize(shellWidth, 150);
        if ((this.getStyle() & 0x4000000) != 0) {
            iXLoc -= shellWidth;
        }
        shell.setLocation(iXLoc, iYLoc);
        this.cmpDropDown = new Composite((Composite)shell, 0);
        FillLayout fillDropDown = new FillLayout();
        fillDropDown.type = 512;
        this.cmpDropDown.setLayout((Layout)fillDropDown);
        Listener listenerCmpDropDown = new Listener(){

            public void handleEvent(Event event) {
                LineWidthChooserComposite.this.handleEventCmpDropDown(event);
            }
        };
        int[] eventsCmpDrowDown = new int[]{1, 16};
        for (int i = 0; i < eventsCmpDrowDown.length; ++i) {
            this.cmpDropDown.addListener(eventsCmpDrowDown[i], listenerCmpDropDown);
        }
        for (int iC = 0; iC < this.iLineWidths.length; ++iC) {
            LineCanvas cnv = new LineCanvas(this.cmpDropDown, 0, 1, this.iLineWidths[iC]);
            cnv.setSize(this.cmpDropDown.getSize().x, this.cnvSelection.getSize().y);
            cnv.addMouseListener(this);
        }
        shell.layout();
        shell.open();
    }

    void handleEventCmpDropDown(Event event) {
        switch (event.type) {
            case 1: {
                this.keyPressed(new KeyEvent(event));
                break;
            }
            case 16: {
                this.focusLost(new FocusEvent(event));
            }
        }
    }

    public int getLineWidth() {
        return this.iCurrentWidth;
    }

    public void setLineWidth(int iWidth) {
        this.iCurrentWidth = iWidth;
        this.cnvSelection.setLineWidth(iWidth);
        this.cnvSelection.redraw();
    }

    public void addListener(Listener listener) {
        this.vListeners.add(listener);
    }

    private void toggleDropDown() {
        if (this.bJustFocusLost) {
            this.bJustFocusLost = false;
            return;
        }
        if (this.cmpDropDown == null || this.cmpDropDown.isDisposed() || !this.cmpDropDown.isVisible()) {
            Point pLoc = UIHelper.getScreenLocation((Composite)this);
            this.createDropDownComponent(pLoc.x, pLoc.y + this.getSize().y);
        } else {
            this.cmpDropDown.getShell().dispose();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object oSource = e.getSource();
        if (oSource.equals(this.btnDown)) {
            this.toggleDropDown();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Point getPreferredSize() {
        return new Point(100, 24);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (!this.bEnabled) {
            return;
        }
        if (e.getSource() instanceof LineCanvas) {
            if (e.getSource().equals((Object)this.cnvSelection)) {
                this.toggleDropDown();
            } else {
                this.iCurrentWidth = ((LineCanvas)((Object)e.getSource())).getLineWidth();
                this.cnvSelection.setLineWidth(this.iCurrentWidth);
                this.cnvSelection.redraw();
                this.fireEvent();
                if (!this.cmpDropDown.isDisposed()) {
                    this.cmpDropDown.getShell().dispose();
                }
            }
        }
    }

    public void mouseUp(MouseEvent e) {
    }

    private void fireEvent() {
        Event e = new Event();
        e.widget = this;
        e.data = new Integer(this.iCurrentWidth);
        e.type = 1;
        for (int i = 0; i < this.vListeners.size(); ++i) {
            ((Listener)this.vListeners.get(i)).handleEvent(e);
        }
    }

    void keyPressed(KeyEvent e) {
        if (!(this.cmpDropDown == null || this.cmpDropDown.getShell().isDisposed() || e.keyCode != 27 && e.keyCode != 0x1000001)) {
            this.cmpDropDown.getShell().dispose();
        }
    }

    void focusLost(FocusEvent e) {
        if (e.getSource().equals(this.cmpDropDown)) {
            Control cTmp = Display.getCurrent().getCursorControl();
            if (cTmp != null && (cTmp.equals((Object)this.cnvSelection) || cTmp.equals(this.btnDown))) {
                this.bJustFocusLost = true;
            }
            this.cmpDropDown.getShell().dispose();
        }
    }

    void handleEventCanvas(Event event) {
        switch (event.type) {
            case 15: {
                this.cnvSelection.redraw();
                break;
            }
            case 16: {
                this.cnvSelection.redraw();
                break;
            }
            case 1: {
                if (this.isDisposed()) break;
                if (event.keyCode == 0x1000002) {
                    event.doit = true;
                    this.toggleDropDown();
                    break;
                }
            }
            case 31: {
                switch (event.detail) {
                    case 4: 
                    case 8: 
                    case 16: 
                    case 32: 
                    case 64: {
                        event.doit = true;
                        this.cnvSelection.redraw();
                    }
                }
            }
        }
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = LineWidthChooserComposite.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = LineWidthChooserComposite.this.toControl(new Point(e.x, e.y));
                if (LineWidthChooserComposite.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = LineWidthChooserComposite.this.getBounds();
                Point pt = LineWidthChooserComposite.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }
        });
    }
}

