/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.RuleType;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.Rule;
import org.eclipse.birt.chart.model.data.impl.RuleImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RuleEditorDialog
implements SelectionListener {
    private transient List lstRules = null;
    private transient Composite cmpEdit = null;
    private transient Combo cmbType = null;
    private transient Text txtValue = null;
    private transient Button btnAdd = null;
    private transient Button btnRemove = null;
    private transient Button btnUpdate = null;
    private transient Composite cmpButtons = null;
    private transient Button btnAccept = null;
    private transient Button btnCancel = null;
    private transient Shell shell = null;
    private transient Vector vRules = null;
    public static final String RULE_SEPARATOR = " - ";
    private transient boolean bCancelled = false;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.composites");

    public RuleEditorDialog(Shell shellParent, Query query, String sTitle) {
        this.vRules = this.getRulesFromQuery(query);
        this.shell = new Shell(shellParent, 67696);
        GridLayout glShell = new GridLayout();
        glShell.numColumns = 2;
        glShell.marginHeight = 5;
        glShell.marginWidth = 5;
        glShell.horizontalSpacing = 5;
        this.shell.setLayout((Layout)glShell);
        this.placeComponents();
        this.shell.setText(new MessageFormat(Messages.getString("RuleEditorDialog.Title.RuleEditor")).format(new Object[]{sTitle}));
        this.shell.pack();
        this.shell.setDefaultButton(this.btnAccept);
        UIHelper.centerOnScreen((Shell)this.shell);
        this.shell.layout();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void placeComponents() {
        GridLayout glEdit = new GridLayout();
        glEdit.numColumns = 2;
        glEdit.horizontalSpacing = 5;
        glEdit.verticalSpacing = 5;
        GridLayout glList = new GridLayout();
        glList.marginWidth = 5;
        glList.marginHeight = 5;
        Group grpList = new Group((Composite)this.shell, 0);
        GridData gdGRPList = new GridData(1808);
        grpList.setLayoutData((Object)gdGRPList);
        grpList.setLayout((Layout)glList);
        grpList.setText(Messages.getString("RuleEditorDialog.Lbl.Rules"));
        this.lstRules = new List((Composite)grpList, 2820);
        GridData gdLSTRules = new GridData(1808);
        this.lstRules.setLayoutData((Object)gdLSTRules);
        this.lstRules.addSelectionListener((SelectionListener)this);
        this.cmpEdit = new Composite((Composite)this.shell, 0);
        GridData gdCMPEdit = new GridData(1810);
        this.cmpEdit.setLayoutData((Object)gdCMPEdit);
        this.cmpEdit.setLayout((Layout)glEdit);
        Label lblType = new Label(this.cmpEdit, 0);
        GridData gdLBLType = new GridData(2);
        gdLBLType.horizontalIndent = 2;
        lblType.setLayoutData((Object)gdLBLType);
        lblType.setText(Messages.getString("RuleEditorDialog.Lbl.Type"));
        this.cmbType = new Combo(this.cmpEdit, 12);
        GridData gdCMBType = new GridData(768);
        this.cmbType.setLayoutData((Object)gdCMBType);
        this.cmbType.addSelectionListener((SelectionListener)this);
        Label lblValue = new Label(this.cmpEdit, 0);
        GridData gdLBLValue = new GridData(2);
        gdLBLValue.horizontalIndent = 2;
        lblValue.setLayoutData((Object)gdLBLValue);
        lblValue.setText(Messages.getString("RuleEditorDialog.Lbl.Value"));
        this.txtValue = new Text(this.cmpEdit, 2370);
        GridData gdTXTValue = new GridData(1808);
        this.txtValue.setLayoutData((Object)gdTXTValue);
        RowLayout rlOperations = new RowLayout(256);
        rlOperations.spacing = 5;
        rlOperations.marginBottom = 0;
        rlOperations.marginLeft = 0;
        rlOperations.marginTop = 0;
        rlOperations.marginRight = 0;
        Composite cmpOperations = new Composite(this.cmpEdit, 0);
        GridData gdCMPOperations = new GridData(768);
        gdCMPOperations.horizontalSpan = 2;
        cmpOperations.setLayoutData((Object)gdCMPOperations);
        cmpOperations.setLayout((Layout)rlOperations);
        this.btnRemove = new Button(cmpOperations, 8);
        this.btnRemove.setText(Messages.getString("RuleEditorDialog.Lbl.Remove"));
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.btnAdd = new Button(cmpOperations, 8);
        this.btnAdd.setText(Messages.getString("RuleEditorDialog.Lbl.Add"));
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.btnUpdate = new Button(cmpOperations, 8);
        this.btnUpdate.setText(Messages.getString("RuleEditorDialog.Lbl.Update"));
        this.btnUpdate.addSelectionListener((SelectionListener)this);
        GridLayout glButtons = new GridLayout();
        glButtons.numColumns = 2;
        glButtons.horizontalSpacing = 5;
        this.cmpButtons = new Composite((Composite)this.shell, 0);
        GridData gdCMPButtons = new GridData(768);
        gdCMPButtons.horizontalSpan = 2;
        this.cmpButtons.setLayoutData((Object)gdCMPButtons);
        this.cmpButtons.setLayout((Layout)glButtons);
        this.btnAccept = new Button(this.cmpButtons, 0);
        GridData gdBTNAccept = new GridData(896);
        this.btnAccept.setLayoutData((Object)gdBTNAccept);
        this.btnAccept.setText(Messages.getString("Shared.Lbl.OK"));
        this.btnAccept.addSelectionListener((SelectionListener)this);
        this.btnCancel = new Button(this.cmpButtons, 0);
        GridData gdBTNCancel = new GridData(32);
        this.btnCancel.setLayoutData((Object)gdBTNCancel);
        this.btnCancel.setText(Messages.getString("Shared.Lbl.Cancel"));
        this.btnCancel.addSelectionListener((SelectionListener)this);
        this.populateLists();
    }

    private void populateLists() {
        Object[] oArr = RuleType.VALUES.toArray();
        for (int iR = 0; iR < oArr.length; ++iR) {
            this.cmbType.add(((RuleType)oArr[iR]).getName());
        }
        this.cmbType.select(0);
        this.updateList();
    }

    private void updateList() {
        this.lstRules.removeAll();
        for (int iR = 0; iR < this.vRules.size(); ++iR) {
            this.lstRules.add(this.getTranslatedRule(iR));
        }
    }

    private String getTranslatedRule(int iRuleIndex) {
        if (iRuleIndex > this.vRules.size() - 1) {
            try {
                throw new ChartException("org.eclipse.birt.chart.ui.extension", 20, "RuleEditorDialog.Exception.InvalidRule", Messages.getResourceBundle());
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
                e.printStackTrace();
            }
        }
        Rule rTmp = (Rule)this.vRules.get(iRuleIndex);
        StringBuffer sbRule = new StringBuffer("");
        sbRule.append(rTmp.getType().getName());
        sbRule.append(RULE_SEPARATOR);
        sbRule.append(rTmp.getValue());
        return sbRule.toString();
    }

    public Collection getRules() {
        return this.vRules;
    }

    private Vector getRulesFromQuery(Query query) {
        if (query == null) {
            return new Vector();
        }
        Vector<Object> vTmp = new Vector<Object>();
        Object[] oArr = query.getRules().toArray();
        for (int iR = 0; iR < oArr.length; ++iR) {
            vTmp.add(oArr[iR]);
        }
        return vTmp;
    }

    public boolean wasCancelled() {
        return this.bCancelled;
    }

    public void widgetSelected(SelectionEvent e) {
        Object oSource = e.getSource();
        if (oSource.equals(this.btnAdd)) {
            this.vRules.add(RuleImpl.create((RuleType)RuleType.get((String)this.cmbType.getText()), (String)this.txtValue.getText()));
            this.updateList();
        } else if (oSource.equals(this.btnRemove)) {
            this.vRules.remove(this.lstRules.getSelectionIndex());
            this.updateList();
        } else if (oSource.equals(this.btnUpdate)) {
            this.vRules.set(this.lstRules.getSelectionIndex(), RuleImpl.create((RuleType)RuleType.get((String)this.cmbType.getText()), (String)this.txtValue.getText()));
            this.updateList();
        } else if (oSource.equals(this.lstRules)) {
            Rule r = (Rule)this.vRules.get(this.lstRules.getSelectionIndex());
            this.cmbType.setText(r.getType().getName());
            this.txtValue.setText(r.getValue());
        } else if (oSource.equals(this.cmbType)) {
            this.txtValue.setText("");
        } else if (oSource.equals(this.btnAccept)) {
            this.shell.dispose();
        } else if (oSource.equals(this.btnCancel)) {
            this.bCancelled = true;
            this.shell.dispose();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

