/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.series;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LeaderLineStyle;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.composites.LocalizedNumberEditorComposite;
import org.eclipse.birt.chart.ui.swt.composites.TextEditorComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;

public class PieSeriesAttributeComposite
extends Composite
implements Listener,
ModifyListener,
SelectionListener {
    private transient Group grpLeaderLine = null;
    private transient FillChooserComposite fccSliceOutline = null;
    private transient Combo cmbLeaderLine = null;
    private transient Spinner iscLeaderLength = null;
    private transient LineAttributesComposite liacLeaderLine = null;
    private transient PieSeries series = null;
    private static final int MAX_LEADER_LENGTH = 200;
    private transient ChartWizardContext context;
    private transient TextEditorComposite txtExplode;
    private transient Button btnBuilder;
    private transient Label lblExpSliWhen;
    private transient Label lblExpDistance;
    private transient Label lblRatio;
    private transient Spinner iscExplosion;
    private transient LocalizedNumberEditorComposite txtRatio;
    private static final String TOOLTIP_EXPLODE_SLICE_WHEN = Messages.getString("PieBottomAreaComponent.Label.TheExplosionCondition");
    private static final String TOOLTIP_EXPLOSION_DISTANCE = Messages.getString("PieBottomAreaComponent.Label.TheAmplitudeOfTheExplosion");
    private static final String TOOLTIP_RATIO = Messages.getString("PieBottomAreaComponent.Label.TheRatioOfTheChart");
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.series");

    public PieSeriesAttributeComposite(Composite parent, int style, Series series, ChartWizardContext context) {
        super(parent, style);
        this.context = context;
        if (!(series instanceof PieSeries)) {
            try {
                throw new ChartException("org.eclipse.birt.chart.ui.extension", 20, "PieSeriesAttributeComposite.Exception.IllegalArgument", new Object[]{series.getClass().getName()}, Messages.getResourceBundle());
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
                e.printStackTrace();
            }
        }
        this.series = (PieSeries)series;
        this.init();
        this.placeComponents();
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatPieChartYSeries_ID");
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.marginHeight = 2;
        glContent.marginWidth = 4;
        this.setLayout((Layout)glContent);
        this.grpLeaderLine = new Group((Composite)this, 0);
        GridData gdGRPLeaderLine = new GridData(1808);
        this.grpLeaderLine.setLayoutData((Object)gdGRPLeaderLine);
        GridLayout glLeaderLine = new GridLayout();
        glLeaderLine.numColumns = 2;
        glLeaderLine.marginHeight = 0;
        glLeaderLine.marginWidth = 2;
        this.grpLeaderLine.setLayout((Layout)glLeaderLine);
        this.grpLeaderLine.setText(Messages.getString("PieSeriesAttributeComposite.Lbl.LeaderLine"));
        this.liacLeaderLine = new LineAttributesComposite((Composite)this.grpLeaderLine, 0, this.context, this.series.getLeaderLineAttributes(), true, true, true);
        GridData gdLIACLeaderLine = new GridData(768);
        gdLIACLeaderLine.horizontalSpan = 2;
        this.liacLeaderLine.setLayoutData(gdLIACLeaderLine);
        this.liacLeaderLine.addListener(this);
        Label lblLeaderStyle = new Label((Composite)this.grpLeaderLine, 0);
        GridData gdLBLLeaderStyle = new GridData();
        lblLeaderStyle.setLayoutData((Object)gdLBLLeaderStyle);
        lblLeaderStyle.setText(Messages.getString("PieSeriesAttributeComposite.Lbl.LeaderLineStyle"));
        this.cmbLeaderLine = new Combo((Composite)this.grpLeaderLine, 12);
        GridData gdCMBLeaderLine = new GridData(768);
        this.cmbLeaderLine.setLayoutData((Object)gdCMBLeaderLine);
        this.cmbLeaderLine.addSelectionListener((SelectionListener)this);
        Label lblLeaderSize = new Label((Composite)this.grpLeaderLine, 0);
        GridData gdLBLLeaderSize = new GridData();
        lblLeaderSize.setLayoutData((Object)gdLBLLeaderSize);
        lblLeaderSize.setText(Messages.getString("PieSeriesAttributeComposite.Lbl.LeaderLineSize"));
        this.iscLeaderLength = new Spinner((Composite)this.grpLeaderLine, 2048);
        GridData gdISCLeaderLength = new GridData(768);
        this.iscLeaderLength.setLayoutData((Object)gdISCLeaderLength);
        this.iscLeaderLength.setMinimum(0);
        this.iscLeaderLength.setMaximum(200);
        this.iscLeaderLength.setSelection((int)this.series.getLeaderLineLength());
        this.iscLeaderLength.addSelectionListener((SelectionListener)this);
        Composite cmpRight = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        cmpRight.setLayout((Layout)gridLayout);
        cmpRight.setLayoutData((Object)new GridData(1808));
        this.createSeriesDetail(cmpRight);
        this.populateLists();
    }

    private void createSeriesDetail(Composite cmpBottomBindingArea) {
        Label lblSliceOutline = new Label(cmpBottomBindingArea, 0);
        GridData gdLBLSliceOutline = new GridData();
        lblSliceOutline.setLayoutData((Object)gdLBLSliceOutline);
        lblSliceOutline.setText(Messages.getString("PieSeriesAttributeComposite.Lbl.SliceOutline"));
        this.fccSliceOutline = new FillChooserComposite(cmpBottomBindingArea, 0, this.context, (Fill)this.series.getSliceOutline(), false, false);
        GridData gdFCCSliceOutline = new GridData(768);
        gdFCCSliceOutline.horizontalSpan = 2;
        this.fccSliceOutline.setLayoutData(gdFCCSliceOutline);
        this.fccSliceOutline.addListener(this);
        this.lblExpSliWhen = new Label(cmpBottomBindingArea, 0);
        this.lblExpSliWhen.setText(Messages.getString("PieBottomAreaComponent.Label.ExplodeSliceWhen"));
        this.lblExpSliWhen.setToolTipText(TOOLTIP_EXPLODE_SLICE_WHEN);
        this.txtExplode = new TextEditorComposite(cmpBottomBindingArea, 2052);
        GridData gd = new GridData(768);
        this.txtExplode.setLayoutData(gd);
        if (this.series.getExplosionExpression() != null) {
            this.txtExplode.setText(this.series.getExplosionExpression());
        }
        this.txtExplode.setToolTipText(Messages.getString("PieBaseSeriesComponent.Tooltip.EnterBooleanExpression"));
        this.txtExplode.addListener(this);
        this.btnBuilder = new Button(cmpBottomBindingArea, 8);
        GridData gdBTNBuilder = new GridData();
        gdBTNBuilder.heightHint = 20;
        gdBTNBuilder.widthHint = 20;
        this.btnBuilder.setLayoutData((Object)gdBTNBuilder);
        this.btnBuilder.setImage(UIHelper.getImage((String)"icons/obj16/expressionbuilder.gif"));
        this.btnBuilder.addSelectionListener((SelectionListener)this);
        this.btnBuilder.setToolTipText(Messages.getString("DataDefinitionComposite.Tooltip.InvokeExpressionBuilder"));
        this.btnBuilder.getImage().setBackground(this.btnBuilder.getBackground());
        if (this.context.getUIServiceProvider() == null) {
            this.btnBuilder.setEnabled(false);
        }
        this.lblExpDistance = new Label(cmpBottomBindingArea, 0);
        this.lblExpDistance.setText(Messages.getString("PieBottomAreaComponent.Label.ByDistance"));
        this.lblExpDistance.setToolTipText(TOOLTIP_EXPLOSION_DISTANCE);
        this.iscExplosion = new Spinner(cmpBottomBindingArea, 2048);
        GridData gdISCExplosion = new GridData(768);
        gdISCExplosion.horizontalSpan = 2;
        this.iscExplosion.setLayoutData((Object)gdISCExplosion);
        this.iscExplosion.setMinimum(0);
        this.iscExplosion.setMaximum(100);
        this.iscExplosion.setSelection(this.series.getExplosion());
        this.iscExplosion.addSelectionListener((SelectionListener)this);
        this.lblRatio = new Label(cmpBottomBindingArea, 0);
        this.lblRatio.setText(Messages.getString("PieBottomAreaComponent.Label.Ratio"));
        this.lblRatio.setToolTipText(TOOLTIP_RATIO);
        this.txtRatio = new LocalizedNumberEditorComposite(cmpBottomBindingArea, 2048);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.txtRatio.setLayoutData(gridData);
        this.txtRatio.setToolTipText(TOOLTIP_RATIO);
        this.txtRatio.setValue(this.series.getRatio());
        this.txtRatio.addModifyListener(this);
    }

    private void populateLists() {
        NameSet ns = LiteralHelper.leaderLineStyleSet;
        this.cmbLeaderLine.setItems(ns.getDisplayNames());
        this.cmbLeaderLine.select(ns.getSafeNameIndex(this.series.getLeaderLineStyle().getName()));
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget.equals((Object)this.txtRatio)) {
            this.series.setRatio(this.txtRatio.getValue());
        }
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.fccSliceOutline)) {
            this.series.setSliceOutline((ColorDefinition)event.data);
        } else if (event.widget.equals((Object)this.liacLeaderLine)) {
            switch (event.type) {
                case 4: {
                    this.series.getLeaderLineAttributes().setVisible(((Boolean)event.data).booleanValue());
                    break;
                }
                case 1: {
                    this.series.getLeaderLineAttributes().setStyle((LineStyle)event.data);
                    break;
                }
                case 2: {
                    this.series.getLeaderLineAttributes().setThickness(((Integer)event.data).intValue());
                    break;
                }
                case 3: {
                    this.series.getLeaderLineAttributes().setColor((ColorDefinition)event.data);
                }
            }
        } else if (event.widget.equals((Object)this.txtExplode)) {
            this.series.setExplosionExpression(this.txtExplode.getText());
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.iscExplosion)) {
            this.series.setExplosion(this.iscExplosion.getSelection());
        } else if (e.getSource().equals(this.iscLeaderLength)) {
            this.series.setLeaderLineLength((double)this.iscLeaderLength.getSelection());
        } else if (e.getSource().equals(this.cmbLeaderLine)) {
            this.series.setLeaderLineStyle(LeaderLineStyle.getByName((String)LiteralHelper.leaderLineStyleSet.getNameByDisplayName(this.cmbLeaderLine.getText())));
        } else if (e.widget.equals(this.btnBuilder)) {
            try {
                String sExpr = this.context.getUIServiceProvider().invoke(2, this.txtExplode.getText(), this.context.getExtendedItem(), Messages.getString("PieBaseSeriesComponent.Text.SpecifyExplodeSlice"));
                this.txtExplode.setText(sExpr);
                this.txtExplode.setToolTipText(sExpr);
                this.series.setExplosionExpression(sExpr);
            }
            catch (ChartException e1) {
                WizardBase.displayException((Throwable)e1);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

