/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.series;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;

public class StockSeriesAttributeComposite
extends Composite
implements Listener,
SelectionListener {
    private LineAttributesComposite liacStock = null;
    private Spinner iscStick = null;
    private StockSeries series = null;
    private transient ChartWizardContext context;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.series");

    public StockSeriesAttributeComposite(Composite parent, int style, ChartWizardContext context, Series series) {
        super(parent, style);
        if (!(series instanceof StockSeries)) {
            try {
                throw new ChartException("org.eclipse.birt.chart.ui.extension", 20, "StockSeriesAttributeComposite.Exception.IllegalArgument", new Object[]{series.getClass().getName()}, Messages.getResourceBundle());
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
                e.printStackTrace();
            }
        }
        this.series = (StockSeries)series;
        this.context = context;
        this.init();
        this.placeComponents();
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatStockChartYSeries_ID");
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = this.series.isShowAsBarStick() ? 3 : 1;
        this.setLayout((Layout)glContent);
        this.liacStock = new LineAttributesComposite(this, 0, this.context, this.series.getLineAttributes(), true, true, false);
        GridData gdLIACStock = new GridData(768);
        gdLIACStock.verticalSpan = 3;
        this.liacStock.setLayoutData(gdLIACStock);
        this.liacStock.addListener(this);
        if (this.series.isShowAsBarStick()) {
            new Label((Composite)this, 0).setText(Messages.getString("StockSeriesAttributeComposite.Lbl.StickLength"));
            this.iscStick = new Spinner((Composite)this, 2048);
            this.iscStick.setLayoutData((Object)new GridData(768));
            this.iscStick.setMinimum(0);
            this.iscStick.setMaximum(Integer.MAX_VALUE);
            this.iscStick.setSelection(this.series.getStickLength());
            this.iscStick.addSelectionListener((SelectionListener)this);
        }
    }

    public Point getPreferredSize() {
        return new Point(400, 200);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget.equals(this.iscStick)) {
            this.series.setStickLength(this.iscStick.getSelection());
        }
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.liacStock)) {
            if (event.type == 4) {
                this.series.getLineAttributes().setVisible(((Boolean)event.data).booleanValue());
            } else if (event.type == 1) {
                this.series.getLineAttributes().setStyle((LineStyle)event.data);
            } else if (event.type == 2) {
                this.series.getLineAttributes().setThickness(((Integer)event.data).intValue());
            } else if (event.type == 3) {
                this.series.getLineAttributes().setColor((ColorDefinition)event.data);
            }
        }
    }
}

