/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskChangeListener;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.SelectDataDynamicArea;
import org.eclipse.birt.chart.ui.swt.wizard.internal.ChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.wizard.internal.ColorPalette;
import org.eclipse.birt.chart.ui.swt.wizard.internal.CustomPreviewTable;
import org.eclipse.birt.chart.ui.swt.wizard.internal.DataDefinitionTextManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.core.ui.frameworks.taskwizard.SimpleTask;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ITask;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class TaskSelectData
extends SimpleTask
implements SelectionListener,
ITaskChangeListener,
Listener {
    private static final int CENTER_WIDTH_HINT = 400;
    private transient ChartPreviewPainter previewPainter = null;
    private transient Composite cmpPreview = null;
    private transient Canvas previewCanvas = null;
    private transient Button btnUseReportData = null;
    private transient Button btnUseDataSet = null;
    private transient Combo cmbDataSet = null;
    private transient Button btnNewData = null;
    private transient CustomPreviewTable tablePreview = null;
    private transient Button btnFilters = null;
    private transient Button btnParameters = null;
    private transient Button btnBinding = null;
    private transient SelectDataDynamicArea dynamicArea;
    private transient String BLANK_DATASET = "";

    public TaskSelectData() {
        super(Messages.getString("TaskSelectData.TaskExp"));
        this.setDescription(Messages.getString("TaskSelectData.Task.Description"));
    }

    public void createControl(Composite parent) {
        if (this.topControl == null || this.topControl.isDisposed()) {
            this.topControl = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(3, false);
            gridLayout.marginWidth = 10;
            gridLayout.marginHeight = 10;
            this.topControl.setLayout((Layout)gridLayout);
            this.topControl.setLayoutData((Object)new GridData(1536));
            this.dynamicArea = new SelectDataDynamicArea((ITask)this);
            this.getCustomizeUI().init();
            this.placeComponents();
            this.createPreviewPainter();
            this.init();
        } else {
            this.customizeUI();
        }
        this.doLivePreview();
        DataDefinitionTextManager.getInstance().refreshAll();
        ChartUIUtil.bindHelp((Control)this.getControl(), (String)"org.eclipse.birt.chart.cshelp.SelectChartData_ID");
    }

    protected void customizeUI() {
        this.getCustomizeUI().init();
        this.refreshLeftArea();
        this.refreshRightArea();
        this.refreshBottomArea();
        this.getCustomizeUI().layoutAll();
    }

    private void refreshLeftArea() {
        this.getCustomizeUI().refreshLeftBindingArea();
        this.getCustomizeUI().selectLeftBindingArea(true, null);
    }

    private void refreshRightArea() {
        this.getCustomizeUI().refreshRightBindingArea();
        this.getCustomizeUI().selectRightBindingArea(true, null);
    }

    private void refreshBottomArea() {
        this.getCustomizeUI().refreshBottomBindingArea();
        this.getCustomizeUI().selectBottomBindingArea(true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void placeComponents() {
        ChartAdapter.ignoreNotifications((boolean)true);
        try {
            this.createHeadArea();
            new Label(this.topControl, 0);
            this.createDataSetArea(this.topControl);
            new Label(this.topControl, 0);
            new Label(this.topControl, 0);
            this.createDataPreviewTableArea(this.topControl);
            this.createDataPreviewButtonArea(this.topControl);
            new Label(this.topControl, 0);
            Label description = new Label(this.topControl, 64);
            GridData gd = new GridData();
            gd.widthHint = 400;
            description.setLayoutData((Object)gd);
            description.setText(Messages.getString("TaskSelectData.Label.ToBindADataColumn"));
            new Label(this.topControl, 0);
        }
        finally {
            ChartAdapter.ignoreNotifications((boolean)false);
        }
    }

    private void createHeadArea() {
        Composite cmpLeftContainer = ChartUIUtil.createCompositeWrapper((Composite)this.topControl);
        GridData gridData = new GridData(772);
        gridData.verticalSpan = 2;
        cmpLeftContainer.setLayoutData((Object)gridData);
        this.getCustomizeUI().createLeftBindingArea(cmpLeftContainer);
        this.createPreviewArea();
        Composite cmpRightContainer = ChartUIUtil.createCompositeWrapper((Composite)this.topControl);
        gridData = new GridData(772);
        gridData.verticalSpan = 2;
        cmpRightContainer.setLayoutData((Object)gridData);
        this.getCustomizeUI().createRightBindingArea(cmpRightContainer);
        Composite cmpBottomContainer = ChartUIUtil.createCompositeWrapper((Composite)this.topControl);
        gridData = new GridData(770);
        cmpBottomContainer.setLayoutData((Object)gridData);
        this.getCustomizeUI().createBottomBindingArea(cmpBottomContainer);
    }

    private void createPreviewArea() {
        this.cmpPreview = ChartUIUtil.createCompositeWrapper((Composite)this.topControl);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 400;
        gridData.heightHint = 200;
        this.cmpPreview.setLayoutData((Object)gridData);
        Label label = new Label(this.cmpPreview, 0);
        label.setFont(JFaceResources.getBannerFont());
        label.setText(Messages.getString("TaskSelectData.Label.ChartPreview"));
        this.previewCanvas = new Canvas(this.cmpPreview, 2048);
        GridData gd = new GridData(1808);
        this.previewCanvas.setLayoutData((Object)gd);
        this.previewCanvas.setBackground(Display.getDefault().getSystemColor(1));
    }

    private void createDataSetArea(Composite parent) {
        Composite cmpDataSet = ChartUIUtil.createCompositeWrapper((Composite)parent);
        cmpDataSet.setLayoutData((Object)new GridData(768));
        Label label = new Label(cmpDataSet, 0);
        label.setText(Messages.getString("TaskSelectData.Label.SelectDataSet"));
        label.setFont(JFaceResources.getBannerFont());
        Composite cmpDetail = new Composite(cmpDataSet, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 0;
        cmpDetail.setLayout((Layout)gridLayout);
        cmpDetail.setLayoutData((Object)new GridData(768));
        Composite comp = ChartUIUtil.createCompositeWrapper((Composite)cmpDetail);
        this.btnUseReportData = new Button(comp, 16);
        this.btnUseReportData.setText(Messages.getString("TaskSelectData.Label.UseReportData"));
        this.btnUseReportData.addSelectionListener((SelectionListener)this);
        this.btnUseDataSet = new Button(comp, 16);
        this.btnUseDataSet.setText(Messages.getString("TaskSelectData.Label.UseDataSet"));
        this.btnUseDataSet.addSelectionListener((SelectionListener)this);
        this.cmbDataSet = new Combo(cmpDetail, 12);
        this.cmbDataSet.setLayoutData((Object)new GridData(776));
        this.cmbDataSet.addSelectionListener((SelectionListener)this);
        this.btnNewData = new Button(cmpDetail, 0);
        this.btnNewData.setLayoutData((Object)new GridData(8));
        this.btnNewData.setText(Messages.getString("TaskSelectData.Label.CreateNew"));
        this.btnNewData.setToolTipText(Messages.getString("TaskSelectData.Tooltip.CreateNewDataset"));
        this.btnNewData.addSelectionListener((SelectionListener)this);
    }

    private void createDataPreviewTableArea(Composite parent) {
        Composite composite = ChartUIUtil.createCompositeWrapper((Composite)parent);
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("TaskSelectData.Label.DataPreview"));
        label.setFont(JFaceResources.getBannerFont());
        this.tablePreview = new CustomPreviewTable(composite, 66308);
        GridData gridData = new GridData(768);
        gridData.widthHint = 400;
        gridData.heightHint = 150;
        this.tablePreview.setLayoutData(gridData);
        this.tablePreview.setHeaderAlignment(16384);
        this.tablePreview.addListener(0, this);
        this.dynamicArea.setCustomPreviewTable(this.tablePreview);
    }

    private void createDataPreviewButtonArea(Composite parent) {
        Composite composite = ChartUIUtil.createCompositeWrapper((Composite)parent);
        composite.setLayoutData((Object)new GridData(8));
        this.btnFilters = new Button(composite, 0);
        this.btnFilters.setAlignment(0x1000000);
        GridData gridData = new GridData(768);
        this.btnFilters.setLayoutData((Object)gridData);
        this.btnFilters.setText(Messages.getString("TaskSelectData.Label.Filters"));
        this.btnFilters.addSelectionListener((SelectionListener)this);
        this.btnParameters = new Button(composite, 0);
        this.btnParameters.setAlignment(0x1000000);
        gridData = new GridData(768);
        this.btnParameters.setLayoutData((Object)gridData);
        this.btnParameters.setText(Messages.getString("TaskSelectData.Label.Parameters"));
        this.btnParameters.addSelectionListener((SelectionListener)this);
        this.btnBinding = new Button(composite, 0);
        this.btnBinding.setAlignment(0x1000000);
        gridData = new GridData(768);
        this.btnBinding.setLayoutData((Object)gridData);
        this.btnBinding.setText(Messages.getString("TaskSelectData.Label.DataBinding"));
        this.btnBinding.addSelectionListener((SelectionListener)this);
    }

    protected void init() {
        String currentDataSet = this.getDataServiceProvider().getBoundDataSet();
        if (currentDataSet != null) {
            this.cmbDataSet.setItems(this.getDataServiceProvider().getAllDataSets());
            this.cmbDataSet.setText(currentDataSet == null ? this.BLANK_DATASET : currentDataSet);
            this.useReportDataSet(false);
            if (currentDataSet != null) {
                this.switchDataTable();
            }
        } else {
            this.useReportDataSet(true);
            String reportDataSet = this.getDataServiceProvider().getReportDataSet();
            if (reportDataSet != null) {
                this.switchDataTable();
            }
        }
        this.btnFilters.setEnabled(this.hasDataSet() && this.getDataServiceProvider().isInvokingSupported());
        this.btnParameters.setEnabled(this.hasDataSet() && this.getDataServiceProvider().isInvokingSupported());
        this.btnBinding.setEnabled(this.hasDataSet() && this.getDataServiceProvider().isInvokingSupported());
    }

    private void useReportDataSet(boolean bDS) {
        this.btnUseReportData.setSelection(bDS);
        this.btnUseDataSet.setSelection(!bDS);
        this.cmbDataSet.setEnabled(!bDS);
        this.btnNewData.setEnabled(!bDS && this.getDataServiceProvider().isInvokingSupported());
        if (bDS) {
            this.getDataServiceProvider().setDataSet(null);
        }
    }

    private void refreshTableColor() {
        for (int i = 0; i < this.tablePreview.getColumnNumber(); ++i) {
            this.tablePreview.setColumnColor(i, ColorPalette.getInstance().getColor(ChartUIUtil.getExpressionString((String)this.tablePreview.getColumnHeading(i))));
        }
    }

    private void switchDataTable() {
        try {
            String[] header = this.getDataServiceProvider().getPreviewHeader();
            if (header == null) {
                this.tablePreview.setEnabled(false);
                this.tablePreview.createDummyTable();
            } else {
                this.tablePreview.setEnabled(true);
                this.tablePreview.setColumns(header);
                this.refreshTableColor();
                List dataList = this.getDataServiceProvider().getPreviewData();
                Iterator iterator = dataList.iterator();
                while (iterator.hasNext()) {
                    String[] dataRow = (String[])iterator.next();
                    for (int i = 0; i < dataRow.length; ++i) {
                        this.tablePreview.addEntry(dataRow[i], i);
                    }
                }
            }
        }
        catch (ChartException e) {
            ChartWizard.displayException((Throwable)e);
        }
    }

    private void createPreviewPainter() {
        this.previewPainter = new ChartPreviewPainter((ChartWizardContext)this.getContext());
        this.previewCanvas.addPaintListener((PaintListener)this.previewPainter);
        this.previewCanvas.addControlListener((ControlListener)this.previewPainter);
        this.previewPainter.setPreview(this.previewCanvas);
    }

    protected Chart getChartModel() {
        if (this.getContext() == null) {
            return null;
        }
        return ((ChartWizardContext)this.getContext()).getModel();
    }

    private int switchDataSet(String datasetName) throws ChartException {
        int bCancel = 0;
        if (this.getDataServiceProvider().getBoundDataSet() != null && this.getDataServiceProvider().getBoundDataSet().equals(datasetName)) {
            return bCancel;
        }
        try {
            this.getDataServiceProvider().setDataSet(datasetName);
            this.tablePreview.clearContents();
            if (datasetName == null) {
                datasetName = this.getDataServiceProvider().getReportDataSet();
            }
            if (datasetName != null) {
                this.switchDataTable();
            } else {
                this.tablePreview.createDummyTable();
            }
            this.tablePreview.layout();
        }
        catch (Throwable t) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, t);
        }
        DataDefinitionTextManager.getInstance().refreshAll();
        this.doLivePreview();
        return bCancel;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.btnUseReportData)) {
            if (!this.btnUseReportData.getSelection()) {
                return;
            }
            try {
                this.switchDataSet(null);
            }
            catch (ChartException e1) {
                ChartWizard.displayException((Throwable)e1);
            }
            this.cmbDataSet.add(this.BLANK_DATASET, 0);
            this.cmbDataSet.select(0);
            this.cmbDataSet.setEnabled(false);
            this.btnNewData.setEnabled(false);
            this.btnFilters.setEnabled(this.hasDataSet() && this.getDataServiceProvider().isInvokingSupported());
            this.btnParameters.setEnabled(this.hasDataSet() && this.getDataServiceProvider().isInvokingSupported());
            this.btnBinding.setEnabled(this.hasDataSet() && this.getDataServiceProvider().isInvokingSupported());
        } else if (e.getSource().equals(this.btnUseDataSet)) {
            if (!this.btnUseDataSet.getSelection()) {
                return;
            }
            this.cmbDataSet.removeAll();
            this.cmbDataSet.add(this.BLANK_DATASET, 0);
            String[] dataSets = this.getDataServiceProvider().getAllDataSets();
            if (dataSets != null) {
                for (int i = 0; i < dataSets.length; ++i) {
                    this.cmbDataSet.add(dataSets[i], i + 1);
                }
            }
            this.cmbDataSet.select(0);
            this.cmbDataSet.setEnabled(true);
            this.btnNewData.setEnabled(this.getDataServiceProvider().isInvokingSupported());
        } else if (e.getSource().equals(this.cmbDataSet)) {
            try {
                ColorPalette.getInstance().restore();
                if (!this.cmbDataSet.getText().equals(this.BLANK_DATASET)) {
                    int bCancel = this.switchDataSet(this.cmbDataSet.getText());
                    if (bCancel == 0 && this.cmbDataSet.getItem(0).equals(this.BLANK_DATASET)) {
                        this.cmbDataSet.remove(this.BLANK_DATASET);
                    } else if (bCancel == 1) {
                        String[] datasetNames = this.cmbDataSet.getItems();
                        for (int i = 0; i < datasetNames.length; ++i) {
                            if (!datasetNames[i].equals(this.getDataServiceProvider().getBoundDataSet())) continue;
                            this.cmbDataSet.select(i);
                            if (this.cmbDataSet.getItem(0).equals(this.BLANK_DATASET)) {
                                this.cmbDataSet.remove(this.BLANK_DATASET);
                            }
                            return;
                        }
                        this.cmbDataSet.select(0);
                    }
                }
            }
            catch (ChartException e1) {
                ChartWizard.displayException((Throwable)e1);
            }
            this.btnNewData.setEnabled(this.getDataServiceProvider().isInvokingSupported());
            this.btnFilters.setEnabled(this.hasDataSet() && this.getDataServiceProvider().isInvokingSupported());
            this.btnParameters.setEnabled(this.hasDataSet() && this.getDataServiceProvider().isInvokingSupported());
            this.btnBinding.setEnabled(this.hasDataSet() && this.getDataServiceProvider().isInvokingSupported());
        } else if (e.getSource().equals(this.btnNewData)) {
            int result = this.getDataServiceProvider().invoke(0);
            if (result == 1) {
                return;
            }
            String[] sAllDS = this.getDataServiceProvider().getAllDataSets();
            String currentDataSet = this.cmbDataSet.getText();
            int dataSetCount = this.cmbDataSet.getItemCount();
            if (currentDataSet.equals(this.BLANK_DATASET)) {
                --dataSetCount;
            }
            if (sAllDS.length == dataSetCount) {
                return;
            }
            if (currentDataSet.equals(this.BLANK_DATASET)) {
                this.cmbDataSet.removeAll();
                this.cmbDataSet.add(this.BLANK_DATASET, 0);
                for (int i = 0; i < sAllDS.length; ++i) {
                    this.cmbDataSet.add(sAllDS[i], i + 1);
                }
            } else {
                this.cmbDataSet.setItems(sAllDS);
            }
            this.cmbDataSet.setText(currentDataSet);
        } else if (e.getSource().equals(this.btnFilters)) {
            if (this.getDataServiceProvider().invoke(1) == 0) {
                this.refreshTablePreview();
                this.doLivePreview();
            }
        } else if (e.getSource().equals(this.btnParameters)) {
            if (this.getDataServiceProvider().invoke(2) == 0) {
                this.refreshTablePreview();
                this.doLivePreview();
            }
        } else if (e.getSource().equals(this.btnBinding)) {
            if (this.getDataServiceProvider().invoke(3) == 0) {
                this.refreshTablePreview();
                this.doLivePreview();
            }
        } else if (e.getSource() instanceof MenuItem) {
            IAction action;
            MenuItem item = (MenuItem)e.getSource();
            action.setChecked(!(action = (IAction)item.getData()).isChecked());
            action.run();
        }
    }

    private void refreshTablePreview() {
        this.tablePreview.clearContents();
        if (this.cmbDataSet.getText() != null) {
            this.switchDataTable();
        }
        this.tablePreview.layout();
    }

    protected IDataServiceProvider getDataServiceProvider() {
        return ((ChartWizardContext)this.getContext()).getDataServiceProvider();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private boolean hasDataSet() {
        return this.getDataServiceProvider().getReportDataSet() != null || this.getDataServiceProvider().getBoundDataSet() != null;
    }

    public void dispose() {
        super.dispose();
        if (this.previewPainter != null) {
            this.previewPainter.dispose();
        }
        this.previewPainter = null;
        if (this.dynamicArea != null) {
            this.dynamicArea.dispose();
        }
        this.dynamicArea = null;
        ColorPalette.getInstance().restore();
        DataDefinitionTextManager.getInstance().removeAll();
    }

    private ISelectDataCustomizeUI getCustomizeUI() {
        return this.dynamicArea;
    }

    public void handleEvent(Event event) {
        if (event.type == 0 && (this.getDataServiceProvider().getBoundDataSet() != null || this.getDataServiceProvider().getReportDataSet() != null)) {
            MenuManager menuManager = new MenuManager();
            menuManager.setRemoveAllWhenShown(true);
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    this.addMenu(manager, (Object)new HeaderShowAction());
                    this.addMenu(manager, TaskSelectData.this.getBaseSeriesMenu(TaskSelectData.this.getChartModel()));
                    this.addMenu(manager, TaskSelectData.this.getOrthogonalSeriesMenu(TaskSelectData.this.getChartModel()));
                    this.addMenu(manager, TaskSelectData.this.getGroupSeriesMenu(TaskSelectData.this.getChartModel()));
                }

                private void addMenu(IMenuManager manager, Object item) {
                    if (item instanceof IAction) {
                        manager.add((IAction)item);
                    } else if (item instanceof IContributionItem) {
                        manager.add((IContributionItem)item);
                    }
                }
            });
            Menu menu = menuManager.createContextMenu((Control)this.tablePreview);
            menu.setVisible(true);
        }
    }

    private Object getBaseSeriesMenu(Chart chart) {
        EList sds = ChartUIUtil.getBaseSeriesDefinitions((Chart)chart);
        if (sds.size() == 1) {
            return new CategoryXAxisAction();
        }
        return null;
    }

    private Object getOrthogonalSeriesMenu(Chart chart) {
        MenuManager topManager = new MenuManager(this.getOrthogonalSeriesTitle(this.getChartModel()));
        int axisNum = ChartUIUtil.getOrthogonalAxisNumber((Chart)chart);
        for (int axisIndex = 0; axisIndex < axisNum; ++axisIndex) {
            EList sds = ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)chart, (int)axisIndex);
            for (int i = 0; i < sds.size(); ++i) {
                Series series = ((SeriesDefinition)sds.get(i)).getDesignTimeSeries();
                EList dataDefns = series.getDataDefinition();
                if (series instanceof StockSeries) {
                    MenuManager secondManager = new MenuManager(this.getSecondMenuText(axisIndex, i, series));
                    topManager.add((IContributionItem)secondManager);
                    for (int j = 0; j < dataDefns.size(); ++j) {
                        ValueYSeriesAction action = new ValueYSeriesAction((Query)dataDefns.get(j));
                        action.setText(ChartUIUtil.getStockTitle((int)j) + Messages.getString("TaskSelectData.Label.Component"));
                        secondManager.add((IAction)action);
                    }
                    continue;
                }
                ValueYSeriesAction action = new ValueYSeriesAction((Query)dataDefns.get(0));
                if (axisNum == 1 && sds.size() == 1) {
                    return action;
                }
                action.setText(this.getSecondMenuText(axisIndex, i, series));
                topManager.add((IAction)action);
            }
        }
        return topManager;
    }

    private Object getGroupSeriesMenu(Chart chart) {
        MenuManager topManager = new MenuManager(this.getGroupSeriesTitle(this.getChartModel()));
        int axisNum = ChartUIUtil.getOrthogonalAxisNumber((Chart)chart);
        for (int axisIndex = 0; axisIndex < axisNum; ++axisIndex) {
            int i = 0;
            EList sds = ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)chart, (int)axisIndex);
            if (i >= sds.size()) continue;
            SeriesDefinition sd = (SeriesDefinition)sds.get(i);
            GroupYSeriesAction action = new GroupYSeriesAction(sd.getQuery());
            return action;
        }
        return topManager;
    }

    private String getSecondMenuText(int axisIndex, int seriesIndex, Series series) {
        StringBuffer sb = new StringBuffer();
        if (ChartUIUtil.getOrthogonalAxisNumber((Chart)this.getChartModel()) > 2) {
            sb.append(Messages.getString("DataDefinitionSelector.Label.Axis"));
            sb.append(axisIndex + 1);
            sb.append(" - ");
        } else if (axisIndex > 0) {
            sb.append(Messages.getString("TaskSelectData.Label.Overlay"));
        }
        sb.append(Messages.getString("TaskSelectData.Label.Series") + (seriesIndex + 1) + " (" + series.getDisplayName() + ")");
        return sb.toString();
    }

    private String getBaseSeriesTitle(Chart chart) {
        if (chart instanceof ChartWithAxes) {
            return Messages.getString("TaskSelectData.Label.UseAsCategoryXAxis");
        }
        return Messages.getString("TaskSelectData.Label.UseAsCategorySeries");
    }

    private String getOrthogonalSeriesTitle(Chart chart) {
        if (chart instanceof ChartWithAxes) {
            return Messages.getString("TaskSelectData.Label.PlotAsValueYSeries");
        }
        if (chart instanceof DialChart) {
            return Messages.getString("TaskSelectData.Label.PlotAsGaugeValue");
        }
        return Messages.getString("TaskSelectData.Label.PlotAsValueSeries");
    }

    private String getGroupSeriesTitle(Chart chart) {
        if (chart instanceof ChartWithAxes) {
            return Messages.getString("TaskSelectData.Label.UseToGroupYSeries");
        }
        return Messages.getString("TaskSelectData.Label.UseToGroupValueSeries");
    }

    public void changeTask(Notification notification) {
        if (this.previewPainter != null) {
            if (notification.getNotifier() instanceof Query || notification.getNotifier() instanceof Axis || notification.getNotifier() instanceof SeriesDefinition) {
                this.doLivePreview();
            } else if (ChartPreviewPainter.isLivePreviewActive()) {
                ChartAdapter.ignoreNotifications((boolean)true);
                ChartUIUtil.syncRuntimeSeries((Chart)this.getChartModel());
                ChartAdapter.ignoreNotifications((boolean)false);
                this.previewPainter.renderModel(this.getChartModel());
            } else {
                this.previewPainter.renderModel(this.getChartModel());
            }
        }
    }

    private void manageColorAndQuery(Query query) {
        if (DataDefinitionTextManager.getInstance().getNumberOfSameDataDefinition(query.getDefinition()) == 1) {
            ColorPalette.getInstance().retrieveColor(query.getDefinition());
        }
        query.setDefinition(ChartUIUtil.getExpressionString((String)this.tablePreview.getCurrentColumnHeading()));
        ColorPalette.getInstance().putColor(query.getDefinition());
        this.refreshTableColor();
    }

    private void doLivePreview() {
        if (this.getDataServiceProvider().isLivePreviewEnabled() && ChartUIUtil.checkDataBinding((Chart)this.getChartModel()) && this.hasDataSet()) {
            ChartPreviewPainter.activateLivePreview(true);
            ChartAdapter.ignoreNotifications((boolean)true);
            try {
                ChartUIUtil.doLivePreview((Chart)this.getChartModel(), (IDataServiceProvider)this.getDataServiceProvider());
            }
            catch (Exception e) {
                ChartPreviewPainter.activateLivePreview(false);
            }
            ChartAdapter.ignoreNotifications((boolean)false);
        } else {
            ChartPreviewPainter.activateLivePreview(false);
        }
        this.previewPainter.renderModel(this.getChartModel());
    }

    class HeaderShowAction
    extends Action {
        HeaderShowAction() {
            super(TaskSelectData.this.tablePreview.getCurrentColumnHeading());
            this.setEnabled(false);
        }
    }

    class ValueYSeriesAction
    extends Action {
        Query query;

        ValueYSeriesAction(Query query) {
            super(TaskSelectData.this.getOrthogonalSeriesTitle(TaskSelectData.this.getChartModel()));
            this.query = query;
        }

        public void run() {
            TaskSelectData.this.manageColorAndQuery(this.query);
            TaskSelectData.this.refreshLeftArea();
            DataDefinitionTextManager.getInstance().refreshAll();
        }
    }

    class GroupYSeriesAction
    extends Action {
        Query query;

        GroupYSeriesAction(Query query) {
            super(TaskSelectData.this.getGroupSeriesTitle(TaskSelectData.this.getChartModel()));
            this.query = query;
        }

        public void run() {
            ChartAdapter.ignoreNotifications((boolean)true);
            ChartUIUtil.setAllGroupingQueryExceptFirst((Chart)TaskSelectData.this.getChartModel(), (String)ChartUIUtil.getExpressionString((String)TaskSelectData.this.tablePreview.getCurrentColumnHeading()));
            ChartAdapter.ignoreNotifications((boolean)false);
            TaskSelectData.this.manageColorAndQuery(this.query);
            TaskSelectData.this.refreshRightArea();
            DataDefinitionTextManager.getInstance().refreshAll();
        }
    }

    class CategoryXAxisAction
    extends Action {
        CategoryXAxisAction() {
            super(TaskSelectData.this.getBaseSeriesTitle(TaskSelectData.this.getChartModel()));
        }

        public void run() {
            Query query = (Query)((SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)TaskSelectData.this.getChartModel()).get(0)).getDesignTimeSeries().getDataDefinition().get(0);
            TaskSelectData.this.manageColorAndQuery(query);
            TaskSelectData.this.refreshBottomArea();
            DataDefinitionTextManager.getInstance().refreshAll();
        }
    }
}

