/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.DefaultSelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.IChangeWithoutNotification;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.BaseDataDefinitionComponent;
import org.eclipse.birt.chart.ui.swt.wizard.internal.ColorPalette;
import org.eclipse.birt.chart.ui.swt.wizard.internal.CustomPreviewTable;
import org.eclipse.birt.chart.ui.swt.wizard.internal.DataDefinitionTextManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DataDefinitionSelector
extends DefaultSelectDataComponent
implements SelectionListener {
    private transient EList seriesDefns = null;
    private transient ChartWizardContext wizardContext = null;
    private transient String sTitle = null;
    private transient Composite cmpTop = null;
    private transient Composite cmpData = null;
    private transient ISelectDataComponent dateComponent = null;
    private transient Button btnAxisDelete;
    private transient Combo cmbAxisSelect;
    private transient Button btnSeriesDelete;
    private transient Combo cmbSeriesSelect;
    private transient int axisIndex;
    private transient String selectionName = Messages.getString("DataDefinitionSelector.Label.Series");
    private transient String description = "";
    private transient int areaType = 1;
    private transient ISelectDataCustomizeUI selectDataUI = null;

    public DataDefinitionSelector(int axisIndex, EList seriesDefns, ChartWizardContext wizardContext, String sTitle, ISelectDataCustomizeUI selectDataUI) {
        this.seriesDefns = seriesDefns;
        this.wizardContext = wizardContext;
        this.sTitle = sTitle;
        this.axisIndex = axisIndex;
        this.selectDataUI = selectDataUI;
    }

    public DataDefinitionSelector(ChartWizardContext wizardContext, String sTitle, ISelectDataCustomizeUI selectDataUI) {
        this.wizardContext = wizardContext;
        this.sTitle = sTitle;
        this.axisIndex = -1;
        this.selectDataUI = selectDataUI;
    }

    public Composite createArea(Composite parent) {
        GridData gridData;
        if (this.axisIndex >= 0) {
            this.cmpTop = new Group(parent, 0);
            ((Group)this.cmpTop).setText(Messages.getString("DataDefinitionSelector.Label.YAxis") + (this.axisIndex + 1));
        } else {
            this.cmpTop = new Composite(parent, 0);
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 2;
        this.cmpTop.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        this.cmpTop.setLayoutData((Object)gd);
        if (this.wizardContext.isMoreAxesSupported()) {
            this.cmbAxisSelect = new Combo(this.cmpTop, 12);
            this.cmbAxisSelect.setLayoutData((Object)new GridData(768));
            this.cmbAxisSelect.addSelectionListener((SelectionListener)this);
            this.refreshAxisCombo();
            this.cmbAxisSelect.select(0);
            this.btnAxisDelete = new Button(this.cmpTop, 0);
            gridData = new GridData();
            gridData.heightHint = 20;
            gridData.widthHint = 20;
            this.btnAxisDelete.setLayoutData((Object)gridData);
            this.btnAxisDelete.setImage(UIHelper.getImage((String)"icons/obj16/delete_edit.gif"));
            this.btnAxisDelete.setToolTipText(Messages.getString("DataDefinitionSelector.Tooltip.RemoveAxis"));
            this.btnAxisDelete.addSelectionListener((SelectionListener)this);
            this.setAxisDeleteEnabled();
            Label lblSeparator = new Label(this.cmpTop, 258);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            lblSeparator.setLayoutData((Object)gd);
            this.axisIndex = this.cmbAxisSelect.getSelectionIndex();
            this.seriesDefns = ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)this.getChart(), (int)this.axisIndex);
        }
        this.cmbSeriesSelect = new Combo(this.cmpTop, 12);
        this.cmbSeriesSelect.setLayoutData((Object)new GridData(768));
        this.cmbSeriesSelect.addSelectionListener((SelectionListener)this);
        this.refreshSeriesCombo();
        this.cmbSeriesSelect.select(0);
        this.btnSeriesDelete = new Button(this.cmpTop, 0);
        gridData = new GridData();
        gridData.heightHint = 20;
        gridData.widthHint = 20;
        this.btnSeriesDelete.setLayoutData((Object)gridData);
        this.btnSeriesDelete.setImage(UIHelper.getImage((String)"icons/obj16/delete_edit.gif"));
        this.btnSeriesDelete.setToolTipText(Messages.getString("DataDefinitionSelector.Tooltip.RemoveSeries"));
        this.btnSeriesDelete.addSelectionListener((SelectionListener)this);
        this.setSeriesDeleteEnabled();
        this.updateDataDefinition();
        return this.cmpTop;
    }

    private void updateDataDefinition() {
        ISelectDataComponent newComponent = this.getDataDefinitionComponent(this.getCurrentSeriesDefinition());
        if (this.dateComponent != null && this.dateComponent.getClass() == newComponent.getClass()) {
            return;
        }
        if (this.cmpData != null && !this.cmpData.isDisposed()) {
            this.cmpData.dispose();
        }
        this.dateComponent = newComponent;
        this.cmpData = this.dateComponent.createArea(this.cmpTop);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.cmpData.setLayoutData((Object)gd);
    }

    private SeriesDefinition getCurrentSeriesDefinition() {
        return (SeriesDefinition)this.seriesDefns.get(this.cmbSeriesSelect.getSelectionIndex());
    }

    private int getFirstIndexOfSameAxis() {
        if (this.axisIndex > 0) {
            return ChartUIUtil.getLastSeriesIndexWithinAxis((Chart)this.getChart(), (int)(this.axisIndex - 1)) + 1;
        }
        return 0;
    }

    protected void addNewSeriesDefinition() {
        SeriesDefinition sdTmp = SeriesDefinitionImpl.create();
        sdTmp.getSeriesPalette().update(-this.seriesDefns.size());
        sdTmp.getSeries().add((Object)EcoreUtil.copy((EObject)((SeriesDefinition)this.seriesDefns.get(0)).getDesignTimeSeries()));
        sdTmp.setQuery((Query)EcoreUtil.copy((EObject)((SeriesDefinition)this.seriesDefns.get(0)).getQuery()));
        this.cleanDataDefinition(sdTmp);
        sdTmp.eAdapters().addAll((Collection)((SeriesDefinition)this.seriesDefns.get(0)).eAdapters());
        int firstIndex = this.getFirstIndexOfSameAxis();
        EList list = this.getChart().getSampleData().getOrthogonalSampleData();
        OrthogonalSampleData sdOrthogonal = (OrthogonalSampleData)EcoreUtil.copy((EObject)((EObject)list.get(firstIndex)));
        sdOrthogonal.setSeriesDefinitionIndex(list.size());
        sdOrthogonal.eAdapters().addAll((Collection)this.getChart().getSampleData().eAdapters());
        boolean isNotificaionIgnored = ChartAdapter.isNotificationIgnored();
        ChartAdapter.ignoreNotifications((boolean)true);
        list.add((Object)sdOrthogonal);
        ChartAdapter.ignoreNotifications((boolean)isNotificaionIgnored);
        this.seriesDefns.add((Object)sdTmp);
    }

    private void cleanDataDefinition(SeriesDefinition sd) {
        EList dds = sd.getDesignTimeSeries().getDataDefinition();
        for (int i = 0; i < dds.size(); ++i) {
            ((Query)dds.get(i)).setDefinition("");
        }
    }

    private void updateSeriesPalette(int removedIndex) {
        int j = 0;
        for (int i = 0; i < this.seriesDefns.size(); ++i) {
            if (i == removedIndex) continue;
            ((SeriesDefinition)this.seriesDefns.get(i)).getSeriesPalette().update(-j++);
        }
    }

    protected void removeSeriesDefinition() {
        boolean isNotificaionIgnored = ChartAdapter.isNotificationIgnored();
        ChartAdapter.ignoreNotifications((boolean)true);
        int firstIndex = this.getFirstIndexOfSameAxis();
        EList list = this.getChart().getSampleData().getOrthogonalSampleData();
        for (int i = 0; i < list.size(); ++i) {
            if (((OrthogonalSampleData)list.get(i)).getSeriesDefinitionIndex() != firstIndex + this.cmbSeriesSelect.getSelectionIndex()) continue;
            list.remove(i);
            break;
        }
        ChartUIUtil.reorderOrthogonalSampleDataIndex((Chart)this.getChart());
        this.updateSeriesPalette(this.cmbSeriesSelect.getSelectionIndex());
        ChartAdapter.ignoreNotifications((boolean)isNotificaionIgnored);
        this.seriesDefns.remove(this.cmbSeriesSelect.getSelectionIndex());
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget.equals(this.btnSeriesDelete)) {
            this.updateColorRegistry(this.cmbSeriesSelect.getSelectionIndex());
            this.removeSeriesDefinition();
            this.setSeriesDeleteEnabled();
            int oldSelectedIndex = this.cmbSeriesSelect.getSelectionIndex();
            this.refreshSeriesCombo();
            if (oldSelectedIndex > this.cmbSeriesSelect.getItemCount() - 2) {
                oldSelectedIndex = this.cmbSeriesSelect.getItemCount() - 2;
            }
            this.cmbSeriesSelect.select(oldSelectedIndex);
            this.updateDataDefinition();
            this.refreshQuery();
            this.setSelectedSeriesIndex();
            this.selectDataUI.layoutAll();
        } else if (e.widget.equals(this.cmbSeriesSelect)) {
            if (this.cmbSeriesSelect.getSelectionIndex() == this.cmbSeriesSelect.getItemCount() - 1) {
                this.addNewSeriesDefinition();
                this.setSeriesDeleteEnabled();
                this.refreshSeriesCombo();
                this.cmbSeriesSelect.select(this.cmbSeriesSelect.getItemCount() - 2);
            }
            this.updateDataDefinition();
            this.refreshQuery();
            this.setSelectedSeriesIndex();
            this.selectDataUI.layoutAll();
        } else if (e.widget.equals(this.cmbAxisSelect)) {
            if (this.cmbAxisSelect.getSelectionIndex() == this.cmbAxisSelect.getItemCount() - 1) {
                ChartAdapter.changeChartWithoutNotification((IChangeWithoutNotification)new IChangeWithoutNotification(){

                    public Object run() {
                        String currentDimension = ChartUIUtil.getDimensionString((ChartDimension)DataDefinitionSelector.this.getChart().getDimension());
                        boolean isDimensionSupported = DataDefinitionSelector.this.wizardContext.getChartType().isDimensionSupported(currentDimension, DataDefinitionSelector.this.cmbAxisSelect.getItemCount(), 0);
                        if (!isDimensionSupported) {
                            DataDefinitionSelector.this.getChart().setDimension(ChartUIUtil.getDimensionType((String)DataDefinitionSelector.this.wizardContext.getChartType().getDefaultDimension()));
                        }
                        return null;
                    }
                });
                ChartUIUtil.addAxis((ChartWithAxes)((ChartWithAxes)this.getChart()));
                this.setAxisDeleteEnabled();
                this.refreshAxisCombo();
                this.cmbAxisSelect.select(this.cmbAxisSelect.getItemCount() - 2);
            }
            this.axisIndex = this.cmbAxisSelect.getSelectionIndex();
            this.updateAllSeriesUnderAxis();
        } else if (e.widget.equals(this.btnAxisDelete)) {
            this.updateColorRegistry(-1);
            ChartUIUtil.removeAxis((Chart)this.getChart(), (int)this.axisIndex);
            this.setAxisDeleteEnabled();
            this.refreshAxisCombo();
            if (this.axisIndex > this.cmbAxisSelect.getItemCount() - 2) {
                this.axisIndex = this.cmbAxisSelect.getItemCount() - 2;
            }
            this.cmbAxisSelect.select(this.axisIndex);
            this.updateAllSeriesUnderAxis();
        }
    }

    private void updateAllSeriesUnderAxis() {
        this.seriesDefns = ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)this.getChart(), (int)this.axisIndex);
        this.setSeriesDeleteEnabled();
        this.refreshSeriesCombo();
        this.cmbSeriesSelect.select(0);
        this.updateDataDefinition();
        this.refreshQuery();
        this.setSelectedSeriesIndex();
        this.selectDataUI.layoutAll();
    }

    private void updateColorRegistry(int seriesIndex) {
        String expression;
        int i;
        Object dataDefinitions = null;
        if (seriesIndex > -1) {
            dataDefinitions = ((SeriesDefinition)this.seriesDefns.get(seriesIndex)).getDesignTimeSeries().getDataDefinition();
        } else {
            List allSeriesDefns = ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)this.getChart());
            dataDefinitions = new ArrayList();
            for (i = 0; i < allSeriesDefns.size(); ++i) {
                dataDefinitions.addAll(((SeriesDefinition)allSeriesDefns.get(i)).getDesignTimeSeries().getDataDefinition());
            }
        }
        HashMap<String, Integer> queryMap = new HashMap<String, Integer>();
        for (i = 0; i < dataDefinitions.size(); ++i) {
            expression = ((Query)dataDefinitions.get(i)).getDefinition();
            if (queryMap.containsKey(expression)) {
                int expCount = (Integer)queryMap.get(expression);
                queryMap.put(expression, new Integer(expCount++));
                continue;
            }
            queryMap.put(expression, new Integer(1));
        }
        Iterator iterator = queryMap.keySet().iterator();
        while (iterator.hasNext()) {
            expression = (String)iterator.next();
            if (DataDefinitionTextManager.getInstance().getNumberOfSameDataDefinition(expression) != ((Integer)queryMap.get(expression)).intValue()) continue;
            ColorPalette.getInstance().retrieveColor(expression);
        }
        for (int i2 = 0; i2 < this.getCustomTable().getColumnNumber(); ++i2) {
            this.getCustomTable().setColumnColor(i2, ColorPalette.getInstance().getColor(ChartUIUtil.getExpressionString((String)this.getCustomTable().getColumnHeading(i2))));
        }
    }

    private void setSelectedSeriesIndex() {
        if (!this.wizardContext.isMoreAxesSupported()) {
            int axisNum = this.axisIndex < 0 ? 0 : this.axisIndex;
            int[] indexArray = this.selectDataUI.getSeriesIndex();
            indexArray[axisNum] = this.cmbSeriesSelect.getSelectionIndex();
            this.selectDataUI.setSeriesIndex(indexArray);
        }
    }

    private void setSeriesDeleteEnabled() {
        this.btnSeriesDelete.setEnabled(this.seriesDefns.size() > 1);
    }

    private void setAxisDeleteEnabled() {
        this.btnAxisDelete.setEnabled(ChartUIUtil.getOrthogonalAxisNumber((Chart)this.getChart()) > 1);
    }

    private CustomPreviewTable getCustomTable() {
        return (CustomPreviewTable)((Object)this.selectDataUI.getCustomPreviewTable());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void refreshQuery() {
        Object[] data = new Object[]{this.getCurrentSeriesDefinition(), ChartUIUtil.getDataQuery((SeriesDefinition)this.getCurrentSeriesDefinition(), (int)0)};
        this.dateComponent.selectArea(true, (Object)data);
    }

    private void refreshSeriesCombo() {
        ArrayList<String> itemList = new ArrayList<String>();
        int seriesSize = this.seriesDefns.size();
        for (int i = 1; i <= seriesSize; ++i) {
            itemList.add(this.selectionName + " " + i);
        }
        itemList.add(Messages.getString("DataDefinitionSelector.Text.NewSeries"));
        this.cmbSeriesSelect.removeAll();
        this.cmbSeriesSelect.setItems(itemList.toArray(new String[seriesSize]));
    }

    private void refreshAxisCombo() {
        ArrayList<String> itemList = new ArrayList<String>();
        int axisNum = ChartUIUtil.getOrthogonalAxisNumber((Chart)this.getChart());
        for (int i = 1; i <= axisNum; ++i) {
            itemList.add(Messages.getString("DataDefinitionSelector.Label.Axis") + i);
        }
        itemList.add(Messages.getString("DataDefinitionSelector.Text.NewAxis"));
        this.cmbAxisSelect.removeAll();
        this.cmbAxisSelect.setItems(itemList.toArray(new String[axisNum]));
    }

    private ISelectDataComponent getDataDefinitionComponent(SeriesDefinition seriesDefn) {
        ISelectDataComponent sdc = this.selectDataUI.getAreaComponent(this.areaType, seriesDefn, this.wizardContext, this.sTitle);
        if (sdc instanceof BaseDataDefinitionComponent) {
            ((BaseDataDefinitionComponent)sdc).setDescription(this.description);
        }
        return sdc;
    }

    public void selectArea(boolean selected, Object data) {
        this.dateComponent.selectArea(selected, data);
    }

    public void dispose() {
        this.dateComponent.dispose();
        super.dispose();
    }

    public void setSelectionPrefix(String selectionNamePrefix) {
        this.selectionName = selectionNamePrefix;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAreaType(int areaType) {
        this.areaType = areaType;
    }

    private Chart getChart() {
        return this.wizardContext.getModel();
    }
}

