/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.data;

import java.util.ArrayList;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.DefaultSelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class MultipleSeriesComponent
extends DefaultSelectDataComponent
implements Listener {
    private transient EList[] seriesDefnsArray;
    private transient ChartWizardContext context = null;
    private transient String sTitle = null;
    private static final String LABEL_GROUPING_YSERIES = Messages.getString("MultipleSeriesComponent.Label.OptionalYSeriesGrouping");
    private static final String LABEL_GROUPING_OVERLAY = Messages.getString("MultipleSeriesComponent.Label.OptionalOverlayGrouping");
    private static final String LABEL_GROUPING_WITHOUTAXIS = Messages.getString("MultipleSeriesComponent.Label.OptionalGrouping");
    private transient ISelectDataCustomizeUI selectDataUI = null;
    private transient ArrayList components = new ArrayList();
    private transient boolean isSingle = false;
    private transient boolean useFirstOnly = true;

    public MultipleSeriesComponent(EList[] seriesDefnsArray, ChartWizardContext context, String sTitle, ISelectDataCustomizeUI selectDataUI) {
        this.seriesDefnsArray = seriesDefnsArray;
        this.context = context;
        this.sTitle = sTitle;
        this.selectDataUI = selectDataUI;
    }

    public MultipleSeriesComponent(EList seriesDefns, ChartWizardContext context, String sTitle, ISelectDataCustomizeUI selectDataUI) {
        this(new EList[]{seriesDefns}, context, sTitle, selectDataUI);
        this.isSingle = true;
    }

    public Composite createArea(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        cmp.setLayout((Layout)gridLayout);
        cmp.setLayoutData((Object)new GridData(768));
        Label topAngle = new Label(cmp, 0);
        topAngle.setImage(UIHelper.getImage((String)"icons/obj16/ra_topleft.gif"));
        for (int i = 0; i < this.seriesDefnsArray.length; ++i) {
            this.createRightGroupArea(cmp, i, this.seriesDefnsArray[i]);
            if (this.useFirstOnly) break;
        }
        Label bottomAngle = new Label(cmp, 0);
        bottomAngle.setImage(UIHelper.getImage((String)"icons/obj16/ra_bottomleft.gif"));
        return cmp;
    }

    private void createRightGroupArea(Composite parent, final int axisIndex, final EList seriesDefn) {
        final String strDesc = this.getGroupingDescription(axisIndex);
        DefaultSelectDataComponent subUIGroupY = new DefaultSelectDataComponent(){
            private transient Composite cmpGroup;
            private transient Label lblRightYGrouping;

            public Composite createArea(Composite parent) {
                this.cmpGroup = ChartUIUtil.createCompositeWrapper((Composite)parent);
                this.cmpGroup.setLayoutData((Object)new GridData(768));
                this.lblRightYGrouping = new Label(this.cmpGroup, 64);
                GridData gd = new GridData();
                gd.widthHint = MultipleSeriesComponent.this.getStandardWidth() * 16;
                this.lblRightYGrouping.setLayoutData((Object)gd);
                this.lblRightYGrouping.setText(strDesc);
                int selectedSeriesIndex = 0;
                if (!MultipleSeriesComponent.this.useFirstOnly) {
                    selectedSeriesIndex = MultipleSeriesComponent.this.selectDataUI.getSeriesIndex()[axisIndex];
                }
                if (seriesDefn != null && !seriesDefn.isEmpty()) {
                    ISelectDataComponent subUI = MultipleSeriesComponent.this.selectDataUI.getAreaComponent(2, (SeriesDefinition)seriesDefn.get(selectedSeriesIndex), MultipleSeriesComponent.this.context, MultipleSeriesComponent.this.sTitle);
                    subUI.addListener((Listener)MultipleSeriesComponent.this);
                    subUI.createArea(this.cmpGroup);
                    MultipleSeriesComponent.this.components.add(subUI);
                }
                return this.cmpGroup;
            }
        };
        subUIGroupY.createArea(parent);
        this.components.add(subUIGroupY);
    }

    private int getStandardWidth() {
        GC gc = new GC((Drawable)Display.getCurrent());
        int width = gc.textExtent((String)"X").x;
        gc.dispose();
        return width;
    }

    public void selectArea(boolean selected, Object data) {
        for (int i = 0; i < this.components.size(); ++i) {
            ((ISelectDataComponent)this.components.get(i)).selectArea(selected, data);
        }
    }

    public void dispose() {
        for (int i = 0; i < this.components.size(); ++i) {
            ((ISelectDataComponent)this.components.get(i)).dispose();
        }
        super.dispose();
    }

    private String getGroupingDescription(int axisIndex) {
        if (this.isSingle) {
            return LABEL_GROUPING_WITHOUTAXIS;
        }
        if (axisIndex == 0) {
            return LABEL_GROUPING_YSERIES;
        }
        return LABEL_GROUPING_OVERLAY;
    }

    public void handleEvent(Event event) {
        this.fireEvent(event);
    }
}

