/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.data;

import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.DefaultSelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.DataDefinitionSelector;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MultipleSeriesSelectorComponent
extends DefaultSelectDataComponent {
    private transient EList[] seriesDefnsArray;
    private transient ChartWizardContext wizardContext = null;
    private transient String sTitle = null;
    private transient Group cmpLeft;
    private transient DataDefinitionSelector[] selectors;
    private transient ISelectDataCustomizeUI selectDataUI = null;
    private transient String areaTitle = Messages.getString("SelectDataChartWithAxisUI.Label.ValueYSeries");

    public MultipleSeriesSelectorComponent(EList[] seriesDefnsArray, ChartWizardContext wizardContext, String sTitle, ISelectDataCustomizeUI selectDataUI) {
        this.seriesDefnsArray = seriesDefnsArray;
        this.wizardContext = wizardContext;
        this.sTitle = sTitle;
        this.selectDataUI = selectDataUI;
    }

    public Composite createArea(Composite parent) {
        Label topAngle = new Label(parent, 0);
        topAngle.setLayoutData((Object)new GridData(128));
        topAngle.setImage(UIHelper.getImage((String)"icons/obj16/ra_topright.gif"));
        this.cmpLeft = new Group(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.cmpLeft.setLayout((Layout)gridLayout);
        this.cmpLeft.setLayoutData((Object)new GridData(768));
        this.cmpLeft.setText(this.areaTitle);
        if (this.seriesDefnsArray.length > 2) {
            this.wizardContext.setMoreAxesSupported(true);
        }
        if (this.wizardContext.isMoreAxesSupported()) {
            this.selectors = new DataDefinitionSelector[1];
            this.selectors[0] = new DataDefinitionSelector(this.wizardContext, this.sTitle, this.selectDataUI);
            if (this.wizardContext.getModel() instanceof DialChart) {
                this.selectors[0].setSelectionPrefix(Messages.getString("DialBottomAreaComponent.Label.Dial"));
            }
            this.selectors[0].createArea((Composite)this.cmpLeft);
        } else {
            this.selectors = new DataDefinitionSelector[this.seriesDefnsArray.length];
            for (int i = 0; i < this.seriesDefnsArray.length; ++i) {
                int axisIndex = this.seriesDefnsArray.length == 1 ? -1 : i;
                this.selectors[i] = new DataDefinitionSelector(axisIndex, this.seriesDefnsArray[i], this.wizardContext, this.sTitle, this.selectDataUI);
                if (this.wizardContext.getModel() instanceof DialChart) {
                    this.selectors[i].setSelectionPrefix(Messages.getString("DialBottomAreaComponent.Label.Dial"));
                }
                this.selectors[i].createArea((Composite)this.cmpLeft);
            }
        }
        Label bottomAngle = new Label(parent, 0);
        bottomAngle.setLayoutData((Object)new GridData(128));
        bottomAngle.setImage(UIHelper.getImage((String)"icons/obj16/ra_bottomright.gif"));
        return this.cmpLeft;
    }

    public void selectArea(boolean selected, Object data) {
        for (int i = 0; i < this.selectors.length; ++i) {
            this.selectors[i].selectArea(selected, data);
        }
    }

    public void dispose() {
        for (int i = 0; i < this.selectors.length; ++i) {
            this.selectors[i].dispose();
        }
        super.dispose();
    }

    public void setAreaTitle(String areaTitle) {
        this.areaTitle = areaTitle;
    }
}

