/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.interfaces.ISeriesUIProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartUIExtensionsImpl;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.MultipleSeriesComponent;
import org.eclipse.birt.chart.ui.swt.wizard.data.MultipleSeriesSelectorComponent;
import org.eclipse.birt.chart.ui.swt.wizard.internal.CustomPreviewTable;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ITask;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SelectDataDynamicArea
implements ISelectDataCustomizeUI,
Listener {
    private transient ITask task = null;
    private transient Hashtable htSeriesUIProviders = null;
    private transient CustomPreviewTable customTable = null;
    protected transient List subLeftAreas = new ArrayList();
    protected transient List subRightAreas = new ArrayList();
    protected transient Composite cmpLeftArea = null;
    protected transient Composite cmpRightArea = null;
    protected transient Composite cmpBottomArea = null;
    protected transient ISelectDataComponent bottomArea;
    private transient int[] seriesIndex = new int[0];

    public SelectDataDynamicArea(ITask task) {
        this.task = task;
    }

    protected ChartWizardContext getContext() {
        return (ChartWizardContext)this.task.getContext();
    }

    protected Chart getChartModel() {
        return this.getContext().getModel();
    }

    public void selectLeftBindingArea(boolean selected, Object data) {
        for (int i = 0; i < this.subLeftAreas.size(); ++i) {
            ((ISelectDataComponent)this.subLeftAreas.get(i)).selectArea(selected, data);
        }
    }

    public void selectRightBindingArea(boolean selected, Object data) {
        for (int i = 0; i < this.subRightAreas.size(); ++i) {
            ((ISelectDataComponent)this.subRightAreas.get(i)).selectArea(selected, data);
        }
    }

    public void selectBottomBindingArea(boolean selected, Object data) {
        this.bottomArea.selectArea(selected, data);
    }

    public void dispose() {
        List list = this.subLeftAreas;
        list.addAll(this.subRightAreas);
        for (int i = 0; i < list.size(); ++i) {
            ((ISelectDataComponent)list.get(i)).dispose();
        }
        if (this.bottomArea != null) {
            this.bottomArea.dispose();
        }
        list.clear();
    }

    public ISelectDataComponent getAreaComponent(int areaType, SeriesDefinition seriesdefinition, ChartWizardContext context, String sTitle) {
        if (this.htSeriesUIProviders == null) {
            this.htSeriesUIProviders = new Hashtable();
            this.initSeriesDataUIProviders();
        }
        return ((ISeriesUIProvider)this.htSeriesUIProviders.get(seriesdefinition.getDesignTimeSeries().getClass().getName())).getSeriesDataComponent(areaType, seriesdefinition, context, sTitle);
    }

    private void initSeriesDataUIProviders() {
        Collection cRegisteredEntries = ChartUIExtensionsImpl.instance().getSeriesUIComponents();
        Iterator iterEntries = cRegisteredEntries.iterator();
        while (iterEntries.hasNext()) {
            ISeriesUIProvider provider = (ISeriesUIProvider)iterEntries.next();
            String sSeries = provider.getSeriesClass();
            this.htSeriesUIProviders.put(sSeries, provider);
        }
    }

    public void refreshLeftBindingArea() {
        this.subLeftAreas.clear();
        Composite cmpContainer = this.cmpLeftArea.getParent();
        this.cmpLeftArea.dispose();
        this.createLeftBindingArea(cmpContainer);
        cmpContainer.layout();
    }

    public void refreshRightBindingArea() {
        this.subRightAreas.clear();
        Composite cmpContainer = this.cmpRightArea.getParent();
        this.cmpRightArea.dispose();
        this.createRightBindingArea(cmpContainer);
        cmpContainer.layout();
    }

    public void refreshBottomBindingArea() {
        Composite cmpContainer = this.cmpBottomArea.getParent();
        this.cmpBottomArea.dispose();
        this.createBottomBindingArea(cmpContainer);
        cmpContainer.layout();
    }

    public void createLeftBindingArea(Composite parent) {
        this.cmpLeftArea = ChartUIUtil.createCompositeWrapper((Composite)parent);
        this.cmpLeftArea.setLayoutData((Object)new GridData(772));
        if (this.getChartModel() instanceof ChartWithAxes) {
            int axisNum = ChartUIUtil.getOrthogonalAxisNumber((Chart)this.getChartModel());
            EList[] seriesDefnArray = new EList[axisNum];
            EList axisList = this.getYAxisListForProcessing();
            if (axisList != null && !axisList.isEmpty()) {
                for (int i = 0; i < axisList.size(); ++i) {
                    seriesDefnArray[i] = ((Axis)axisList.get(i)).getSeriesDefinitions();
                }
            }
            MultipleSeriesSelectorComponent component = new MultipleSeriesSelectorComponent(seriesDefnArray, this.getContext(), "", this);
            this.subLeftAreas.add(component);
            component.createArea(this.cmpLeftArea);
        } else {
            MultipleSeriesSelectorComponent component = new MultipleSeriesSelectorComponent(new EList[]{this.getValueSeriesDefinitionForProcessing()}, this.getContext(), "", this);
            if (this.getChartModel() instanceof DialChart) {
                component.setAreaTitle(Messages.getString("DialBottomAreaComponent.Label.GaugeValueDefinition"));
            } else {
                component.setAreaTitle(Messages.getString("PieLeftAreaComponent.Label.SliceSizeDefinition"));
            }
            component.createArea(this.cmpLeftArea);
            this.subLeftAreas.add(component);
        }
    }

    public void createRightBindingArea(Composite parent) {
        this.cmpRightArea = ChartUIUtil.createCompositeWrapper((Composite)parent);
        this.cmpRightArea.setLayoutData((Object)new GridData(772));
        if (this.getChartModel() instanceof ChartWithAxes) {
            int axisNum = ChartUIUtil.getOrthogonalAxisNumber((Chart)this.getChartModel());
            EList[] seriesDefnArray = new EList[axisNum];
            EList axisList = this.getYAxisListForProcessing();
            if (axisList != null && !axisList.isEmpty()) {
                for (int i = 0; i < axisList.size(); ++i) {
                    seriesDefnArray[i] = ((Axis)axisList.get(i)).getSeriesDefinitions();
                }
            }
            MultipleSeriesComponent component = new MultipleSeriesComponent(seriesDefnArray, this.getContext(), Messages.getString("AbstractSelectDataCustomizeUI.Label.SeriesGrouping"), (ISelectDataCustomizeUI)this);
            component.addListener(this);
            this.subRightAreas.add(component);
            component.createArea(this.cmpRightArea);
        } else {
            MultipleSeriesComponent component = new MultipleSeriesComponent(this.getValueSeriesDefinitionForProcessing(), this.getContext(), Messages.getString("AbstractSelectDataCustomizeUI.Label.SeriesGrouping"), (ISelectDataCustomizeUI)this);
            component.addListener(this);
            this.subRightAreas.add(component);
            component.createArea(this.cmpRightArea);
        }
    }

    private EList getYAxisListForProcessing() {
        Assert.isTrue((boolean)(this.getChartModel() instanceof ChartWithAxes));
        return ((Axis)((ChartWithAxes)this.getChartModel()).getAxes().get(0)).getAssociatedAxes();
    }

    public void createBottomBindingArea(Composite parent) {
        this.bottomArea = this.getContext().getChartType().getBaseUI(this.getChartModel(), (ISelectDataCustomizeUI)this, this.getContext(), "");
        this.cmpBottomArea = this.bottomArea.createArea(parent);
    }

    private SeriesDefinition getBaseSeriesDefinitionForProcessing() {
        return (SeriesDefinition)((ChartWithoutAxes)this.getChartModel()).getSeriesDefinitions().get(0);
    }

    private EList getValueSeriesDefinitionForProcessing() {
        return this.getBaseSeriesDefinitionForProcessing().getSeriesDefinitions();
    }

    public Object getCustomPreviewTable() {
        return this.customTable;
    }

    public void setCustomPreviewTable(CustomPreviewTable customTable) {
        this.customTable = customTable;
    }

    public void layoutAll() {
        if (this.cmpBottomArea != null && !this.cmpBottomArea.isDisposed()) {
            this.cmpBottomArea.getParent().getParent().layout();
        }
    }

    public int[] getSeriesIndex() {
        return this.seriesIndex;
    }

    public void setSeriesIndex(int[] seriesIndex) {
        this.seriesIndex = seriesIndex;
    }

    public void init() {
        this.seriesIndex = new int[ChartUIUtil.getOrthogonalAxisNumber((Chart)this.getChartModel())];
    }

    public void handleEvent(Event event) {
        ChartAdapter.ignoreNotifications((boolean)true);
        ChartUIUtil.setAllGroupingQueryExceptFirst((Chart)this.getChartModel(), (String)event.text);
        ChartAdapter.ignoreNotifications((boolean)false);
    }
}

