/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.axis;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.ExternalizedTextEditorComposite;
import org.eclipse.birt.chart.ui.swt.composites.FormatSpecifierDialog;
import org.eclipse.birt.chart.ui.swt.composites.TextEditorComposite;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.InteractivitySheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis.AxisGridLinesSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis.AxisMarkersSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis.AxisScaleSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis.AxisTextSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

abstract class AbstractAxisSubtask
extends SubtaskSheetImpl
implements Listener,
SelectionListener {
    private transient ExternalizedTextEditorComposite txtTitle;
    private transient Combo cmbTypes;
    private transient Combo cmbOrigin;
    private transient Button btnFormatSpecifier;
    private transient Button btnVisible;
    private transient Label lblValue;
    private transient TextEditorComposite txtValue;

    AbstractAxisSubtask() {
    }

    protected abstract Axis getAxisForProcessing();

    protected abstract int getAxisAngleType();

    public void getComponent(Composite parent) {
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout(2, false);
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        Composite cmpBasic = new Composite(this.cmpContent, 0);
        cmpBasic.setLayout((Layout)new GridLayout(3, false));
        cmpBasic.setLayoutData((Object)new GridData(768));
        new Label(cmpBasic, 0).setText(Messages.getString("AxisYSheetImpl.Label.Title"));
        List keys = null;
        IUIServiceProvider serviceprovider = this.getContext().getUIServiceProvider();
        if (serviceprovider != null) {
            keys = serviceprovider.getRegisteredKeys();
        }
        this.txtTitle = new ExternalizedTextEditorComposite(cmpBasic, 2052, -1, -1, keys, serviceprovider, this.getAxisForProcessing().getTitle().getCaption().getValue());
        GridData gd2 = new GridData();
        gd2.widthHint = 250;
        gd2.horizontalSpan = 2;
        this.txtTitle.setLayoutData(gd2);
        this.txtTitle.addListener(this);
        Label lblType = new Label(cmpBasic, 0);
        lblType.setText(Messages.getString("OrthogonalAxisDataSheetImpl.Lbl.Type"));
        this.cmbTypes = new Combo(cmpBasic, 12);
        GridData gd3 = new GridData();
        gd3.widthHint = 200;
        this.cmbTypes.setLayoutData((Object)gd3);
        this.cmbTypes.addSelectionListener((SelectionListener)this);
        this.btnFormatSpecifier = new Button(cmpBasic, 8);
        GridData gdBTNFormatSpecifier = new GridData();
        gdBTNFormatSpecifier.widthHint = 20;
        gdBTNFormatSpecifier.horizontalIndent = -3;
        this.btnFormatSpecifier.setLayoutData((Object)gdBTNFormatSpecifier);
        this.btnFormatSpecifier.setImage(UIHelper.getImage((String)"icons/obj16/formatbuilder.gif"));
        this.btnFormatSpecifier.setToolTipText(Messages.getString("Shared.Tooltip.FormatSpecifier"));
        this.btnFormatSpecifier.addSelectionListener((SelectionListener)this);
        this.btnFormatSpecifier.getImage().setBackground(this.btnFormatSpecifier.getBackground());
        if (this.getChart().getDimension().getValue() != 2) {
            Label lblOrigin = new Label(cmpBasic, 0);
            lblOrigin.setText(Messages.getString("OrthogonalAxisDataSheetImpl.Lbl.Origin"));
            this.cmbOrigin = new Combo(cmpBasic, 12);
            GridData gd4 = new GridData();
            gd4.widthHint = 200;
            gd4.horizontalSpan = 2;
            this.cmbOrigin.setLayoutData((Object)gd4);
            this.cmbOrigin.addSelectionListener((SelectionListener)this);
            boolean bValueOrigin = false;
            if (this.getAxisForProcessing().getOrigin() != null && this.getAxisForProcessing().getOrigin().getType().equals(IntersectionType.VALUE_LITERAL)) {
                bValueOrigin = true;
            }
            this.lblValue = new Label(cmpBasic, 0);
            this.lblValue.setText(Messages.getString("BaseAxisDataSheetImpl.Lbl.Value"));
            this.lblValue.setEnabled(bValueOrigin);
            this.txtValue = new TextEditorComposite(cmpBasic, 2052);
            GridData gd5 = new GridData();
            gd5.widthHint = 225;
            gd5.horizontalSpan = 2;
            this.txtValue.setLayoutData(gd5);
            this.txtValue.addListener(this);
            this.txtValue.setEnabled(bValueOrigin);
        }
        new Label(cmpBasic, 0).setText(Messages.getString("AxisYSheetImpl.Label.Labels"));
        this.btnVisible = new Button(cmpBasic, 32);
        this.btnVisible.setText(Messages.getString("AxisYSheetImpl.Label.Visible"));
        gd3 = new GridData(768);
        gd3.horizontalSpan = 2;
        this.btnVisible.setLayoutData((Object)gd3);
        this.btnVisible.addSelectionListener((SelectionListener)this);
        this.btnVisible.setSelection(this.getAxisForProcessing().getLabel().isVisible());
        this.createButtonGroup(this.cmpContent);
        this.populateLists();
    }

    private void createButtonGroup(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(5, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 0x1000008;
        cmp.setLayoutData((Object)gridData);
        AbstractPopupSheet popup = new AxisScaleSheet(Messages.getString("AxisYSheetImpl.Label.Scale"), this.getContext(), this.getAxisForProcessing());
        Button btnScale = this.createToggleButton(cmp, Messages.getString("AxisYSheetImpl.Label.Scale&"), popup);
        btnScale.addSelectionListener((SelectionListener)this);
        popup = new AxisTextSheet(Messages.getString("AxisYSheetImpl.Label.TextFormat"), this.getContext(), this.getAxisForProcessing(), this.getAxisAngleType());
        Button btnAxisTitle = this.createToggleButton(cmp, Messages.getString("AxisYSheetImpl.Label.TextFormat&"), popup);
        btnAxisTitle.addSelectionListener((SelectionListener)this);
        popup = new AxisGridLinesSheet(Messages.getString("AxisYSheetImpl.Label.Gridlines"), this.getContext(), this.getAxisForProcessing(), this.getAxisAngleType());
        Button btnGridlines = this.createToggleButton(cmp, Messages.getString("AxisYSheetImpl.Label.Gridlines&"), popup);
        btnGridlines.addSelectionListener((SelectionListener)this);
        popup = new AxisMarkersSheet(Messages.getString("AxisYSheetImpl.Label.Markers"), this.getContext(), this.getAxisForProcessing());
        Button btnMarkers = this.createToggleButton(cmp, Messages.getString("AxisYSheetImpl.Label.Markers&"), popup);
        btnMarkers.addSelectionListener((SelectionListener)this);
        btnMarkers.setEnabled(!ChartUIUtil.is3DType((Chart)this.getChart()));
        popup = new InteractivitySheet(Messages.getString("SeriesYSheetImpl.Label.Interactivity"), this.getContext(), this.getAxisForProcessing().getTriggers(), false, true);
        Button btnInteractivity = this.createToggleButton(cmp, Messages.getString("SeriesYSheetImpl.Label.Interactivity&"), popup);
        btnInteractivity.addSelectionListener((SelectionListener)this);
        btnInteractivity.setEnabled(this.getChart().getInteractivity().isEnable());
    }

    private void populateLists() {
        NameSet ns = LiteralHelper.axisTypeSet;
        this.cmbTypes.setItems(ns.getDisplayNames());
        this.cmbTypes.select(ns.getSafeNameIndex(this.getAxisForProcessing().getType().getName()));
        if (this.getChart().getDimension().getValue() != 2) {
            ns = LiteralHelper.intersectionTypeSet;
            this.cmbOrigin.setItems(ns.getDisplayNames());
            this.cmbOrigin.select(ns.getSafeNameIndex(this.getAxisForProcessing().getOrigin().getType().getName()));
        }
        if (this.getAxisForProcessing().getOrigin().getType().equals(IntersectionType.VALUE_LITERAL)) {
            this.txtValue.setText(this.getValue(this.getAxisForProcessing().getOrigin().getValue()));
        }
    }

    private String getValue(DataElement de) {
        if (de instanceof DateTimeDataElement) {
            Date dt = ((DateTimeDataElement)de).getValueAsCalendar().getTime();
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            return sdf.format(dt);
        }
        if (de instanceof NumberDataElement) {
            return NumberFormat.getInstance().format(((NumberDataElement)de).getValue());
        }
        return "";
    }

    private DataElement getTypedDataElement(String strDataElement) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        NumberFormat nf = NumberFormat.getInstance();
        try {
            Date dateElement = sdf.parse(strDataElement);
            Calendar cal = Calendar.getInstance((TimeZone)TimeZone.getDefault());
            cal.setTime(dateElement);
            return DateTimeDataElementImpl.create((Calendar)cal);
        }
        catch (ParseException e) {
            try {
                Number numberElement = nf.parse(strDataElement);
                return NumberDataElementImpl.create((double)numberElement.doubleValue());
            }
            catch (ParseException e1) {
                return null;
            }
        }
    }

    public void handleEvent(Event event) {
        DataElement de;
        if (event.widget.equals((Object)this.txtTitle)) {
            this.getAxisForProcessing().getTitle().getCaption().setValue((String)event.data);
        } else if (event.widget.equals((Object)this.txtValue) && (de = this.getTypedDataElement(this.txtValue.getText())) != null) {
            this.getAxisForProcessing().getOrigin().setValue(de);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.detachPopup(e.widget)) {
            return;
        }
        if (this.isRegistered(e.widget)) {
            this.attachPopup(((Button)e.widget).getText());
        }
        if (e.widget.equals(this.cmbTypes)) {
            AxisType axisType = AxisType.getByName((String)LiteralHelper.axisTypeSet.getNameByDisplayName(this.cmbTypes.getText()));
            boolean isNotificaionIgnored = ChartAdapter.isNotificationIgnored();
            ChartAdapter.ignoreNotifications((boolean)true);
            this.convertSampleData(axisType);
            ChartAdapter.ignoreNotifications((boolean)isNotificaionIgnored);
            this.getAxisForProcessing().setType(axisType);
            this.refreshPopupSheet();
        } else if (e.widget.equals(this.cmbOrigin)) {
            if (LiteralHelper.intersectionTypeSet.getNameByDisplayName(this.cmbOrigin.getText()).equals(IntersectionType.VALUE_LITERAL.getName())) {
                this.lblValue.setEnabled(true);
                this.txtValue.setEnabled(true);
            } else {
                this.lblValue.setEnabled(false);
                this.txtValue.setEnabled(false);
            }
            this.getAxisForProcessing().getOrigin().setType(IntersectionType.getByName((String)LiteralHelper.intersectionTypeSet.getNameByDisplayName(this.cmbOrigin.getText())));
        } else if (e.widget.equals(this.btnVisible)) {
            this.getAxisForProcessing().getLabel().setVisible(this.btnVisible.getSelection());
            this.refreshPopupSheet();
        } else if (e.widget.equals(this.btnFormatSpecifier)) {
            FormatSpecifierDialog editor;
            String sAxisTitle = Messages.getString("OrthogonalAxisDataSheetImpl.Lbl.OrthogonalAxis");
            try {
                String sTitleString = this.getAxisForProcessing().getTitle().getCaption().getValue();
                int iSeparatorIndex = sTitleString.indexOf("=");
                if (iSeparatorIndex > 0) {
                    sTitleString = sTitleString.substring(iSeparatorIndex);
                } else if (iSeparatorIndex == 0) {
                    sTitleString = sTitleString.substring("=".length());
                }
                sAxisTitle = sAxisTitle + " (" + sTitleString + ")";
            }
            catch (NullPointerException e1) {
                // empty catch block
            }
            FormatSpecifier formatspecifier = null;
            if (this.getAxisForProcessing().getFormatSpecifier() != null) {
                formatspecifier = this.getAxisForProcessing().getFormatSpecifier();
            }
            if (!(editor = new FormatSpecifierDialog(this.cmpContent.getShell(), formatspecifier, sAxisTitle)).wasCancelled()) {
                if (editor.getFormatSpecifier() == null) {
                    this.getAxisForProcessing().eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getAxis_FormatSpecifier());
                    return;
                }
                this.getAxisForProcessing().setFormatSpecifier(editor.getFormatSpecifier());
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void convertSampleData(AxisType axisType) {
        if (this.getAxisAngleType() == 1) {
            BaseSampleData bsd = (BaseSampleData)this.getChart().getSampleData().getBaseSampleData().get(0);
            bsd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)axisType, (String)bsd.getDataSetRepresentation()));
        } else if (this.getAxisAngleType() == 2) {
            int iStartIndex = this.getFirstSeriesDefinitionIndexForAxis();
            int iEndIndex = iStartIndex + this.getAxisForProcessing().getSeriesDefinitions().size();
            int iOSDSize = this.getChart().getSampleData().getOrthogonalSampleData().size();
            for (int i = 0; i < iOSDSize; ++i) {
                OrthogonalSampleData osd = (OrthogonalSampleData)this.getChart().getSampleData().getOrthogonalSampleData().get(i);
                if (osd.getSeriesDefinitionIndex() < iStartIndex || osd.getSeriesDefinitionIndex() > iEndIndex) continue;
                osd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)axisType, (String)osd.getDataSetRepresentation()));
            }
        }
    }

    private int getFirstSeriesDefinitionIndexForAxis() {
        int iTmp = 0;
        for (int i = 0; i < this.getIndex(); ++i) {
            iTmp += ChartUIUtil.getAxisYForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart()), (int)i).getSeriesDefinitions().size();
        }
        return iTmp;
    }
}

