/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.chart;

import java.util.Collection;
import java.util.List;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Interactivity;
import org.eclipse.birt.chart.model.attribute.LegendBehaviorType;
import org.eclipse.birt.chart.model.attribute.impl.InteractivityImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.ExternalizedTextEditorComposite;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.TriggerEditorDialog;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.BlockPropertiesSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.CustomPropertiesSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.MoreOptionsChartSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.TitlePropertiesSheet;
import org.eclipse.birt.chart.ui.swt.wizard.internal.ChartPreviewPainter;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ChartSheetImpl
extends SubtaskSheetImpl
implements SelectionListener,
Listener {
    private transient ExternalizedTextEditorComposite txtTitle = null;
    private transient FillChooserComposite cmbBackground;
    private transient Button btnTitleProp;
    private transient Button btnVisible;
    private transient Button btnEnable;
    private transient Combo cmbStyle;
    private transient Combo cmbInteractivity;
    private transient Button btnEnablePreview;
    private transient Button btnTitleTriggers;
    private transient Button btnChartAreaTriggers;
    private transient Label lblLegendBehavior;

    public void getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatChartArea_ID");
        this.init();
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout();
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        Composite cmpBasic = new Composite(this.cmpContent, 0);
        cmpBasic.setLayout((Layout)new GridLayout(3, false));
        gd = new GridData(768);
        cmpBasic.setLayoutData((Object)gd);
        Label lblTitle = new Label(cmpBasic, 0);
        lblTitle.setText(Messages.getString("ChartSheetImpl.Label.ChartTitle"));
        List keys = null;
        if (this.getContext().getUIServiceProvider() != null) {
            keys = this.getContext().getUIServiceProvider().getRegisteredKeys();
        }
        this.txtTitle = new ExternalizedTextEditorComposite(cmpBasic, 2048, -1, -1, keys, this.getContext().getUIServiceProvider(), this.getChart().getTitle().getLabel().getCaption().getValue());
        GridData gdTXTTitle = new GridData(768);
        this.txtTitle.setLayoutData(gdTXTTitle);
        if (!this.getChart().getTitle().isVisible()) {
            this.txtTitle.setEnabled(false);
        }
        this.txtTitle.addListener(this);
        this.btnVisible = new Button(cmpBasic, 32);
        this.btnVisible.setText(Messages.getString("ChartSheetImpl.Label.Visible"));
        this.btnVisible.setSelection(this.getChart().getTitle().isVisible());
        this.btnVisible.addSelectionListener((SelectionListener)this);
        Label lblBackground = new Label(cmpBasic, 0);
        lblBackground.setText(Messages.getString("ChartSheetImpl.Label.Background"));
        this.cmbBackground = new FillChooserComposite(cmpBasic, 0, this.getContext(), this.getChart().getBlock().getBackground(), true, true);
        GridData gridData = new GridData(768);
        this.cmbBackground.setLayoutData(gridData);
        this.cmbBackground.addListener(this);
        new Label(cmpBasic, 0);
        new Label(cmpBasic, 0).setText(Messages.getString("ChartSheetImpl.Label.Style"));
        this.cmbStyle = new Combo(cmpBasic, 12);
        gridData = new GridData(768);
        this.cmbStyle.setLayoutData((Object)gridData);
        this.cmbStyle.addSelectionListener((SelectionListener)this);
        this.btnEnablePreview = new Button(cmpBasic, 32);
        this.btnEnablePreview.setText(Messages.getString("ChartSheetImpl.Label.EnableInPreview"));
        this.btnEnablePreview.setSelection(ChartPreviewPainter.isProcessorEnabled());
        this.btnEnablePreview.addSelectionListener((SelectionListener)this);
        Group cmpInteractivity = new Group(cmpBasic, 0);
        GridLayout gl = new GridLayout(2, false);
        cmpInteractivity.setLayout((Layout)gl);
        GridData gd2 = new GridData(768);
        gd2.horizontalSpan = 2;
        cmpInteractivity.setLayoutData((Object)gd2);
        cmpInteractivity.setText(Messages.getString("ChartSheetImpl.Label.Interactivity"));
        this.btnEnable = new Button((Composite)cmpInteractivity, 32);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        this.btnEnable.setLayoutData((Object)gridData2);
        this.btnEnable.setText(Messages.getString("ChartSheetImpl.Label.InteractivityEnable"));
        this.btnEnable.setSelection(this.getChart().getInteractivity().isEnable());
        this.btnEnable.addSelectionListener((SelectionListener)this);
        this.lblLegendBehavior = new Label((Composite)cmpInteractivity, 0);
        this.lblLegendBehavior.setText(Messages.getString("ChartSheetImpl.Label.LegendBehaviorType"));
        this.cmbInteractivity = new Combo((Composite)cmpInteractivity, 12);
        gridData2 = new GridData(768);
        this.cmbInteractivity.setLayoutData((Object)gridData2);
        this.cmbInteractivity.addSelectionListener((SelectionListener)this);
        this.btnTitleTriggers = new Button((Composite)cmpInteractivity, 8);
        this.btnTitleTriggers.setText(Messages.getString("ChartSheetImpl.Text.TitleInteractivity"));
        this.btnTitleTriggers.addSelectionListener((SelectionListener)this);
        this.btnChartAreaTriggers = new Button((Composite)cmpInteractivity, 8);
        this.btnChartAreaTriggers.setText(Messages.getString("ChartSheetImpl.Text.ChartAreaInteractivity"));
        this.btnChartAreaTriggers.addSelectionListener((SelectionListener)this);
        this.enableInteractivity(this.btnEnable.getSelection());
        this.populateLists();
        this.createButtonGroup(this.cmpContent);
    }

    private void init() {
        if (this.getChart().getInteractivity() == null) {
            Interactivity interactivity = InteractivityImpl.create();
            interactivity.eAdapters().addAll((Collection)this.getChart().eAdapters());
            this.getChart().setInteractivity(interactivity);
        }
    }

    private void populateLists() {
        IDataServiceProvider idsp = this.getContext().getDataServiceProvider();
        if (idsp != null) {
            String[] allStyleNames = idsp.getAllStyles();
            String[] displayNames = idsp.getAllStyleDisplayNames();
            String[] selection = new String[displayNames.length + 1];
            System.arraycopy(displayNames, 0, selection, 1, displayNames.length);
            selection[0] = Messages.getString("ChartSheetImpl.Label.None");
            this.cmbStyle.setItems(selection);
            this.cmbStyle.setData((Object)allStyleNames);
            String sStyle = idsp.getCurrentStyle();
            int idx = this.getStyleIndex(sStyle);
            this.cmbStyle.select(idx + 1);
            NameSet nameSet = LiteralHelper.legendBehaviorTypeSet;
            this.cmbInteractivity.setItems(nameSet.getDisplayNames());
            this.cmbInteractivity.select(nameSet.getSafeNameIndex(this.getChart().getInteractivity().getLegendBehavior().getName()));
        }
    }

    private int getStyleIndex(String style) {
        String[] allStyleNames = (String[])this.cmbStyle.getData();
        if (style != null && allStyleNames != null) {
            for (int i = 0; i < allStyleNames.length; ++i) {
                if (!style.equals(allStyleNames[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private void createButtonGroup(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(4, false));
        GridData gridData = new GridData(768);
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 0x1000008;
        cmp.setLayoutData((Object)gridData);
        AbstractPopupSheet popup = new TitlePropertiesSheet(Messages.getString("ChartSheetImpl.Text.TitleFormat"), this.getContext());
        this.btnTitleProp = this.createToggleButton(cmp, Messages.getString("ChartSheetImpl.Text.TitleFormat&"), popup);
        this.btnTitleProp.addSelectionListener((SelectionListener)this);
        this.btnTitleProp.setEnabled(this.getChart().getTitle().isVisible());
        popup = new BlockPropertiesSheet(Messages.getString("ChartSheetImpl.Text.Outline"), this.getContext());
        Button btnBlockProp = this.createToggleButton(cmp, Messages.getString("ChartSheetImpl.Text.Outline&"), popup);
        btnBlockProp.addSelectionListener((SelectionListener)this);
        popup = new MoreOptionsChartSheet(Messages.getString("ChartSheetImpl.Text.GeneralProperties"), this.getContext());
        Button btnGeneralProp = this.createToggleButton(cmp, Messages.getString("ChartSheetImpl.Text.GeneralProperties&"), popup);
        btnGeneralProp.addSelectionListener((SelectionListener)this);
        popup = new CustomPropertiesSheet(Messages.getString("ChartSheetImpl.Text.CustomProperties"), this.getContext());
        Button btnCustomProp = this.createToggleButton(cmp, Messages.getString("ChartSheetImpl.Text.CustomProperties&"), popup);
        btnCustomProp.addSelectionListener((SelectionListener)this);
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.txtTitle)) {
            this.getChart().getTitle().getLabel().getCaption().setValue(this.txtTitle.getText());
        } else if (event.widget.equals((Object)this.cmbBackground)) {
            this.getChart().getBlock().setBackground((Fill)event.data);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.detachPopup(e.widget)) {
            return;
        }
        if (this.isRegistered(e.widget)) {
            this.attachPopup(((Button)e.widget).getText());
        }
        if (e.widget.equals(this.btnVisible)) {
            this.getChart().getTitle().setVisible(this.btnVisible.getSelection());
            this.txtTitle.setEnabled(this.btnVisible.getSelection());
            this.btnTitleProp.setEnabled(this.btnVisible.getSelection());
            if (this.btnTitleProp.getSelection()) {
                this.detachPopup();
            }
        } else if (e.widget.equals(this.cmbStyle)) {
            String[] allStyleNames = (String[])this.cmbStyle.getData();
            String sStyle = null;
            int idx = this.cmbStyle.getSelectionIndex();
            if (idx > 0) {
                sStyle = allStyleNames[idx - 1];
            }
            this.getContext().getDataServiceProvider().setStyle(sStyle);
            this.refreshPreview();
        } else if (e.widget.equals(this.btnEnablePreview)) {
            ChartPreviewPainter.enableProcessor(this.btnEnablePreview.getSelection());
            this.refreshPreview();
        } else if (e.widget.equals(this.btnEnable)) {
            this.getChart().getInteractivity().setEnable(this.btnEnable.getSelection());
            this.enableInteractivity(this.btnEnable.getSelection());
        } else if (e.widget.equals(this.cmbInteractivity)) {
            this.getChart().getInteractivity().setLegendBehavior(LegendBehaviorType.getByName((String)LiteralHelper.legendBehaviorTypeSet.getNameByDisplayName(this.cmbInteractivity.getText())));
        } else if (e.widget.equals(this.btnTitleTriggers)) {
            new TriggerEditorDialog(this.cmpContent.getShell(), this.getChart().getTitle().getTriggers(), this.getContext(), Messages.getString("ChartSheetImpl.Title.ChartTitle"), false, true);
        } else if (e.widget.equals(this.btnChartAreaTriggers)) {
            new TriggerEditorDialog(this.cmpContent.getShell(), this.getChart().getBlock().getTriggers(), this.getContext(), Messages.getString("ChartSheetImpl.Title.ChartArea"), false, true);
        }
    }

    private void enableInteractivity(boolean isEnabled) {
        this.lblLegendBehavior.setEnabled(isEnabled);
        this.cmbInteractivity.setEnabled(isEnabled);
        this.btnChartAreaTriggers.setEnabled(isEnabled);
        this.btnTitleTriggers.setEnabled(isEnabled);
    }

    private void refreshPreview() {
        boolean currentValue = this.btnVisible.getSelection();
        ChartAdapter.ignoreNotifications((boolean)true);
        this.getChart().getTitle().setVisible(!currentValue);
        ChartAdapter.ignoreNotifications((boolean)false);
        this.getChart().getTitle().setVisible(currentValue);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

