/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.series;

import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.birt.chart.model.attribute.AttributePackage;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.DataPoint;
import org.eclipse.birt.chart.model.attribute.DataPointComponent;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.DataPointComponentImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.FontDefinitionComposite;
import org.eclipse.birt.chart.ui.swt.composites.FormatSpecifierDialog;
import org.eclipse.birt.chart.ui.swt.composites.InsetsComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.composites.TextEditorComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;

public class SeriesLabelSheet
extends AbstractPopupSheet
implements SelectionListener,
Listener {
    private transient Composite cmpContent = null;
    private transient Group grpDataPoint = null;
    private transient List lstComponents = null;
    private transient Combo cmbComponentTypes = null;
    private transient Button btnAddComponent = null;
    private transient Button btnRemoveComponent = null;
    private transient Button btnFormatSpecifier = null;
    private transient TextEditorComposite txtPrefix = null;
    private transient TextEditorComposite txtSuffix = null;
    private transient TextEditorComposite txtSeparator = null;
    private transient LineAttributesComposite liacOutline = null;
    private transient InsetsComposite icInsets = null;
    private transient SeriesDefinition seriesDefn = null;
    private transient Label lblPosition;
    private transient Combo cmbPosition;
    private transient Label lblFont;
    private transient FontDefinitionComposite fdcFont;
    private transient Label lblFill;
    private transient FillChooserComposite fccBackground;
    private transient Label lblShadow;
    private transient FillChooserComposite fccShadow;
    private transient Button cbVisible;
    private transient Group grpAttributes;
    private transient Label lblPrefix;
    private transient Label lblSuffix;
    private transient Label lblSeparator;
    private transient Group grpOutline;

    public SeriesLabelSheet(String title, ChartWizardContext context, SeriesDefinition seriesDefn) {
        super(title, context, false);
        this.seriesDefn = seriesDefn;
    }

    public Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.DataPointLabels_ID");
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        this.cmpContent.setLayout((Layout)glContent);
        Composite cmpTop = new Composite(this.cmpContent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        cmpTop.setLayout((Layout)layout);
        cmpTop.setLayoutData((Object)new GridData(1808));
        this.cbVisible = new Button(cmpTop, 32);
        GridData gdCBVisible = new GridData(768);
        gdCBVisible.horizontalSpan = 2;
        gdCBVisible.horizontalIndent = 5;
        this.cbVisible.setLayoutData((Object)gdCBVisible);
        this.cbVisible.setSelection(this.getSeriesForProcessing().getLabel().isVisible());
        this.cbVisible.setText(Messages.getString("LabelAttributesComposite.Lbl.IsVisible"));
        this.cbVisible.addSelectionListener((SelectionListener)this);
        Composite cmpLeft = new Composite(cmpTop, 0);
        cmpLeft.setLayout((Layout)new GridLayout());
        cmpLeft.setLayoutData((Object)new GridData(1808));
        Composite cmpRight = new Composite(cmpTop, 0);
        cmpRight.setLayout((Layout)new GridLayout());
        cmpRight.setLayoutData((Object)new GridData(1808));
        this.createAttributeArea(cmpLeft);
        this.grpOutline = new Group(cmpLeft, 0);
        GridData gdGOutline = new GridData(768);
        gdGOutline.heightHint = 110;
        this.grpOutline.setLayoutData((Object)gdGOutline);
        this.grpOutline.setText(Messages.getString("LabelAttributesComposite.Lbl.Outline"));
        this.grpOutline.setLayout((Layout)new FillLayout());
        this.liacOutline = new LineAttributesComposite((Composite)this.grpOutline, 0, this.getContext(), this.getSeriesForProcessing().getLabel().getOutline(), true, true, true);
        this.liacOutline.addListener(this);
        this.createDataPointArea(cmpRight);
        this.icInsets = new InsetsComposite(cmpRight, 0, this.getSeriesForProcessing().getLabel().getInsets(), this.getChart().getUnits(), this.getContext().getUIServiceProvider());
        GridData gdICInsets = new GridData(768);
        gdICInsets.heightHint = this.icInsets.getPreferredSize().y;
        gdICInsets.grabExcessVerticalSpace = false;
        this.icInsets.setLayoutData(gdICInsets);
        this.icInsets.addListener(this);
        this.populateLists(this.getSeriesForProcessing());
        this.setEnabled(this.cbVisible.getSelection());
        this.refreshDataPointButtons();
        return this.cmpContent;
    }

    private void populateLists(Series series) {
        this.cmbComponentTypes.setItems(LiteralHelper.dataPointComponentTypeSet.getDisplayNames());
        this.cmbComponentTypes.select(0);
        this.lstComponents.setItems(this.getDataPointComponents(series.getDataPoint()));
        String str = series.getDataPoint().getPrefix();
        this.txtPrefix.setText(str == null ? "" : str);
        str = series.getDataPoint().getSuffix();
        this.txtSuffix.setText(str == null ? "" : str);
        str = series.getDataPoint().getSeparator();
        this.txtSeparator.setText(str == null ? "" : str);
        int positionScope = this.getSeriesForProcessing() instanceof PieSeries || this.getSeriesForProcessing() instanceof BarSeries ? 4 : 3;
        Position lpCurrent = this.getSeriesForProcessing().getLabelPosition();
        if (positionScope == 0) {
            this.cmbPosition.setItems(LiteralHelper.fullPositionSet.getDisplayNames());
            if (lpCurrent != null) {
                this.cmbPosition.select(LiteralHelper.fullPositionSet.getSafeNameIndex(lpCurrent.getName()));
            }
        } else {
            int i;
            String[] ns;
            if ((positionScope & 1) != 0) {
                ns = LiteralHelper.verticalPositionSet.getDisplayNames();
                for (i = 0; i < ns.length; ++i) {
                    this.cmbPosition.add(ns[i]);
                }
            }
            if ((positionScope & 2) != 0) {
                ns = LiteralHelper.horizontalPositionSet.getDisplayNames();
                for (i = 0; i < ns.length; ++i) {
                    this.cmbPosition.add(ns[i]);
                }
            }
            if ((positionScope & 4) != 0) {
                if (this.getSeriesForProcessing() instanceof BarSeries && this.getContext().getModel().getDimension() == ChartDimension.THREE_DIMENSIONAL_LITERAL) {
                    this.cmbPosition.add(LiteralHelper.inoutPositionSet.getDisplayNameByName(Position.OUTSIDE_LITERAL.getName()));
                } else {
                    ns = LiteralHelper.inoutPositionSet.getDisplayNames();
                    for (i = 0; i < ns.length; ++i) {
                        this.cmbPosition.add(ns[i]);
                    }
                }
            }
            if (lpCurrent != null) {
                for (int i2 = 0; i2 < this.cmbPosition.getItemCount(); ++i2) {
                    if (!lpCurrent.getName().equals(LiteralHelper.fullPositionSet.getNameByDisplayName(this.cmbPosition.getItem(i2)))) continue;
                    this.cmbPosition.select(i2);
                }
            }
        }
    }

    private String[] getDataPointComponents(DataPoint datapoint) {
        Object[] oArr = datapoint.getComponents().toArray();
        String[] sArr = new String[oArr.length];
        for (int i = 0; i < oArr.length; ++i) {
            sArr[i] = LiteralHelper.dataPointComponentTypeSet.getDisplayNameByName(((DataPointComponent)oArr[i]).getType().getName());
        }
        return sArr;
    }

    private void createAttributeArea(Composite parent) {
        this.grpAttributes = new Group(parent, 0);
        this.grpAttributes.setLayoutData((Object)new GridData(1808));
        this.grpAttributes.setLayout((Layout)new GridLayout(2, false));
        this.grpAttributes.setText(Messages.getString("SeriesLabelSheet.Label.Format"));
        this.lblPosition = new Label((Composite)this.grpAttributes, 0);
        GridData gdLBLPosition = new GridData();
        this.lblPosition.setLayoutData((Object)gdLBLPosition);
        this.lblPosition.setText(Messages.getString("LabelAttributesComposite.Lbl.Position"));
        this.cmbPosition = new Combo((Composite)this.grpAttributes, 12);
        GridData gdCMBPosition = new GridData(1808);
        this.cmbPosition.setLayoutData((Object)gdCMBPosition);
        this.cmbPosition.addSelectionListener((SelectionListener)this);
        this.lblFont = new Label((Composite)this.grpAttributes, 0);
        GridData gdLFont = new GridData();
        this.lblFont.setLayoutData((Object)gdLFont);
        this.lblFont.setText(Messages.getString("LabelAttributesComposite.Lbl.Font"));
        this.fdcFont = new FontDefinitionComposite((Composite)this.grpAttributes, 0, this.getContext(), this.getSeriesForProcessing().getLabel().getCaption().getFont(), this.getSeriesForProcessing().getLabel().getCaption().getColor(), false);
        GridData gdFDCFont = new GridData(1808);
        gdFDCFont.heightHint = this.fdcFont.getPreferredSize().y;
        gdFDCFont.widthHint = 96;
        gdFDCFont.grabExcessVerticalSpace = false;
        this.fdcFont.setLayoutData(gdFDCFont);
        this.fdcFont.addListener(this);
        this.lblFill = new Label((Composite)this.grpAttributes, 0);
        GridData gdLFill = new GridData();
        this.lblFill.setLayoutData((Object)gdLFill);
        this.lblFill.setText(Messages.getString("LabelAttributesComposite.Lbl.Background"));
        this.fccBackground = new FillChooserComposite((Composite)this.grpAttributes, 0, this.getContext(), this.getSeriesForProcessing().getLabel().getBackground(), false, false);
        GridData gdFCCBackground = new GridData(1808);
        gdFCCBackground.heightHint = this.fccBackground.getPreferredSize().y;
        this.fccBackground.setLayoutData(gdFCCBackground);
        this.fccBackground.addListener(this);
        this.lblShadow = new Label((Composite)this.grpAttributes, 0);
        GridData gdLBLShadow = new GridData();
        this.lblShadow.setLayoutData((Object)gdLBLShadow);
        this.lblShadow.setText(Messages.getString("LabelAttributesComposite.Lbl.Shadow"));
        this.fccShadow = new FillChooserComposite((Composite)this.grpAttributes, 0, this.getContext(), (Fill)this.getSeriesForProcessing().getLabel().getShadowColor(), false, false);
        GridData gdFCCShadow = new GridData(1808);
        this.fccShadow.setLayoutData(gdFCCShadow);
        this.fccShadow.addListener(this);
    }

    private void setEnabled(boolean bEnableUI) {
        this.grpOutline.setEnabled(bEnableUI);
        this.liacOutline.setEnabled(bEnableUI);
        this.icInsets.setEnabled(bEnableUI);
        this.grpAttributes.setEnabled(bEnableUI);
        this.lblPosition.setEnabled(bEnableUI);
        this.cmbPosition.setEnabled(bEnableUI);
        this.lblFont.setEnabled(bEnableUI);
        this.fdcFont.setEnabled(bEnableUI);
        this.lblFill.setEnabled(bEnableUI);
        this.fccBackground.setEnabled(bEnableUI);
        this.lblShadow.setEnabled(bEnableUI);
        this.fccShadow.setEnabled(bEnableUI);
        this.grpDataPoint.setEnabled(bEnableUI);
        this.lstComponents.setEnabled(bEnableUI);
        this.btnFormatSpecifier.setEnabled(bEnableUI);
        this.btnRemoveComponent.setEnabled(bEnableUI);
        this.btnAddComponent.setEnabled(bEnableUI);
        this.cmbComponentTypes.setEnabled(bEnableUI);
        this.lblPrefix.setEnabled(bEnableUI);
        this.lblSuffix.setEnabled(bEnableUI);
        this.lblSeparator.setEnabled(bEnableUI);
        this.txtPrefix.setEnabled(bEnableUI);
        this.txtSuffix.setEnabled(bEnableUI);
        this.txtSeparator.setEnabled(bEnableUI);
    }

    private void createDataPointArea(Composite parent) {
        this.grpDataPoint = new Group(parent, 0);
        GridData gdCMPDataPoint = new GridData(1808);
        gdCMPDataPoint.heightHint = 160;
        this.grpDataPoint.setLayoutData((Object)gdCMPDataPoint);
        GridLayout glCMPDataPoint = new GridLayout();
        glCMPDataPoint.numColumns = 4;
        glCMPDataPoint.horizontalSpacing = 4;
        glCMPDataPoint.marginHeight = 2;
        glCMPDataPoint.marginWidth = 2;
        this.grpDataPoint.setLayout((Layout)glCMPDataPoint);
        this.grpDataPoint.setText(Messages.getString("SeriesLabelSheet.Label.Values"));
        this.lstComponents = new List((Composite)this.grpDataPoint, 2052);
        GridData gdLSTComponents = new GridData(1808);
        gdLSTComponents.horizontalSpan = 4;
        this.lstComponents.setLayoutData((Object)gdLSTComponents);
        this.lstComponents.addSelectionListener((SelectionListener)this);
        this.btnFormatSpecifier = new Button((Composite)this.grpDataPoint, 8);
        GridData gdBTNFormatSpecifier = new GridData();
        this.btnFormatSpecifier.setLayoutData((Object)gdBTNFormatSpecifier);
        this.btnFormatSpecifier.setToolTipText(Messages.getString("Shared.Tooltip.FormatSpecifier"));
        this.btnFormatSpecifier.setImage(UIHelper.getImage((String)"icons/obj16/formatbuilder.gif"));
        this.btnFormatSpecifier.getImage().setBackground(this.btnFormatSpecifier.getBackground());
        this.btnFormatSpecifier.addSelectionListener((SelectionListener)this);
        this.btnRemoveComponent = new Button((Composite)this.grpDataPoint, 8);
        GridData gdBTNRemoveComponent = new GridData();
        this.btnRemoveComponent.setLayoutData((Object)gdBTNRemoveComponent);
        this.btnRemoveComponent.setText(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.Remove"));
        this.btnRemoveComponent.addSelectionListener((SelectionListener)this);
        this.btnAddComponent = new Button((Composite)this.grpDataPoint, 8);
        GridData gdBTNAddComponent = new GridData();
        this.btnAddComponent.setLayoutData((Object)gdBTNAddComponent);
        this.btnAddComponent.setText(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.Add"));
        this.btnAddComponent.addSelectionListener((SelectionListener)this);
        this.cmbComponentTypes = new Combo((Composite)this.grpDataPoint, 12);
        GridData gdCMBComponentTypes = new GridData(768);
        gdCMBComponentTypes.grabExcessHorizontalSpace = true;
        this.cmbComponentTypes.setLayoutData((Object)gdCMBComponentTypes);
        this.lblPrefix = new Label((Composite)this.grpDataPoint, 0);
        GridData gdLBLPrefix = new GridData();
        this.lblPrefix.setLayoutData((Object)gdLBLPrefix);
        this.lblPrefix.setText(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.Prefix"));
        this.txtPrefix = new TextEditorComposite((Composite)this.grpDataPoint, 2052);
        GridData gdTXTPrefix = new GridData(768);
        gdTXTPrefix.horizontalSpan = 3;
        this.txtPrefix.setLayoutData(gdTXTPrefix);
        this.txtPrefix.addListener(this);
        this.lblSuffix = new Label((Composite)this.grpDataPoint, 0);
        GridData gdLBLSuffix = new GridData();
        this.lblSuffix.setLayoutData((Object)gdLBLSuffix);
        this.lblSuffix.setText(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.Suffix"));
        this.txtSuffix = new TextEditorComposite((Composite)this.grpDataPoint, 2052);
        GridData gdTXTSuffix = new GridData(768);
        gdTXTSuffix.horizontalSpan = 3;
        this.txtSuffix.setLayoutData(gdTXTSuffix);
        this.txtSuffix.addListener(this);
        this.lblSeparator = new Label((Composite)this.grpDataPoint, 0);
        GridData gdLBLSeparator = new GridData();
        this.lblSeparator.setLayoutData((Object)gdLBLSeparator);
        this.lblSeparator.setText(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.Separator"));
        this.txtSeparator = new TextEditorComposite((Composite)this.grpDataPoint, 2052);
        GridData gdTXTSeparator = new GridData(768);
        gdTXTSeparator.horizontalSpan = 3;
        this.txtSeparator.setLayoutData(gdTXTSeparator);
        this.txtSeparator.addListener(this);
    }

    private Series getSeriesForProcessing() {
        return this.seriesDefn.getDesignTimeSeries();
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.fdcFont)) {
            this.getSeriesForProcessing().getLabel().getCaption().setFont((FontDefinition)((Object[])event.data)[0]);
            this.getSeriesForProcessing().getLabel().getCaption().setColor((ColorDefinition)((Object[])event.data)[1]);
        } else if (event.widget.equals((Object)this.liacOutline)) {
            switch (event.type) {
                case 1: {
                    this.getSeriesForProcessing().getLabel().getOutline().setStyle((LineStyle)event.data);
                    break;
                }
                case 2: {
                    this.getSeriesForProcessing().getLabel().getOutline().setThickness(((Integer)event.data).intValue());
                    break;
                }
                case 3: {
                    this.getSeriesForProcessing().getLabel().getOutline().setColor((ColorDefinition)event.data);
                    break;
                }
                case 4: {
                    this.getSeriesForProcessing().getLabel().getOutline().setVisible(((Boolean)event.data).booleanValue());
                }
            }
        } else if (event.widget.equals((Object)this.fccBackground)) {
            this.getSeriesForProcessing().getLabel().setBackground((Fill)event.data);
        } else if (event.widget.equals((Object)this.fccShadow)) {
            this.getSeriesForProcessing().getLabel().setShadowColor((ColorDefinition)event.data);
        } else if (event.widget.equals((Object)this.icInsets)) {
            this.getSeriesForProcessing().getLabel().setInsets((Insets)event.data);
        } else if (event.widget.equals((Object)this.txtPrefix)) {
            this.getSeriesForProcessing().getDataPoint().setPrefix(this.txtPrefix.getText());
        } else if (event.widget.equals((Object)this.txtSuffix)) {
            this.getSeriesForProcessing().getDataPoint().setSuffix(this.txtSuffix.getText());
        } else if (event.widget.equals((Object)this.txtSeparator)) {
            this.getSeriesForProcessing().getDataPoint().setSeparator(this.txtSeparator.getText());
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.cmbPosition)) {
            this.getSeriesForProcessing().setLabelPosition(Position.getByName((String)LiteralHelper.fullPositionSet.getNameByDisplayName(this.cmbPosition.getText())));
        } else if (e.getSource().equals(this.cbVisible)) {
            this.getSeriesForProcessing().getLabel().setVisible(this.cbVisible.getSelection());
            this.setEnabled(this.cbVisible.getSelection());
        } else if (e.getSource().equals(this.btnAddComponent)) {
            this.lstComponents.add(this.cmbComponentTypes.getText());
            this.addDataPointComponent(this.lstComponents.getItemCount() - 1);
            this.refreshDataPointButtons();
        } else if (e.getSource().equals(this.btnRemoveComponent)) {
            if (this.lstComponents.getSelectionCount() == 0) {
                return;
            }
            int iSelected = this.lstComponents.getSelectionIndices()[0];
            if (iSelected != -1) {
                this.removeDataPointComponent(iSelected);
                this.lstComponents.remove(iSelected);
            }
            this.refreshDataPointButtons();
        } else if (e.getSource().equals(this.btnFormatSpecifier)) {
            if (this.lstComponents.getSelectionCount() == 0) {
                return;
            }
            int iSelected = this.lstComponents.getSelectionIndices()[0];
            if (iSelected != -1) {
                this.setDataPointComponentFormatSpecifier(iSelected);
            }
        } else if (e.getSource().equals(this.lstComponents)) {
            this.refreshDataPointButtons();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void refreshDataPointButtons() {
        this.btnFormatSpecifier.setEnabled(this.lstComponents.getSelectionIndex() != -1);
        this.btnRemoveComponent.setEnabled(this.lstComponents.getSelectionIndex() != -1);
    }

    private void addDataPointComponent(int iComponentIndex) {
        DataPoint dp = this.getSeriesForProcessing().getDataPoint();
        DataPointComponentType dpct = DataPointComponentType.getByName((String)LiteralHelper.dataPointComponentTypeSet.getNameByDisplayName(this.lstComponents.getItem(iComponentIndex)));
        DataPointComponent dpc = DataPointComponentImpl.create((DataPointComponentType)dpct, null);
        if (dpct == DataPointComponentType.PERCENTILE_ORTHOGONAL_VALUE_LITERAL) {
            JavaNumberFormatSpecifier fs = JavaNumberFormatSpecifierImpl.create((String)"##.##%");
            dpc.setFormatSpecifier((FormatSpecifier)fs);
        }
        dpc.eAdapters().addAll((Collection)dp.eAdapters());
        dp.getComponents().add((Object)dpc);
    }

    private void setDataPointComponentFormatSpecifier(int iComponentIndex) {
        FormatSpecifierDialog editor;
        DataPointComponent dpc = (DataPointComponent)this.getSeriesForProcessing().getDataPoint().getComponents().get(iComponentIndex);
        FormatSpecifier formatspecifier = dpc.getFormatSpecifier();
        String sContext = new MessageFormat(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.SeriesDataPointComponent")).format(new Object[]{dpc.getType().getName()});
        if (sContext == null) {
            sContext = Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.SeriesDataPoint");
        }
        if (!(editor = new FormatSpecifierDialog(this.cmpContent.getShell(), formatspecifier, sContext)).wasCancelled()) {
            if (editor.getFormatSpecifier() == null) {
                dpc.eUnset((EStructuralFeature)AttributePackage.eINSTANCE.getDataPointComponent_FormatSpecifier());
                return;
            }
            dpc.setFormatSpecifier(editor.getFormatSpecifier());
        }
    }

    private void removeDataPointComponent(int iComponentIndex) {
        this.getSeriesForProcessing().getDataPoint().getComponents().remove(iComponentIndex);
    }
}

