/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.internal;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IMessageLookup;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartBuilderMessageLookup;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;

public class ChartPreviewPainter
implements PaintListener,
ControlListener {
    private transient Canvas preview = null;
    private transient Chart chart = null;
    private transient boolean bIsPainting = false;
    private static transient boolean enableProcessor = true;
    private static transient boolean isLivePreview = false;
    private transient Image buffer;
    private transient ChartWizardContext wizardContext;
    private static int X_OFFSET = 3;
    private static int Y_OFFSET = 3;

    public ChartPreviewPainter(ChartWizardContext wizardContext) {
        this.wizardContext = wizardContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateBuffer() {
        Image oldBuffer;
        Exception paintError;
        block17: {
            if (this.bIsPainting) {
                return;
            }
            paintError = null;
            if (this.chart == null) {
                return;
            }
            Rectangle re = this.preview.getClientArea();
            Rectangle adjustedRe = new Rectangle(0, 0, re.width, re.height);
            if (adjustedRe.width - 2 * X_OFFSET <= 0 || adjustedRe.height - 2 * Y_OFFSET <= 0) {
                if (this.buffer != null && !this.buffer.isDisposed()) {
                    this.buffer.dispose();
                    this.buffer = null;
                }
                return;
            }
            this.bIsPainting = true;
            oldBuffer = null;
            if (this.buffer == null) {
                this.buffer = new Image((Device)Display.getDefault(), adjustedRe);
            } else {
                Rectangle ore = this.buffer.getBounds();
                oldBuffer = this.buffer;
                if (!adjustedRe.equals((Object)ore)) {
                    this.buffer = new Image((Device)Display.getDefault(), adjustedRe);
                }
            }
            GC gc = new GC((Drawable)this.buffer);
            gc.setForeground(Display.getDefault().getSystemColor(1));
            gc.fillRectangle(this.buffer.getBounds());
            Bounds bo = BoundsImpl.create((double)X_OFFSET, (double)Y_OFFSET, (double)(adjustedRe.width - 2 * X_OFFSET), (double)(adjustedRe.height - 2 * Y_OFFSET));
            IDeviceRenderer deviceRenderer = null;
            try {
                try {
                    deviceRenderer = PluginSettings.instance().getDevice("dv.SWT");
                    deviceRenderer.setProperty("device.output.context", (Object)gc);
                    bo.scale(72.0 / (double)deviceRenderer.getDisplayServer().getDpiResolution());
                    Generator gr = Generator.instance();
                    RunTimeContext rtc = new RunTimeContext();
                    rtc.setScriptingEnabled(false);
                    rtc.setMessageLookup((IMessageLookup)new ChartBuilderMessageLookup(this.wizardContext.getUIServiceProvider()));
                    if (this.wizardContext.isRtL()) {
                        rtc.setRightToLeft(true);
                    }
                    GeneratedChartState state = gr.build(deviceRenderer.getDisplayServer(), this.chart, bo, null, rtc, enableProcessor ? this.wizardContext.getProcessor() : null);
                    gr.render(deviceRenderer, state);
                }
                catch (Exception ex) {
                    paintError = ex;
                    Object var12_13 = null;
                    gc.dispose();
                    if (deviceRenderer != null) {
                        deviceRenderer.dispose();
                    }
                    break block17;
                }
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                gc.dispose();
                if (deviceRenderer != null) {
                    deviceRenderer.dispose();
                }
                throw throwable;
            }
            gc.dispose();
            if (deviceRenderer != null) {
                deviceRenderer.dispose();
            }
        }
        if (paintError != null) {
            this.buffer = oldBuffer;
            WizardBase.displayException((Throwable)paintError);
        }
        if (oldBuffer != null && oldBuffer != this.buffer) {
            oldBuffer.dispose();
        }
        this.bIsPainting = false;
    }

    protected final void showException(GC g2d, Throwable ex) {
        String sWrappedException = ex.getClass().getName();
        Throwable th = ex;
        while (ex.getCause() != null) {
            ex = ex.getCause();
        }
        String sException = ex.getClass().getName();
        if (sWrappedException.equals(sException)) {
            sWrappedException = null;
        }
        String sMessage = null;
        sMessage = th instanceof BirtException ? ((BirtException)th).getLocalizedMessage() : ex.getMessage();
        if (sMessage == null) {
            sMessage = "<null>";
        }
        StackTraceElement[] stea = ex.getStackTrace();
        Rectangle rCA = this.preview.getClientArea();
        Display dv = Display.getCurrent();
        Font fo = new Font((Device)dv, "Courier", 1, 16);
        g2d.setFont(fo);
        FontMetrics fm = g2d.getFontMetrics();
        g2d.setBackground(dv.getSystemColor(1));
        g2d.fillRectangle(20, 20, rCA.width - 40, rCA.height - 40);
        g2d.setForeground(dv.getSystemColor(2));
        g2d.drawRectangle(20, 20, rCA.width - 40, rCA.height - 40);
        g2d.setClipping(20, 20, rCA.width - 40, rCA.height - 40);
        int x = 25;
        int y = 20 + fm.getHeight();
        ChartPreviewPainter.drawString(g2d, Messages.getString((String)"ChartAdapter.Exception.Exception"), x, y);
        g2d.setForeground(dv.getSystemColor(3));
        ChartPreviewPainter.drawString(g2d, sException, x += g2d.textExtent((String)Messages.getString((String)"ChartAdapter.Exception.Exception")).x + 5, y);
        x = 25;
        y += fm.getHeight();
        if (sWrappedException != null) {
            g2d.setForeground(dv.getSystemColor(2));
            ChartPreviewPainter.drawString(g2d, Messages.getString((String)"ChartAdapter.Exception.WrappedIn"), x, y);
            g2d.setForeground(dv.getSystemColor(3));
            ChartPreviewPainter.drawString(g2d, sWrappedException, x += g2d.textExtent((String)Messages.getString((String)"ChartAdapter.Exception.WrappedIn")).x + 5, y);
            x = 25;
            y += fm.getHeight();
        }
        g2d.setForeground(dv.getSystemColor(2));
        ChartPreviewPainter.drawString(g2d, Messages.getString((String)"ChartAdapter.Exception.Message"), x, y += 10);
        g2d.setForeground(dv.getSystemColor(9));
        ChartPreviewPainter.drawString(g2d, sMessage, x += g2d.textExtent((String)Messages.getString((String)"ChartAdapter.Exception.Message")).x + 5, y);
        x = 25;
        y += fm.getHeight();
        g2d.setForeground(dv.getSystemColor(2));
        ChartPreviewPainter.drawString(g2d, Messages.getString((String)"ChartAdapter.Exception.Trace"), x, y += 10);
        x = 40;
        y += fm.getHeight();
        g2d.setForeground(dv.getSystemColor(6));
        if (stea == null) {
            ChartPreviewPainter.drawString(g2d, "<null stack trace>", x, y);
        } else {
            for (int i = 0; i < stea.length; ++i) {
                ChartPreviewPainter.drawString(g2d, stea[i].getClassName() + ":" + stea[i].getMethodName() + "(...):" + stea[i].getLineNumber(), x, y);
                x = 40;
                y += fm.getHeight();
            }
        }
        fo.dispose();
    }

    public void paintControl(PaintEvent pev) {
        GC gc = pev.gc;
        if (this.buffer != null) {
            gc.drawImage(this.buffer, 0, 0);
        }
    }

    private static final void drawString(GC gc, String s, int x, int y) {
        if (s == null) {
            s = "<null>";
        }
        gc.drawString(s, x, y);
    }

    public void setPreview(Canvas previewCanvas) {
        this.preview = previewCanvas;
    }

    public void renderModel(Chart chart) {
        if (chart == null) {
            return;
        }
        this.chart = chart;
        this.ignoreNotifications(true);
        if (!isLivePreview || !this.isLivePreviewEnabled()) {
            chart.createSampleRuntimeSeries();
        }
        if (this.preview != null && !this.preview.isDisposed()) {
            this.updateBuffer();
            this.preview.redraw();
        }
        this.ignoreNotifications(false);
    }

    private void ignoreNotifications(boolean bIgnoreNotifications) {
        ChartAdapter.ignoreNotifications((boolean)bIgnoreNotifications);
    }

    public static void enableProcessor(boolean isEnabled) {
        enableProcessor = isEnabled;
    }

    public static boolean isProcessorEnabled() {
        return enableProcessor;
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        if (this.preview != null && !this.preview.isDisposed()) {
            this.updateBuffer();
            this.preview.redraw();
        }
    }

    public void dispose() {
        isLivePreview = false;
        if (this.buffer != null) {
            this.buffer.dispose();
        }
    }

    public static boolean isLivePreviewActive() {
        return isLivePreview;
    }

    public static void activateLivePreview(boolean canLive) {
        isLivePreview = canLive;
    }

    private boolean isLivePreviewEnabled() {
        return this.wizardContext.getDataServiceProvider().isLivePreviewEnabled();
    }
}

