/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ConnectionProfilePropertySource
implements IPropertySource {
    private static final String P_ID_ENTITY_NAME = "org.eclipse.datatools.connectivity.properties.general.cpname";
    private static final String P_ID_ENTITY_DESC = "org.eclipse.datatools.connectivity.properties.general.cpdesc";
    private static final String P_ID_ENTITY_AUTOCONNECT = "org.eclipse.datatools.connectivity.properties.general.cpautoconnect";
    private IConnectionProfile mCP;
    private boolean _showAutoConnect = true;

    public ConnectionProfilePropertySource(IConnectionProfile cp) {
        this.mCP = cp;
        this._showAutoConnect = this.mCP.getProvider().needsMaintainConnection();
    }

    public Object getEditableValue() {
        return this.mCP;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor desName = new PropertyDescriptor((Object)P_ID_ENTITY_NAME, ConnectivityUIPlugin.getDefault().getResourceString("properties.connectionprofile.name"));
        desName.setCategory(ConnectivityUIPlugin.getDefault().getResourceString("properties.category.general"));
        PropertyDescriptor desType = new PropertyDescriptor((Object)P_ID_ENTITY_DESC, ConnectivityUIPlugin.getDefault().getResourceString("properties.connectionprofile.desc"));
        desType.setCategory(ConnectivityUIPlugin.getDefault().getResourceString("properties.category.general"));
        if (!this._showAutoConnect) {
            return new IPropertyDescriptor[]{desName, desType};
        }
        PropertyDescriptor autoConnectType = new PropertyDescriptor((Object)P_ID_ENTITY_AUTOCONNECT, ConnectivityUIPlugin.getDefault().getResourceString("properties.connectionprofile.autoconnect"));
        autoConnectType.setCategory(ConnectivityUIPlugin.getDefault().getResourceString("properties.category.general"));
        return new IPropertyDescriptor[]{desName, desType, autoConnectType};
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(P_ID_ENTITY_NAME)) {
            return this.mCP.getName();
        }
        if (id.equals(P_ID_ENTITY_DESC)) {
            return this.mCP.getDescription();
        }
        if (id.equals(P_ID_ENTITY_AUTOCONNECT)) {
            if (!this._showAutoConnect) {
                return new Boolean(true);
            }
            return new Boolean(this.mCP.isAutoConnect());
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

