/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.preferences;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.DriverValidator;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.PropertySetImpl;
import org.eclipse.datatools.connectivity.drivers.XMLFileManager;
import org.eclipse.datatools.connectivity.drivers.models.CategoryDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.DriversProvider;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.DriverTreeContentProvider;
import org.eclipse.datatools.connectivity.internal.ui.DriverTreeLabelProvider;
import org.eclipse.datatools.connectivity.internal.ui.DriverTreeSorter;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.EditDriverDialog;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.NewDriverDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DriverPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button mAddButton;
    private Button mRemoveButton;
    private Button mEditButton;
    private Button mCopyButton;
    private Label mErrorLabel;
    private TreeViewer mTreeViewer;
    private Action mAddAction;
    private Action mRemoveAction;
    private Action mEditAction;
    private Action mCopyAction;
    private boolean mDirty = false;

    public DriverPreferences() {
    }

    public DriverPreferences(String title) {
        super(title);
    }

    public DriverPreferences(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        content.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        content.setLayoutData((Object)data);
        content.setFont(font);
        Label label = new Label(content, 16384);
        label.setText(DriverMgmtMessages.getString((String)"DriverPreferences.label.availableDrivers"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.mErrorLabel = new Label(content, 16448);
        data = new GridData(272);
        data.horizontalSpan = 2;
        data.heightHint = 35;
        this.mErrorLabel.setLayoutData((Object)data);
        this.mErrorLabel.setForeground(JFaceColors.getErrorText((Display)this.getControl().getDisplay()));
        this.mErrorLabel.setFont(font);
        this.mTreeViewer = new TreeViewer(content, 2816);
        data = new GridData(1808);
        data.verticalSpan = 10;
        this.mTreeViewer.getTree().setLayoutData((Object)data);
        this.mTreeViewer.getTree().setFont(font);
        this.makeActions();
        this.hookContextMenu();
        this.mTreeViewer.setContentProvider((IContentProvider)new DriverTreeContentProvider());
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new DriverTreeLabelProvider(), (ILabelDecorator)new DriverTreeLabelProvider()));
        this.mTreeViewer.setSorter((ViewerSorter)new DriverTreeSorter());
        this.mTreeViewer.setInput((Object)DriversProvider.getInstance());
        this.mTreeViewer.expandToLevel(3);
        this.mTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)DriverPreferences.this.mTreeViewer.getSelection();
                if (selection != null && selection.size() > 0 && selection.getFirstElement() != null) {
                    DriverPreferences.this.updateButtons(selection.getFirstElement());
                } else {
                    DriverPreferences.this.updateButtons(null);
                }
            }
        });
        this.mTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)DriverPreferences.this.mTreeViewer.getSelection();
                DriverPreferences.this.editDriver((ISelection)selection);
            }
        });
        Composite groupComponent = new Composite(content, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupComponent.setLayout((Layout)groupLayout);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        groupComponent.setFont(font);
        this.mAddButton = new Button(groupComponent, 8);
        this.mAddButton.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.addDriver"));
        this.mAddButton.setLayoutData((Object)data);
        this.mAddButton.setFont(font);
        this.setButtonLayoutData(this.mAddButton);
        this.mAddButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DriverPreferences.this.addDriver(DriverPreferences.this.mTreeViewer.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.mEditButton = new Button(content, 8);
        this.mEditButton.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.editDriver"));
        this.mEditButton.setLayoutData((Object)data);
        this.mEditButton.setFont(font);
        this.setButtonLayoutData(this.mEditButton);
        this.mEditButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DriverPreferences.this.editDriver(DriverPreferences.this.mTreeViewer.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.mRemoveButton = new Button(content, 8);
        this.mRemoveButton.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.removeDriver"));
        this.mRemoveButton.setLayoutData((Object)data);
        this.mRemoveButton.setFont(font);
        this.setButtonLayoutData(this.mRemoveButton);
        this.mRemoveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DriverPreferences.this.removeDriver(DriverPreferences.this.mTreeViewer.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.mCopyButton = new Button(content, 8);
        this.mCopyButton.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.copyDriver"));
        this.mCopyButton.setLayoutData((Object)data);
        this.mCopyButton.setFont(font);
        this.setButtonLayoutData(this.mCopyButton);
        this.mCopyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DriverPreferences.this.copyDriver(DriverPreferences.this.mTreeViewer.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        if (CategoryDescriptor.getRootCategories() != null && CategoryDescriptor.getRootCategories().length > 0) {
            this.mTreeViewer.setSelection((ISelection)new StructuredSelection((Object)CategoryDescriptor.getRootCategories()[0]));
        }
        this.updateButtons(null);
        return content;
    }

    private void updateButtons(Object selection) {
        if (selection instanceof CategoryDescriptor) {
            this.mAddButton.setEnabled(true);
            this.mAddAction.setEnabled(true);
            this.mRemoveButton.setEnabled(false);
            this.mRemoveAction.setEnabled(false);
            this.mEditButton.setEnabled(false);
            this.mEditAction.setEnabled(false);
            this.mCopyButton.setEnabled(false);
            this.mCopyAction.setEnabled(false);
            this.mErrorLabel.setText("");
            this.mErrorLabel.computeSize(-1, -1);
        } else if (selection instanceof IPropertySet) {
            this.mAddButton.setEnabled(false);
            this.mAddAction.setEnabled(false);
            this.mRemoveButton.setEnabled(true);
            this.mRemoveAction.setEnabled(true);
            this.mEditButton.setEnabled(true);
            this.mEditAction.setEnabled(true);
            this.mCopyButton.setEnabled(true);
            this.mCopyAction.setEnabled(true);
            IPropertySet ps = (IPropertySet)selection;
            if (ps != null) {
                this.validate(ps);
            }
        } else {
            this.mAddButton.setEnabled(false);
            this.mAddAction.setEnabled(false);
            this.mRemoveButton.setEnabled(false);
            this.mRemoveAction.setEnabled(false);
            this.mEditButton.setEnabled(false);
            this.mEditAction.setEnabled(false);
            this.mCopyButton.setEnabled(false);
            this.mCopyAction.setEnabled(false);
        }
    }

    private void addDriver(ISelection selection) {
        StructuredSelection sselection = (StructuredSelection)selection;
        if (sselection.getFirstElement() instanceof CategoryDescriptor) {
            CategoryDescriptor descriptor = (CategoryDescriptor)sselection.getFirstElement();
            NewDriverDialog dlg = new NewDriverDialog(this.getShell(), descriptor.getId());
            if (dlg.open() == 0) {
                IPropertySet instance = dlg.getNewDriverInstance();
                this.mDirty = true;
                if (dlg.getEditImmediately()) {
                    EditDriverDialog editdlg = new EditDriverDialog(this.getShell(), instance);
                    editdlg.open();
                }
                List psetsList = ((DriverTreeContentProvider)this.mTreeViewer.getContentProvider()).getDriverInstances();
                psetsList.add(instance);
                this.saveChanges();
                this.mTreeViewer.refresh();
            }
        }
    }

    private void editDriver(ISelection selection) {
        StructuredSelection sselection = (StructuredSelection)selection;
        if (sselection.getFirstElement() instanceof IPropertySet) {
            IPropertySet instance = (IPropertySet)sselection.getFirstElement();
            EditDriverDialog dlg = new EditDriverDialog(this.getShell(), instance);
            if (dlg.open() == 0) {
                this.saveChanges();
                this.mDirty = true;
                this.mTreeViewer.refresh();
                this.validate(instance);
            }
        }
    }

    private void removeDriver(ISelection selection) {
        StructuredSelection sselection = (StructuredSelection)selection;
        if (sselection.getFirstElement() instanceof IPropertySet) {
            IPropertySet instance = (IPropertySet)sselection.getFirstElement();
            if (MessageDialog.openQuestion((Shell)this.getShell(), (String)DriverMgmtMessages.getString((String)"DriverPreferences.title.removeMessage"), (String)DriverMgmtMessages.format((String)"DriverPreferences.text.removeMessage", (Object[])new String[]{instance.getName()}))) {
                List psetsList = ((DriverTreeContentProvider)this.mTreeViewer.getContentProvider()).getDriverInstances();
                psetsList.remove(instance);
                this.saveChanges();
                CategoryDescriptor category = this.getCategoryFromPropertySet(instance);
                this.mTreeViewer.refresh((Object)category);
                this.mDirty = true;
                this.mErrorLabel.setText("");
            }
        }
    }

    private void copyDriver(ISelection selection) {
        IPropertySet instance;
        StructuredSelection sselection = (StructuredSelection)selection;
        if (sselection.getFirstElement() instanceof IPropertySet && (instance = (IPropertySet)sselection.getFirstElement()) != null) {
            IPropertySet cloned = (IPropertySet)((PropertySetImpl)instance).clone();
            String copyPrefix = DriverMgmtMessages.getString((String)"PropertySetImpl.copy_prefix");
            String copyIdSuffix = DriverMgmtMessages.getString((String)"PropertySetImpl.copy_id_suffix");
            String name = copyPrefix + instance.getName();
            String id = instance.getID() + copyIdSuffix;
            cloned.setID(id);
            cloned.setName(name);
            List psetsList = ((DriverTreeContentProvider)this.mTreeViewer.getContentProvider()).getDriverInstances();
            psetsList.add(cloned);
            this.saveChanges();
            this.mTreeViewer.refresh();
            this.mTreeViewer.setSelection((ISelection)new StructuredSelection((Object)cloned));
        }
    }

    private void makeActions() {
        this.mAddAction = new AddAction();
        this.mAddAction.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.addDriver"));
        this.mEditAction = new EditAction();
        this.mEditAction.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.editDriver"));
        this.mRemoveAction = new RemoveAction();
        this.mRemoveAction.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.removeDriver"));
        this.mCopyAction = new CopyAction();
        this.mCopyAction.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.copyDriver"));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)DriverPreferences.this.mAddAction);
                manager.add((IAction)DriverPreferences.this.mEditAction);
                manager.add((IAction)DriverPreferences.this.mRemoveAction);
                manager.add((IAction)DriverPreferences.this.mCopyAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.mTreeViewer.getControl());
        this.mTreeViewer.getControl().setMenu(menu);
    }

    private void validate(IPropertySet instance) {
        TemplateDescriptor template;
        String driverType = instance.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType");
        if (driverType != null && (template = TemplateDescriptor.getDriverTemplateDescriptor((String)driverType)) != null) {
            DriverValidator validator = new DriverValidator(template, instance);
            String mErrorMessage = "";
            if (!validator.isValid()) {
                mErrorMessage = validator.getMessage();
            }
            this.mErrorLabel.setText(mErrorMessage);
            this.mErrorLabel.computeSize(-1, -1);
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        if (this.mDirty) {
            this.saveChanges();
        }
        super.performApply();
    }

    private void saveChanges() {
        XMLFileManager.setFileName((String)"driverStorage.xml");
        List psetsList = ((DriverTreeContentProvider)this.mTreeViewer.getContentProvider()).getDriverInstances();
        Object[] objs = psetsList.toArray();
        IPropertySet[] propsets = new IPropertySet[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            propsets[i] = (IPropertySet)objs[i];
        }
        try {
            XMLFileManager.saveNamedPropertySet((IPropertySet[])propsets);
        }
        catch (CoreException e) {
            ConnectivityUIPlugin.getDefault().log(e);
        }
        this.mDirty = false;
    }

    public boolean performOk() {
        if (this.mDirty) {
            this.saveChanges();
        }
        return super.performOk();
    }

    private CategoryDescriptor getCategoryFromPropertySet(IPropertySet instance) {
        String driverType;
        TemplateDescriptor descriptor;
        if (instance != null && instance.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType") != null && (descriptor = TemplateDescriptor.getDriverTemplateDescriptor((String)(driverType = instance.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType")))) != null) {
            CategoryDescriptor category = CategoryDescriptor.getCategoryDescriptor((String)descriptor.getParentCategory());
            return category;
        }
        return null;
    }

    private class CopyAction
    extends Action {
        private CopyAction() {
        }

        public void run() {
            DriverPreferences.this.copyDriver(DriverPreferences.this.mTreeViewer.getSelection());
        }
    }

    private class EditAction
    extends Action {
        private EditAction() {
        }

        public void run() {
            DriverPreferences.this.editDriver(DriverPreferences.this.mTreeViewer.getSelection());
        }
    }

    private class RemoveAction
    extends Action {
        private RemoveAction() {
        }

        public void run() {
            DriverPreferences.this.removeDriver(DriverPreferences.this.mTreeViewer.getSelection());
        }
    }

    private class AddAction
    extends Action {
        private AddAction() {
        }

        public void run() {
            DriverPreferences.this.addDriver(DriverPreferences.this.mTreeViewer.getSelection());
        }
    }
}

