/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.wizards;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class ProfilePropertyPage
extends PropertyPage {
    private boolean mAffectsConnectionProperties;

    protected ProfilePropertyPage() {
        this(false);
    }

    protected ProfilePropertyPage(boolean affectsConnectionProperties) {
        this.mAffectsConnectionProperties = affectsConnectionProperties;
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        container.setLayout((Layout)gridLayout);
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createCustomContents(composite);
        return container;
    }

    protected abstract void createCustomContents(Composite var1);

    protected abstract Properties collectProperties();

    protected IConnectionProfile getConnectionProfile() {
        IAdaptable element = this.getElement();
        IConnectionProfile profile = (IConnectionProfile)element.getAdapter(IConnectionProfile.class);
        return profile;
    }

    public boolean performOk() {
        IConnectionProfile profile = this.getConnectionProfile();
        Properties oldProps = profile.getBaseProperties();
        Properties newProps = this.collectProperties();
        boolean changed = false;
        Iterator<Object> itr = newProps.keySet().iterator();
        while (!changed && itr.hasNext()) {
            Object key = itr.next();
            Object oldObj = oldProps.get(key);
            Object newObj = newProps.get(key);
            changed = newObj != null && !newObj.equals(oldObj) || newObj == null && oldObj != null;
        }
        if (changed) {
            oldProps.putAll((Map<?, ?>)newProps);
            profile.setBaseProperties(oldProps);
            if (this.mAffectsConnectionProperties && profile.isConnected() && MessageDialog.openQuestion((Shell)this.getShell(), (String)ConnectivityUIPlugin.getDefault().getResourceString("ConnectionProfileDetailsPage.AskConfirmation"), (String)ConnectivityUIPlugin.getDefault().getResourceString("ConnectionProfileDetailsPage.AskReconnect"))) {
                profile.disconnect(null);
                profile.connect(null);
            }
        }
        return super.performOk();
    }
}

