/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.adapter.dtp;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.IBundle;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.data.oda.IDriver;
import org.eclipse.birt.data.oda.LogConfiguration;
import org.eclipse.birt.data.oda.OdaException;
import org.eclipse.birt.data.oda.adapter.dtp.Connection;
import org.eclipse.birt.data.oda.adapter.dtp.OdaAdapterException;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.JavaRuntimeInterface;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.RuntimeInterface;

public class Driver
implements org.eclipse.datatools.connectivity.oda.IDriver {
    private IDriver m_birtDriver = null;
    private LogConfiguration m_birtLogConfig = null;
    private static final String sm_className;
    private static final String sm_packageName;
    private static Logger sm_logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IConnection getConnection(String dataSourceId) throws org.eclipse.datatools.connectivity.oda.OdaException {
        if (this.m_birtDriver == null) {
            this.m_birtDriver = this.newBirtDriver(dataSourceId);
            this.doSetLogConfiguration();
        }
        try {
            return new Connection(this.m_birtDriver.getConnection(dataSourceId));
        }
        catch (OdaException e) {
            throw new OdaAdapterException(e);
        }
    }

    private IDriver newBirtDriver(String dataSourceId) throws org.eclipse.datatools.connectivity.oda.OdaException {
        try {
            ExtensionManifest manifest = ManifestExplorer.getInstance().getExtensionManifest(dataSourceId, "org.eclipse.birt.data.oda.dataSource");
            RuntimeInterface runtime = manifest.getRuntimeInterface();
            if (!$assertionsDisabled && !(runtime instanceof JavaRuntimeInterface)) {
                throw new AssertionError();
            }
            JavaRuntimeInterface javaRuntime = (JavaRuntimeInterface)runtime;
            String driverClassName = javaRuntime.getDriverClass();
            IBundle bundle = Platform.getBundle((String)manifest.getNamespace());
            Class driverClass = bundle.loadClass(driverClassName);
            Object driverInstance = driverClass.newInstance();
            if (driverInstance instanceof IDriver) {
                return (IDriver)driverInstance;
            }
            throw new IllegalArgumentException(driverClassName);
        }
        catch (Exception ex) {
            String errorMsg = "Not able to instantiate custom BIRT ODA driver class.";
            sm_logger.logp(Level.SEVERE, sm_className, "newBirtDriver", "Not able to instantiate custom BIRT ODA driver class.");
            throw new OdaAdapterException("Not able to instantiate custom BIRT ODA driver class.", ex);
        }
    }

    public int getMaxConnections() throws org.eclipse.datatools.connectivity.oda.OdaException {
        if (this.m_birtDriver == null) {
            sm_logger.logp(Level.WARNING, sm_className, "getMaxConnections", "Unknown underlying BIRT driver- unknown maximum connections.");
            return 0;
        }
        try {
            return this.m_birtDriver.getMaxConnections();
        }
        catch (OdaException e) {
            throw new OdaAdapterException(e);
        }
    }

    public void setAppContext(Object context) throws org.eclipse.datatools.connectivity.oda.OdaException {
    }

    public void setLogConfiguration(org.eclipse.datatools.connectivity.oda.LogConfiguration logConfig) throws org.eclipse.datatools.connectivity.oda.OdaException {
        this.m_birtLogConfig = new LogConfiguration(logConfig.getDataSourceId(), logConfig.getLogLevel(), logConfig.getLogDirectory(), logConfig.getLogPrefix(), logConfig.getFormatterClassName());
        this.doSetLogConfiguration();
    }

    private void doSetLogConfiguration() throws org.eclipse.datatools.connectivity.oda.OdaException {
        if (this.m_birtDriver == null || this.m_birtLogConfig == null) {
            sm_logger.logp(Level.INFO, sm_className, "doSetLogConfiguration", "Un-initialized BIRT driver, or no log configuration to pass through.");
            return;
        }
        LogConfiguration logConfig = this.m_birtLogConfig;
        this.m_birtLogConfig = null;
        try {
            this.m_birtDriver.setLogConfiguration(logConfig);
        }
        catch (OdaException e) {
            throw new OdaAdapterException(e);
        }
    }

    static {
        $assertionsDisabled = !Driver.class.desiredAssertionStatus();
        sm_className = Driver.class.getName();
        sm_packageName = Driver.class.getPackage().getName();
        sm_logger = Logger.getLogger(sm_packageName);
    }
}

