/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.svg;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.device.IUpdateNotifier;
import org.eclipse.birt.chart.device.svg.CacheEvent;
import org.eclipse.birt.chart.device.svg.SVGGraphics2D;
import org.eclipse.birt.chart.device.svg.i18n.Messages;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.AccessibilityValue;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.ScriptValue;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.emf.common.util.EList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGInteractiveRenderer {
    private Map labelPrimitives = new Hashtable();
    private List scripts = new Vector();
    protected Element hotspotLayer;
    private Map componentPrimitives = new Hashtable();
    private IUpdateNotifier _iun;
    private static ILogger logger;
    SVGGraphics2D svg_g2d;
    private ULocale locale;
    private List cacheEvents = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public SVGInteractiveRenderer(ULocale locale) {
        this.locale = locale == null ? ULocale.getDefault() : locale;
    }

    public void setIUpdateNotifier(IUpdateNotifier iun) {
        this._iun = iun;
    }

    public void setSVG2D(SVGGraphics2D svg2D) {
        this.svg_g2d = svg2D;
    }

    protected void groupPrimitive(PrimitiveRenderEvent pre, boolean drawText) {
        if (this._iun == null) {
            logger.log(2, Messages.getString("exception.missing.component.interaction", this.getULocale()));
            return;
        }
        if (pre.getSource() instanceof StructureSource) {
            StructureSource sourceObject = (StructureSource)pre.getSource();
            Series seDT = (Series)this.getElementFromSource(sourceObject, StructureType.SERIES);
            if (seDT != null) {
                String id;
                String groupIdentifier = null;
                try {
                    if (this.isColoredByCategories() && this.getElementFromSource(sourceObject, StructureType.SERIES_DATA_POINT) != null) {
                        seDT = this.findCategorySeries(seDT);
                        groupIdentifier = String.valueOf(seDT.hashCode());
                        DataPointHints dph = (DataPointHints)this.getElementFromSource(sourceObject, StructureType.SERIES_DATA_POINT);
                        groupIdentifier = groupIdentifier + "index";
                        groupIdentifier = groupIdentifier + dph.getIndex();
                    } else {
                        seDT = this.findDesignTimeSeries(seDT);
                        groupIdentifier = String.valueOf(seDT.hashCode());
                    }
                }
                catch (ChartException e) {
                    logger.log((Exception)((Object)e));
                    return;
                }
                if (drawText) {
                    id = Integer.toString(pre.hashCode());
                    ArrayList<String> components = (ArrayList<String>)this.labelPrimitives.get(seDT);
                    if (components == null) {
                        components = new ArrayList<String>();
                        this.labelPrimitives.put(seDT, components);
                    }
                    components.add(id);
                    Element outerGroup = this.svg_g2d.createElement("g");
                    this.svg_g2d.pushParent(outerGroup);
                    Element primGroup = this.svg_g2d.createElement("g");
                    outerGroup.appendChild(primGroup);
                    this.svg_g2d.pushParent(primGroup);
                    primGroup.setAttribute("id", groupIdentifier + "_" + id);
                    primGroup.setAttribute("style", "visibility:visible;");
                    outerGroup.setAttribute("id", groupIdentifier + "_" + id + "_g");
                    outerGroup.setAttribute("style", "visibility:visible;");
                } else {
                    id = Integer.toString(pre.hashCode());
                    ArrayList<String> components = (ArrayList<String>)this.componentPrimitives.get(seDT);
                    if (components == null) {
                        components = new ArrayList<String>();
                        this.componentPrimitives.put(seDT, components);
                    }
                    String idTemp = id;
                    int counter = 1;
                    while (components.contains(idTemp)) {
                        idTemp = id + "@" + counter;
                        ++counter;
                    }
                    components.add(idTemp);
                    Element primGroup = this.svg_g2d.createElement("g");
                    this.svg_g2d.pushParent(primGroup);
                    primGroup.setAttribute("id", groupIdentifier + "_" + idTemp);
                    primGroup.setAttribute("style", "visibility:visible;");
                    this.svg_g2d.setDeferStrokColor(primGroup);
                }
            } else {
                Object designObject = null;
                if (this.getElementFromSource(sourceObject, StructureType.TITLE) != null) {
                    designObject = sourceObject.getSource();
                } else if (this.getElementFromSource(sourceObject, StructureType.CHART_BLOCK) != null) {
                    designObject = sourceObject.getSource();
                } else if (this.getElementFromSource(sourceObject, StructureType.PLOT) != null) {
                    designObject = sourceObject.getSource();
                } else if (this.getElementFromSource(sourceObject, StructureType.AXIS) != null) {
                    designObject = sourceObject.getSource();
                }
                if (designObject != null) {
                    String groupIdentifier = String.valueOf(designObject.hashCode());
                    String id = Integer.toString(pre.hashCode());
                    ArrayList<String> components = (ArrayList<String>)this.componentPrimitives.get(designObject);
                    if (components == null) {
                        components = new ArrayList<String>();
                        this.componentPrimitives.put(designObject, components);
                    }
                    String idTemp = id;
                    int counter = 1;
                    while (components.contains(idTemp)) {
                        idTemp = id + "@" + counter;
                        ++counter;
                    }
                    components.add(idTemp);
                    Element primGroup = this.svg_g2d.createElement("g");
                    this.svg_g2d.pushParent(primGroup);
                    primGroup.setAttribute("id", groupIdentifier + "_" + idTemp);
                    primGroup.setAttribute("style", "visibility:visible;");
                    this.svg_g2d.setDeferStrokColor(primGroup);
                }
            }
        }
    }

    protected void ungroupPrimitive(PrimitiveRenderEvent pre, boolean drawText) {
        if (this._iun == null) {
            logger.log(2, Messages.getString("exception.missing.component.interaction", this.getULocale()));
            return;
        }
        if (pre.getSource() instanceof StructureSource) {
            StructureSource sourceObject = (StructureSource)pre.getSource();
            Series series = (Series)this.getElementFromSource(sourceObject, StructureType.SERIES);
            if (series != null) {
                if (drawText) {
                    this.svg_g2d.popParent();
                    this.svg_g2d.popParent();
                } else {
                    this.svg_g2d.setDeferStrokColor(null);
                    this.svg_g2d.popParent();
                }
            } else if (this.getElementFromSource(sourceObject, StructureType.TITLE) != null || this.getElementFromSource(sourceObject, StructureType.AXIS) != null || this.getElementFromSource(sourceObject, StructureType.CHART_BLOCK) != null || this.getElementFromSource(sourceObject, StructureType.PLOT) != null) {
                this.svg_g2d.setDeferStrokColor(null);
                this.svg_g2d.popParent();
            }
        }
    }

    private Object getElementFromSource(StructureSource src, StructureType type) {
        if (src instanceof WrappedStructureSource) {
            WrappedStructureSource wss = (WrappedStructureSource)src;
            while (wss != null) {
                if (wss.getType() == type) {
                    return wss.getSource();
                }
                if (wss.getParent().getType() == type) {
                    return wss.getParent().getSource();
                }
                if (wss.getParent() instanceof WrappedStructureSource) {
                    wss = (WrappedStructureSource)wss.getParent();
                    continue;
                }
                wss = null;
            }
        } else if (src.getType() == type) {
            return src.getSource();
        }
        return null;
    }

    private Series findCategorySeries(Series seDT) {
        Chart cmDT = this._iun.getDesignTimeModel();
        if (cmDT instanceof ChartWithAxes) {
            return (Series)((SeriesDefinition)((ChartWithAxes)cmDT).getBaseAxes()[0].getSeriesDefinitions().get(0)).getRunTimeSeries().get(0);
        }
        return (Series)((SeriesDefinition)((ChartWithoutAxes)cmDT).getSeriesDefinitions().get(0)).getRunTimeSeries().get(0);
    }

    public void prepareInteractiveEvent(Element elm, InteractionEvent ie, Trigger[] triggers) {
        this.cacheEvents.add(new CacheEvent(elm, ie.getStructureSource(), triggers));
    }

    public void addInteractivity() {
        Iterator iter = this.cacheEvents.iterator();
        while (iter.hasNext()) {
            CacheEvent cEvent = (CacheEvent)iter.next();
            this.addEventHandling(cEvent.getElement(), cEvent.getSource(), cEvent.getTriggers());
        }
    }

    private void addEventHandling(Element elm, StructureSource src, Trigger[] triggers) {
        if (elm != null) {
            Trigger tg;
            boolean redirect = false;
            for (int x = 0; x < triggers.length; ++x) {
                tg = triggers[x];
                if (tg.getAction().getType().getValue() != 0) continue;
                redirect = true;
                break;
            }
            if (redirect) {
                Element aLink = this.svg_g2d.createElement("a");
                Element group = this.svg_g2d.createElement("g");
                group.appendChild(elm);
                aLink.setAttribute("xlink:href", "");
                aLink.appendChild(group);
                elm = group;
                this.hotspotLayer.appendChild(aLink);
            } else {
                this.hotspotLayer.appendChild(elm);
            }
            block7: for (int x = 0; x < triggers.length; ++x) {
                tg = triggers[x];
                String scriptEvent = this.getJsScriptEvent(tg.getCondition().getValue());
                if (scriptEvent == null) continue;
                switch (tg.getAction().getType().getValue()) {
                    case 1: {
                        String tooltipText = ((TooltipValue)tg.getAction().getValue()).getText();
                        if (tooltipText == null || tooltipText.trim().length() <= 0) continue block7;
                        Element title = this.svg_g2d.dom.createElement("title");
                        title.appendChild(this.svg_g2d.dom.createTextNode(tooltipText));
                        elm.appendChild(title);
                        if (scriptEvent.equals("onmouseover")) {
                            elm.setAttribute("onmouseout", "TM.remove()");
                            elm.setAttribute("onmousemove", "TM.show(evt)");
                            continue block7;
                        }
                        elm.setAttribute(scriptEvent, "TM.toggleToolTip(evt)");
                        continue block7;
                    }
                    case 0: {
                        URLValue urlValue = (URLValue)tg.getAction().getValue();
                        if (urlValue.getBaseUrl().startsWith("#")) {
                            elm.setAttribute(scriptEvent, "top.document.location.hash='" + urlValue.getBaseUrl() + "';");
                            elm.setAttribute("style", "cursor:pointer");
                            continue block7;
                        }
                        String target = urlValue.getTarget();
                        if (target == null) {
                            target = "null";
                        }
                        elm.setAttribute(scriptEvent, "redirect('" + target + "','" + urlValue.getBaseUrl() + "')");
                        continue block7;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        this.addJSCodeOnElement(src, tg, elm, scriptEvent, tg.getAction().getType().getValue());
                        continue block7;
                    }
                    case 3: {
                        if (tg.getCondition().equals(TriggerCondition.ACCESSIBILITY_LITERAL)) {
                            AccessibilityValue accessValue = (AccessibilityValue)tg.getAction().getValue();
                            if (accessValue.getText() != null) {
                                Element title = this.svg_g2d.createElement("title");
                                title.appendChild(this.svg_g2d.dom.createTextNode(accessValue.getText()));
                                elm.appendChild(title);
                            }
                            if (accessValue.getAccessibility() == null) continue block7;
                            Element description = this.svg_g2d.createElement("desc");
                            description.appendChild(this.svg_g2d.dom.createTextNode(accessValue.getAccessibility()));
                            elm.appendChild(description);
                            continue block7;
                        }
                        String script = ((ScriptValue)tg.getAction().getValue()).getScript();
                        String callbackFunction = "callback" + Math.abs(script.hashCode()) + "(evt," + src.getSource().hashCode() + ");";
                        elm.setAttribute(scriptEvent, callbackFunction);
                        this.setCursor(elm);
                        if (this.scripts.contains(script)) continue block7;
                        this.svg_g2d.addScript("function callback" + Math.abs(script.hashCode()) + "(evt,source)" + "{" + script + "}");
                        this.scripts.add(script);
                    }
                }
            }
        }
    }

    private final Series findDesignTimeSeries(Series seRT) throws ChartException {
        Series seDT = null;
        Chart cmRT = this._iun.getRunTimeModel();
        Chart cmDT = this._iun.getDesignTimeModel();
        if (cmDT instanceof ChartWithAxes) {
            EList elSE;
            SeriesDefinition sd;
            ChartWithAxes cwaRT = (ChartWithAxes)cmRT;
            ChartWithAxes cwaDT = (ChartWithAxes)cmDT;
            Axis[] axaBase = cwaRT.getPrimaryBaseAxes();
            Axis axBase = axaBase[0];
            Axis[] axaOrthogonal = cwaRT.getOrthogonalAxes(axBase, true);
            Series se = null;
            int i = -1;
            int j = 0;
            int k = 0;
            boolean bFound = false;
            EList elSD = axaBase[0].getSeriesDefinitions();
            for (j = 0; j < elSD.size(); ++j) {
                sd = (SeriesDefinition)elSD.get(j);
                elSE = sd.getSeries();
                for (k = 0; k < elSE.size(); ++k) {
                    se = (Series)elSE.get(k);
                    if (seRT != se) continue;
                    bFound = true;
                    break;
                }
                if (bFound) break;
            }
            if (!bFound) {
                for (i = 0; i < axaOrthogonal.length; ++i) {
                    elSD = axaOrthogonal[i].getSeriesDefinitions();
                    for (j = 0; j < elSD.size(); ++j) {
                        sd = (SeriesDefinition)elSD.get(j);
                        elSE = sd.getSeries();
                        for (k = 0; k < elSE.size(); ++k) {
                            se = (Series)elSE.get(k);
                            if (seRT != se) continue;
                            bFound = true;
                            break;
                        }
                        if (bFound) break;
                    }
                    if (bFound) break;
                }
            }
            if (!bFound) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 8, "info.cannot.find.series", new Object[]{seRT}, org.eclipse.birt.chart.device.extension.i18n.Messages.getResourceBundle((ULocale)this.getULocale()));
            }
            axaBase = cwaDT.getPrimaryBaseAxes();
            axBase = axaBase[0];
            axaOrthogonal = cwaDT.getOrthogonalAxes(axBase, true);
            elSD = i == -1 ? axaBase[0].getSeriesDefinitions() : axaOrthogonal[i].getSeriesDefinitions();
            sd = (SeriesDefinition)elSD.get(j);
            elSE = sd.getSeries();
            seDT = (Series)elSE.get(k);
        } else if (cmDT instanceof ChartWithoutAxes) {
            EList elSE;
            SeriesDefinition sd;
            ChartWithoutAxes cwoaRT = (ChartWithoutAxes)cmRT;
            ChartWithoutAxes cwoaDT = (ChartWithoutAxes)cmDT;
            Series se = null;
            int i = -1;
            int j = 0;
            int k = 0;
            boolean bFound = false;
            EList elSD = cwoaRT.getSeriesDefinitions();
            for (j = 0; j < elSD.size(); ++j) {
                sd = (SeriesDefinition)elSD.get(j);
                elSE = sd.getSeries();
                for (k = 0; k < elSE.size(); ++k) {
                    se = (Series)elSE.get(k);
                    if (seRT != se) continue;
                    bFound = true;
                    break;
                }
                if (bFound) break;
            }
            if (!bFound) {
                i = 1;
                elSD = ((SeriesDefinition)cwoaRT.getSeriesDefinitions().get(0)).getSeriesDefinitions();
                for (j = 0; j < elSD.size(); ++j) {
                    sd = (SeriesDefinition)elSD.get(j);
                    elSE = sd.getSeries();
                    for (k = 0; k < elSE.size(); ++k) {
                        se = (Series)elSE.get(k);
                        if (seRT != se) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound) break;
                }
            }
            if (!bFound) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 8, "info.cannot.find.series", new Object[]{seRT}, org.eclipse.birt.chart.device.extension.i18n.Messages.getResourceBundle((ULocale)this.getULocale()));
            }
            elSD = i == -1 ? cwoaDT.getSeriesDefinitions() : ((SeriesDefinition)cwoaDT.getSeriesDefinitions().get(0)).getSeriesDefinitions();
            sd = (SeriesDefinition)elSD.get(j);
            elSE = sd.getSeries();
            seDT = (Series)elSE.get(k);
        }
        return seDT;
    }

    private String getJsScriptEvent(int condition) {
        switch (condition) {
            case 0: {
                return "onmouseover";
            }
            case 1: {
                return "onclick";
            }
            case 2: {
                return "onclick";
            }
            case 3: {
                return "onclick";
            }
            case 4: {
                return "onmousedown";
            }
            case 5: {
                return "onmouseup";
            }
            case 6: {
                return "onmouseover";
            }
            case 7: {
                return "onmousemove";
            }
            case 8: {
                return "onmouseout";
            }
            case 9: {
                return "onfocusin";
            }
            case 10: {
                return "onfocusout";
            }
            case 11: {
                return "onkeydown";
            }
            case 12: {
                return "onkeypress";
            }
            case 13: {
                return "onkeyup";
            }
            case 15: {
                return "onload";
            }
        }
        return null;
    }

    protected void setCursor(Element currentElement) {
        String style = currentElement.getAttribute("style");
        if (style == null) {
            style = "";
        }
        currentElement.setAttribute("style", style + "cursor:pointer;");
    }

    public void clear() {
        this.labelPrimitives.clear();
        this.componentPrimitives.clear();
        this.scripts.clear();
    }

    public Node getHotspotLayer() {
        return this.hotspotLayer;
    }

    public void createHotspotLayer(Document dom) {
        this.hotspotLayer = dom.createElement("g");
        this.hotspotLayer.setAttribute("id", "hotSpots");
        this.hotspotLayer.setAttribute("style", "fill-opacity:0.01;fill:#FFFFFF;");
    }

    private ULocale getULocale() {
        return this.locale;
    }

    private boolean isColoredByCategories() {
        return this._iun.getRunTimeModel().getLegend().getItemType() == LegendItemType.CATEGORIES_LITERAL;
    }

    private void addJSCodeOnElement(StructureSource src, Trigger tg, Element elm, String scriptEvent, int type) {
        Series seRT = (Series)this.getElementFromSource(src, StructureType.SERIES);
        if (seRT != null) {
            Series seDT = null;
            String groupIdentifier = null;
            if (this.isColoredByCategories()) {
                seDT = this.findCategorySeries(seRT);
                int baseIndex = ((DataPointHints)src.getSource()).getIndex();
                StringBuffer sb = new StringBuffer();
                sb.append("'");
                sb.append(seDT.hashCode());
                sb.append("index");
                sb.append(baseIndex);
                sb.append("'");
                groupIdentifier = sb.toString();
            } else {
                try {
                    seDT = this.findDesignTimeSeries(seRT);
                }
                catch (ChartException e) {
                    logger.log((Exception)((Object)e));
                    return;
                }
                groupIdentifier = String.valueOf(seDT.hashCode());
            }
            boolean includeLabels = false;
            boolean includeGraphics = false;
            String jsFunction = null;
            switch (type) {
                case 2: {
                    jsFunction = "toggleVisibility(evt, ";
                    includeLabels = true;
                    includeGraphics = true;
                    break;
                }
                case 6: {
                    jsFunction = "toggleLabelsVisibility(evt, ";
                    includeLabels = true;
                    includeGraphics = false;
                    break;
                }
                case 4: {
                    jsFunction = "highlight(evt, ";
                    includeLabels = true;
                    includeGraphics = true;
                }
            }
            if (jsFunction == null) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return;
            }
            if (includeGraphics || includeLabels) {
                StringBuffer sb = new StringBuffer();
                sb.append(groupIdentifier);
                sb.append(",new Array(");
                List labelComponents = (List)this.labelPrimitives.get(seDT);
                List components = (List)this.componentPrimitives.get(seDT);
                Iterator iter = null;
                if (includeGraphics && components != null) {
                    iter = components.iterator();
                    this.appendArguments(sb, iter);
                    if (includeLabels && labelComponents != null) {
                        sb.append("), new Array(");
                    }
                }
                if (includeLabels && labelComponents != null) {
                    iter = labelComponents.iterator();
                    this.appendArguments(sb, iter);
                }
                sb.append(")");
                elm.setAttribute(scriptEvent, jsFunction + sb.toString() + ")");
                if (tg.getCondition().getValue() == 6) {
                    elm.setAttribute("onmouseout", jsFunction + sb.toString() + ")");
                }
                this.setCursor(elm);
            }
        } else {
            Object designObject = null;
            if (this.getElementFromSource(src, StructureType.TITLE) != null) {
                designObject = src.getSource();
            } else if (this.getElementFromSource(src, StructureType.PLOT) != null) {
                designObject = src.getSource();
            } else if (this.getElementFromSource(src, StructureType.CHART_BLOCK) != null) {
                designObject = src.getSource();
            } else if (this.getElementFromSource(src, StructureType.AXIS) != null) {
                designObject = src.getSource();
            }
            if (designObject != null) {
                String jsFunction = null;
                switch (type) {
                    case 2: {
                        jsFunction = "toggleVisibility(evt, ";
                        break;
                    }
                    case 4: {
                        jsFunction = "highlight(evt, ";
                    }
                }
                if (jsFunction == null) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    return;
                }
                List components = (List)this.componentPrimitives.get(designObject);
                Iterator iter = null;
                if (components != null) {
                    String groupIdentifier = String.valueOf(designObject.hashCode());
                    StringBuffer sb = new StringBuffer();
                    sb.append(groupIdentifier);
                    sb.append(",new Array(");
                    iter = components.iterator();
                    this.appendArguments(sb, iter);
                    sb.append(")");
                    elm.setAttribute(scriptEvent, jsFunction + sb.toString() + ")");
                    if (tg.getCondition().getValue() == 6) {
                        elm.setAttribute("onmouseout", jsFunction + sb.toString() + ")");
                    }
                    this.setCursor(elm);
                }
            }
        }
    }

    private void appendArguments(StringBuffer sb, Iterator iter) {
        if (iter != null) {
            while (iter.hasNext()) {
                sb.append("'").append(iter.next()).append("'");
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
        }
    }

    static {
        $assertionsDisabled = !SVGInteractiveRenderer.class.desiredAssertionStatus();
        logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.svg/trace");
    }
}

