/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.PlotWith3DAxes;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.render.ISeriesRenderingHints3D;

public final class SeriesRenderingHints3D
implements ISeriesRenderingHints3D {
    private int iDataSetStructure = 0;
    private final double dXAxisLocation;
    private final double dZAxisLocation;
    private final double dPlotZeroLocation;
    private final double dPlotBaseLocation;
    private final double dPlotHeight;
    private final double[] daXTickCoordinates;
    private final double[] daZTickCoordinates;
    private final DataPointHints[] dpa;
    private final AutoScale scBase;
    private final AutoScale scOrthogonal;
    private final AutoScale scAncillary;
    private final PlotWith3DAxes pwa;
    private final DataSetIterator dsiBase;
    private final DataSetIterator dsiOrthogonal;
    private final DataSetIterator dsiAncillary;

    public SeriesRenderingHints3D(PlotWith3DAxes _pwa, double _dXAxisLocation, double _dZAxisLocation, double _dPlotBaseLocation, double _dPlotZeroLocation, double _dPlotHeight, double[] _daXTickCoordinates, double[] _daZTickCoordinates, DataPointHints[] _dpa, AutoScale _scBase, AutoScale _scOrthogonal, AutoScale _scAncillary, DataSetIterator _dsiBase, DataSetIterator _dsiOrthogonal, DataSetIterator _dsiAncillary) {
        this.pwa = _pwa;
        this.dXAxisLocation = _dXAxisLocation;
        this.dZAxisLocation = _dZAxisLocation;
        this.dPlotZeroLocation = _dPlotZeroLocation;
        this.dPlotBaseLocation = _dPlotBaseLocation;
        this.dPlotHeight = _dPlotHeight;
        this.daXTickCoordinates = _daXTickCoordinates;
        this.daZTickCoordinates = _daZTickCoordinates;
        this.dpa = _dpa;
        this.scBase = _scBase;
        this.scOrthogonal = _scOrthogonal;
        this.scAncillary = _scAncillary;
        this.dsiBase = _dsiBase;
        this.dsiOrthogonal = _dsiOrthogonal;
        this.dsiAncillary = _dsiAncillary;
        this.iDataSetStructure = this.dsiBase.size() != this.dsiOrthogonal.size() ? (this.iDataSetStructure |= 2) : 1;
        this.iDataSetStructure = this.dsiBase.size() != this.dsiAncillary.size() ? (this.iDataSetStructure |= 0x20) : 16;
        if (this.dsiBase.isEmpty()) {
            this.iDataSetStructure |= 4;
        }
        if (this.dsiOrthogonal.isEmpty()) {
            this.iDataSetStructure |= 8;
        }
        if (this.dsiAncillary.isEmpty()) {
            this.iDataSetStructure |= 0x40;
        }
    }

    public int getDataSetStructure() {
        return this.iDataSetStructure;
    }

    public DataSetIterator getBaseDataSet() {
        return this.dsiBase;
    }

    public DataSetIterator getOrthogonalDataSet() {
        return this.dsiOrthogonal;
    }

    public DataSetIterator getSeriesDataSet() {
        return this.dsiAncillary;
    }

    public final double getXAxisLocation() {
        return this.dXAxisLocation;
    }

    public final double getZAxisLocation() {
        return this.dZAxisLocation;
    }

    public final double getPlotZeroLocation() {
        return this.dPlotZeroLocation;
    }

    public final double getLocationOnOrthogonal(Object oValue) throws ChartException, IllegalArgumentException {
        return Methods.getLocation(this.scOrthogonal, oValue);
    }

    public final double getPlotBaseLocation() {
        return this.dPlotBaseLocation;
    }

    public final double getPlotHeight() {
        return this.dPlotHeight;
    }

    public final double[] getXTickCoordinates() {
        return this.daXTickCoordinates;
    }

    public final double[] getZTickCoordinates() {
        return this.daZTickCoordinates;
    }

    public final DataPointHints[] getDataPoints() {
        return this.dpa;
    }

    public final boolean isXCategoryScale() {
        return this.scBase.getType() == 16 || this.scBase.isCategoryScale();
    }

    public final boolean isZCategoryScale() {
        return this.scAncillary.getType() == 16 || this.scAncillary.isCategoryScale();
    }

    public final Position getLabelPosition(Series se) throws ChartException, IllegalArgumentException {
        if (!se.isSetLabelPosition()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 13, "exception.undefined.data.label.position", new Object[]{se}, Messages.getResourceBundle(this.pwa.getRunTimeContext().getULocale()));
        }
        int iTransposed = this.pwa.transposeLabelPosition(2, Methods.getLabelPosition(se.getLabelPosition()));
        Position p = null;
        switch (iTransposed) {
            case 1: {
                p = Position.LEFT_LITERAL;
                break;
            }
            case 2: {
                p = Position.RIGHT_LITERAL;
                break;
            }
            case 3: {
                p = Position.ABOVE_LITERAL;
                break;
            }
            case 4: {
                p = Position.BELOW_LITERAL;
                break;
            }
            case 5: {
                p = Position.OUTSIDE_LITERAL;
                break;
            }
            case 6: {
                p = Position.INSIDE_LITERAL;
            }
        }
        return p;
    }

    public final Label getLabelAttributes(Series se) throws IllegalArgumentException {
        return LabelImpl.copyInstance(se.getLabel());
    }

    public final Bounds getClientAreaBounds(boolean bReduceByInsets) {
        Bounds boClientArea = BoundsImpl.copyInstance(this.pwa.getPlotBounds());
        if (bReduceByInsets) {
            boClientArea.adjust(this.pwa.getPlotInsets());
        }
        return boClientArea;
    }
}

