/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withoutaxes;

import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.withoutaxes.PlotWithoutAxes;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;

public class SeriesRenderingHints
implements ISeriesRenderingHints {
    private int iDataSetStructure = 0;
    private final DataSetIterator dsiBase;
    private final DataSetIterator dsiOrthogonal;
    private final DataPointHints[] dpha;
    private final PlotWithoutAxes pwoa;

    SeriesRenderingHints(PlotWithoutAxes pwoa, DataPointHints[] dpha, DataSetIterator dsiBase, DataSetIterator dsiOrthogonal) {
        this.pwoa = pwoa;
        this.dpha = dpha;
        this.dsiBase = dsiBase;
        this.dsiOrthogonal = dsiOrthogonal;
        this.iDataSetStructure = dsiBase.size() != dsiOrthogonal.size() ? (this.iDataSetStructure |= 2) : 1;
        if (dsiBase.isEmpty()) {
            this.iDataSetStructure |= 4;
        }
        if (dsiOrthogonal.isEmpty()) {
            this.iDataSetStructure |= 8;
        }
    }

    public final DataPointHints[] getDataPoints() {
        return this.dpha;
    }

    public final Double[] asDoubleValues() throws ChartException {
        int iCount = this.dpha.length;
        Double[] doa = new Double[iCount];
        for (int i = 0; i < iCount; ++i) {
            Object o = this.dpha[i].getOrthogonalValue();
            if (o instanceof NumberDataElement) {
                NumberDataElement nde = (NumberDataElement)o;
                doa[i] = new Double(nde.getValue());
                continue;
            }
            if (o == null) {
                doa[i] = null;
                continue;
            }
            throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.dataset.non.numerical.to.numerical", new Object[]{o}, Messages.getResourceBundle(this.pwoa.getRunTimeContext().getULocale()));
        }
        return doa;
    }

    public final double[] asPrimitiveDoubleValues() throws ChartException {
        int iCount = this.dpha.length;
        double[] doa = new double[iCount];
        for (int i = 0; i < iCount; ++i) {
            Object o = this.dpha[i].getOrthogonalValue();
            if (o instanceof Double) {
                doa[i] = (Double)o;
                continue;
            }
            if (o == null) {
                doa[i] = Double.NaN;
                continue;
            }
            throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.dataset.non.numerical.to.numerical", new Object[]{o}, Messages.getResourceBundle(this.pwoa.getRunTimeContext().getULocale()));
        }
        return doa;
    }

    public int getDataSetStructure() {
        return this.iDataSetStructure;
    }

    public DataSetIterator getBaseDataSet() {
        return this.dsiBase;
    }

    public DataSetIterator getOrthogonalDataSet() {
        return this.dsiOrthogonal;
    }

    public Bounds getClientAreaBounds(boolean bReduceByInsets) {
        Bounds boClientArea = BoundsImpl.copyInstance(this.pwoa.getBounds());
        if (bReduceByInsets) {
            boClientArea.adjust(this.pwoa.getCellInsets());
        }
        return boClientArea;
    }
}

