/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class XMLDataInputStream
extends InputStream {
    private InputStream inputStream;
    private URL url;
    private static final String TEMPFILENAME = "tempXMLData";

    XMLDataInputStream(URL url) throws OdaException {
        this.url = url;
        try {
            this.inputStream = new BufferedInputStream(url.openStream());
        }
        catch (IOException e) {
            throw new OdaException(e.getLocalizedMessage());
        }
    }

    public XMLDataInputStream(InputStream is) throws OdaException {
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            int abyte;
            File file = this.createFileWithUniqueName();
            FileOutputStream fos = new FileOutputStream(file);
            while ((abyte = bis.read()) != -1) {
                fos.write(abyte);
            }
            fos.close();
            this.url = file.toURL();
            this.inputStream = new BufferedInputStream(this.url.openStream());
        }
        catch (IOException e) {
            throw new OdaException(e.getLocalizedMessage());
        }
    }

    private File createFileWithUniqueName() throws IOException {
        File file = File.createTempFile(TEMPFILENAME, null);
        file.deleteOnExit();
        return file;
    }

    public void reStart() throws IOException {
        this.inputStream.close();
        this.inputStream = new BufferedInputStream(this.url.openStream());
    }

    public int read() throws IOException {
        return this.inputStream.read();
    }
}

