/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CachePreferencePage
extends AbstractDescriptionPropertyPage {
    private boolean selected = false;
    private boolean radioSelected = false;
    private int rowCount;
    private int preCount = this.rowCount = 0;
    private int initialCount = this.rowCount;
    private final int ENTIRE_ROW_CACHE = -1;
    private final int UNUSED_ROW_CACHE = 0;
    private transient PropertyHandle rowCountHandle = null;
    private transient IBaseDataSetDesign dataSetDesign;
    private transient IBaseDataSourceDesign dataSourceDesign;
    private static String DEFAULT_MESSAGE = Messages.getString((String)"dataset.editor.cachePreference");

    public Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        Button previewNumCheckBox = new Button(composite, 32);
        GridData data = new GridData();
        data.horizontalSpan = 5;
        previewNumCheckBox.setLayoutData((Object)data);
        previewNumCheckBox.setText(Messages.getString((String)"CachePreferencePage.checkBox.text"));
        data = new GridData();
        data.horizontalSpan = 2;
        Label lab = new Label(composite, 0);
        lab.setLayoutData((Object)data);
        final Button numRadioBox = new Button(composite, 16);
        numRadioBox.setText(Messages.getString((String)"CachePreferencePage.radioBox.numText"));
        numRadioBox.setEnabled(false);
        data = new GridData();
        data.widthHint = 50;
        final Text numText = new Text(composite, 2048);
        numText.setEnabled(false);
        numText.setLayoutData((Object)data);
        numText.setData((Object)this.rowCountHandle);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString((String)"CachePreferencePage.label.text"));
        data = new GridData();
        data.horizontalSpan = 2;
        Label lab1 = new Label(composite, 0);
        lab1.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 3;
        final Button entireNumRadioBox = new Button(composite, 16);
        entireNumRadioBox.setLayoutData((Object)data);
        entireNumRadioBox.setEnabled(false);
        entireNumRadioBox.setText(Messages.getString((String)"CachePreferencePage.radioBox.entireNumText"));
        data = new GridData();
        data.horizontalSpan = 3;
        final Button clearButton = new Button(composite, 0);
        clearButton.setText(Messages.getString((String)"CachePreferencePage.button.clear"));
        clearButton.setLayoutData((Object)data);
        previewNumCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CachePreferencePage.this.selected = !CachePreferencePage.this.selected;
                numRadioBox.setEnabled(CachePreferencePage.this.selected);
                entireNumRadioBox.setEnabled(CachePreferencePage.this.selected);
                if (!CachePreferencePage.this.selected) {
                    CachePreferencePage.this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
                    numText.setEnabled(CachePreferencePage.this.selected);
                    CachePreferencePage.this.rowCount = 0;
                } else if (CachePreferencePage.this.radioSelected) {
                    numText.setEnabled(CachePreferencePage.this.selected);
                    CachePreferencePage.this.setRowCount(numText.getText());
                } else {
                    entireNumRadioBox.setSelection(CachePreferencePage.this.selected);
                    numRadioBox.setSelection(CachePreferencePage.this.radioSelected);
                    CachePreferencePage.this.rowCount = -1;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        numRadioBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CachePreferencePage.this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
                CachePreferencePage.this.radioSelected = numRadioBox.getSelection();
                numText.setEnabled(CachePreferencePage.this.radioSelected);
                CachePreferencePage.this.setRowCount(numText.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        entireNumRadioBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CachePreferencePage.this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
                if (entireNumRadioBox.getSelection()) {
                    CachePreferencePage.this.rowCount = -1;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        numText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CachePreferencePage.this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
                CachePreferencePage.this.setRowCount(numText.getText());
            }
        });
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CachePreferencePage.this.clearCache()) {
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"CachePreferencePage.messageBox.title"), (String)Messages.getString((String)"CachePreferencePage.messageBox.info"));
                    clearButton.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.initCachePreference();
        if (this.rowCount > 0) {
            this.selected = true;
            previewNumCheckBox.setSelection(this.selected);
            numRadioBox.setEnabled(true);
            numRadioBox.setSelection(true);
            numText.setEnabled(true);
            numText.setText(Integer.toString(this.rowCount));
            entireNumRadioBox.setEnabled(true);
        } else if (this.rowCount == 0) {
            previewNumCheckBox.setSelection(false);
        } else if (this.rowCount < 0) {
            previewNumCheckBox.setSelection(true);
            entireNumRadioBox.setSelection(true);
            this.selected = true;
            previewNumCheckBox.setSelection(this.selected);
            numRadioBox.setEnabled(true);
            entireNumRadioBox.setEnabled(true);
        }
        return composite;
    }

    private void setRowCount(String count) {
        try {
            this.rowCount = Integer.parseInt(count);
        }
        catch (NumberFormatException ex) {
            this.getContainer().setMessage(Messages.getString((String)"dataset.editor.cachePreference.errorNumberFormat"), 3);
            this.rowCount = 0;
        }
        if (this.rowCount <= 0) {
            this.getContainer().setMessage(Messages.getString((String)"dataset.editor.cachePreference.errorNumberFormat"), 3);
        }
    }

    private void initCachePreference() {
        this.rowCount = ((DataSetHandle)this.getContainer().getModel()).getCachedRowCount();
        this.rowCountHandle = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("cachedRowCount");
        this.preCount = this.rowCount;
        this.initialCount = this.rowCount;
    }

    public boolean clearCache() {
        try {
            DataEngine dataEngine = DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)3, null, null, null));
            dataEngine.clearCache(this.dataSourceDesign, this.dataSetDesign);
        }
        catch (BirtException e) {
            e.printStackTrace();
            return true;
        }
        return true;
    }

    public boolean clearCacheOnExit() {
        if (this.initialCount != this.rowCount) {
            return this.clearCache();
        }
        return true;
    }

    public void pageActivated() {
        this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public boolean canLeave() {
        if (this.canFinish()) {
            return super.performOk();
        }
        return false;
    }

    public boolean canFinish() {
        if (this.selected && this.rowCount == 0 || this.selected && this.radioSelected && this.rowCount <= 0) {
            this.getContainer().setMessage(Messages.getString((String)"dataset.editor.cachePreference.errorNumberFormat"), 3);
            return false;
        }
        if (this.preCount != this.rowCount && this.rowCountHandle != null) {
            try {
                this.rowCountHandle.clearValue();
                this.rowCountHandle.setIntValue(this.rowCount);
                this.preCount = this.rowCount;
            }
            catch (SemanticException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean performOk() {
        if (this.canFinish()) {
            return super.performOk();
        }
        return false;
    }

    public void setBaseDesign(IBaseDataSetDesign baseDataSetDesign, IBaseDataSourceDesign baseDataSourceDesign) {
        this.dataSetDesign = baseDataSetDesign;
        this.dataSourceDesign = baseDataSourceDesign;
    }

    public String getToolTip() {
        return Messages.getString((String)"CachePreferencePage.Filter.Tooltip");
    }
}

